/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contest.ContestConstants;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class PracticeSystestResultsSummaryPanel
extends TablePanel {
    private static final String[] headers = new String[]{"Problem", "Test Case", "Success", "Args", "Expected", "Received", "Time", "Memory"};
    private List items = new ArrayList();
    private boolean enabled = true;
    private static ProblemComponentModel[] components = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void reset() {
        this.items.clear();
        RoomModel roomModel = this.ca.getModel().getCurrentRoom();
        RoundModel roundModel = roomModel.getRoundModel();
        components = roundModel.getAssignedComponents(roomModel.getDivisionID());
    }

    public void update(PracticeSystemTestResultResponse practiceSystemTestResultResponse) {
        this.items.add(practiceSystemTestResultResponse);
        this.getTableModel().update((Collection)this.items);
    }

    protected String getTableName() {
        return "result_table";
    }

    protected String getMenuName() {
        return "result_table_menu";
    }

    public PracticeSystestResultsSummaryPanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new PracticeSystestSummaryTableModel());
        this.table.addEventListener("Mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (PracticeSystestResultsSummaryPanel.this.enabled) {
                    PracticeSystestResultsSummaryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PracticeSystestResultsSummaryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.table.addEventListener("Key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (PracticeSystestResultsSummaryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    PracticeSystestResultsSummaryPanel.this.openMessageEvent();
                }
            }
        });
        uIPage.getComponent("result_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PracticeSystestResultsSummaryPanel.this.openMessageEvent();
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private synchronized void openMessageEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n == -1) {
            return;
        }
        PracticeSystemTestResultResponse practiceSystemTestResultResponse = (PracticeSystemTestResultResponse)this.tableModel.get(n);
        String string = "";
        string = string + "Problem: " + PracticeSystestResultsSummaryPanel.getCompVal(practiceSystemTestResultResponse.getResultData().getComponentId()) + "\n";
        string = string + "Test Case: " + practiceSystemTestResultResponse.getResultData().getTestCaseIndex() + "\n";
        string = string + "Succeeded: " + (practiceSystemTestResultResponse.getResultData().isSucceeded() ? "Yes" : "No") + "\n";
        string = string + "Execution Time: ";
        long l = practiceSystemTestResultResponse.getResultData().getExecTime();
        string = l < 1000L ? string + "" + l + " ms\n" : string + (double)l / 1000.0 + "s\n";
        long l2 = practiceSystemTestResultResponse.getResultData().getMaxMemoryUsed();
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        string = string + "Peak memory used: " + decimalFormat.format((double)l2 / 1024.0) + "MB\n";
        string = string + "Args:\n" + ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getArgs()) + "\n\n";
        string = string + "Expected:\n" + ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getExpectedValue()) + "\n\n";
        string = practiceSystemTestResultResponse.getResultData().getReturnValue() == null ? string + "Received:\n" + practiceSystemTestResultResponse.getResultData().getMessage() + "\n" : string + "Received:\n" + ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getReturnValue()) + "\n";
        if (!practiceSystemTestResultResponse.getResultData().isSucceeded()) {
            string = string + "\nAnswer checking result:\n" + practiceSystemTestResultResponse.getResultData().getCheckAnswerResponse() + "\n";
        }
        this.ca.popup(0, "Practice System Test Case Info", string);
    }

    public static int getCompVal(int n) {
        for (int i = 0; i < components.length; ++i) {
            if (n != components[i].getID().intValue()) continue;
            return components[i].getPoints().intValue();
        }
        return 0;
    }

    static class PracticeSystestSummaryTableModel
    extends SortedTableModel {
        public PracticeSystestSummaryTableModel() {
            super(headers, new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PracticeSystestResultsSummaryPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PracticeSystestResultsSummaryPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PracticeSystestResultsSummaryPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PracticeSystestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PracticeSystestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PracticeSystestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PracticeSystestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PracticeSystestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.addSortElement(new SortElement(0, true));
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            this.addSortElement(new SortElement(6, true));
            this.addSortElement(new SortElement(7, true));
        }

        public Object getValueAt(int n, int n2) {
            PracticeSystemTestResultResponse practiceSystemTestResultResponse = (PracticeSystemTestResultResponse)this.get(n);
            switch (n2) {
                case 0: {
                    return new Integer(PracticeSystestResultsSummaryPanel.getCompVal(practiceSystemTestResultResponse.getResultData().getComponentId()));
                }
                case 1: {
                    return new Integer(practiceSystemTestResultResponse.getResultData().getTestCaseIndex());
                }
                case 2: {
                    return new Boolean(practiceSystemTestResultResponse.getResultData().isSucceeded());
                }
                case 3: {
                    return ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getArgs());
                }
                case 4: {
                    return ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getExpectedValue());
                }
                case 5: {
                    if (practiceSystemTestResultResponse.getResultData().getReturnValue() == null) {
                        return practiceSystemTestResultResponse.getResultData().getMessage();
                    }
                    return ContestConstants.makePretty((Object)practiceSystemTestResultResponse.getResultData().getReturnValue());
                }
                case 6: {
                    long l = practiceSystemTestResultResponse.getResultData().getExecTime();
                    if (l < 1000L) {
                        return "" + l + " ms";
                    }
                    return "" + (double)l / 1000.0 + "s";
                }
                case 7: {
                    long l = practiceSystemTestResultResponse.getResultData().getMaxMemoryUsed();
                    DecimalFormat decimalFormat = new DecimalFormat("0.000");
                    if (l < 0L) {
                        return "N/A";
                    }
                    return decimalFormat.format((double)l / 1024.0) + "MB";
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            PracticeSystemTestResultResponse practiceSystemTestResultResponse = (PracticeSystemTestResultResponse)object;
            PracticeSystemTestResultResponse practiceSystemTestResultResponse2 = (PracticeSystemTestResultResponse)object2;
            Iterator iterator = this.getSortListIterator();
            block10: while (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        int n3 = PracticeSystestResultsSummaryPanel.getCompVal(practiceSystemTestResultResponse.getResultData().getComponentId());
                        int n4 = PracticeSystestResultsSummaryPanel.getCompVal(practiceSystemTestResultResponse2.getResultData().getComponentId());
                        int n5 = n4 - n3;
                        if (n5 == 0) continue block10;
                        return n2 * (n5 > 0 ? 1 : -1);
                    }
                    case 1: {
                        int n6 = practiceSystemTestResultResponse2.getResultData().getTestCaseIndex() - practiceSystemTestResultResponse.getResultData().getTestCaseIndex();
                        if (n6 == 0) continue block10;
                        return n2 * (n6 > 0 ? 1 : -1);
                    }
                    case 2: {
                        int n7 = practiceSystemTestResultResponse.getResultData().isSucceeded() ? 1 : 0;
                        int n4 = practiceSystemTestResultResponse2.getResultData().isSucceeded() ? 1 : 0;
                        int n8 = n4 - n7;
                        if (n8 == 0) continue block10;
                        return n2 * (n8 > 0 ? 1 : -1);
                    }
                    case 3: {
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                    case 5: {
                        continue block10;
                    }
                    case 6: {
                        long l = practiceSystemTestResultResponse.getResultData().getExecTime();
                        long l2 = practiceSystemTestResultResponse2.getResultData().getExecTime();
                        long l3 = l2 - l;
                        if (l3 == 0L) continue block10;
                        return n2 * (l3 > 0L ? 1 : -1);
                    }
                    case 7: {
                        long l = practiceSystemTestResultResponse.getResultData().getMaxMemoryUsed();
                        long l4 = practiceSystemTestResultResponse2.getResultData().getMaxMemoryUsed();
                        long l5 = l4 - l;
                        if (l5 == 0L) continue block10;
                        return n2 * (l5 > 0L ? 1 : -1);
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            return 0;
        }
    }
}

