/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.MessageDialog;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.response.CoderHistoryResponse;
import com.topcoder.netCommon.contestantMessages.response.data.CoderHistoryData;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CoderHistoryPanel
extends TablePanel {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private static final String[] headers = new String[]{"Time", "Action", "Coder", "Problem", "Points"};
    private boolean enabled = true;
    private final UIComponent frame;
    private final ContestApplet parent;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry;

    protected String getTableName() {
        return "coder_history_table";
    }

    protected String getMenuName() {
        return "coder_history_table_menu";
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public CoderHistoryPanel(ContestApplet contestApplet, UIPage uIPage, CoderHistoryResponse coderHistoryResponse, UIComponent uIComponent) {
        super(contestApplet, uIPage, new CoderHistoryTableModel(coderHistoryResponse.getHistoryData()));
        this.parent = contestApplet;
        this.frame = uIComponent;
        String string = coderHistoryResponse.getName();
        String string2 = string + "'s history";
        ((TitledBorder)uIPage.getComponent("coder_history_table_panel").getProperty("Border")).setTitle(string2);
        final TableCellRenderer tableCellRenderer = (TableCellRenderer)uIPage.getComponent("coder_history_score_column").getProperty("cellrenderer");
        uIPage.getComponent("coder_history_score_column").setProperty("cellrenderer", new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                CoderHistoryData coderHistoryData = (CoderHistoryData)CoderHistoryPanel.this.tableModel.get(n);
                if (coderHistoryData.getPoints() < 0.0) {
                    component.setForeground(Color.RED);
                } else {
                    component.setForeground(Color.GREEN);
                }
                return component;
            }
        });
        uIPage.getComponent("coder_history_user_renderer").setProperty("model", contestApplet.getModel());
        this.table.addEventListener("Mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CoderHistoryPanel.this.enabled) {
                    CoderHistoryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CoderHistoryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.table.addEventListener("Key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (CoderHistoryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    CoderHistoryPanel.this.openMessageEvent();
                }
            }
        });
        uIPage.getComponent("coder_history_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoderHistoryPanel.this.openMessageEvent();
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private void openMessageEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n == -1) {
            return;
        }
        CoderHistoryData coderHistoryData = (CoderHistoryData)this.tableModel.get(n);
        String string = coderHistoryData.getDetail();
        MessageDialog messageDialog = new MessageDialog(this.parent, this.frame, "Coder History Info", string);
        messageDialog.show();
    }

    static class CoderHistoryTableModel
    extends SortedTableModel {
        private static final NumberFormat SCORE_FORMAT = new DecimalFormat("0.00");

        public CoderHistoryTableModel(CoderHistoryData[] coderHistoryDataArray) {
            super(headers, new Class[]{class$java$lang$String == null ? (class$java$lang$String = CoderHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry == null ? (class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry = CoderHistoryPanel.class$("com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry")) : class$com$topcoder$client$contestApplet$uilogic$panels$table$UserNameEntry, class$java$lang$String == null ? (class$java$lang$String = CoderHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CoderHistoryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CoderHistoryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.addSortElement(new SortElement(0, true));
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            this.addSortElement(new SortElement(3, true));
            this.addSortElement(new SortElement(4, true));
            this.update(new ArrayList<CoderHistoryData>(Arrays.asList(coderHistoryDataArray)));
        }

        public Object getValueAt(int n, int n2) {
            CoderHistoryData coderHistoryData = (CoderHistoryData)this.get(n);
            switch (n2) {
                case 0: {
                    return DATE_FORMAT.format(coderHistoryData.getTime());
                }
                case 1: {
                    return coderHistoryData.getActionDescription();
                }
                case 2: {
                    UserListItem userListItem = coderHistoryData.getCoder();
                    return new UserNameEntry(userListItem.getUserName(), userListItem.getUserRating(), false, userListItem.getUserType());
                }
                case 3: {
                    if (coderHistoryData.getComponentValue() >= 0) {
                        return Integer.toString(coderHistoryData.getComponentValue());
                    }
                    return "N/A";
                }
                case 4: {
                    if (Double.isNaN(coderHistoryData.getPoints())) {
                        return "N/A";
                    }
                    return Common.formatScore(coderHistoryData.getPoints());
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            CoderHistoryData coderHistoryData = (CoderHistoryData)object;
            CoderHistoryData coderHistoryData2 = (CoderHistoryData)object2;
            Iterator iterator = this.getSortListIterator();
            block7: while (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        Date date;
                        Date date2 = coderHistoryData.getTime();
                        int n3 = date2.compareTo(date = coderHistoryData2.getTime());
                        if (n3 == 0) continue block7;
                        return n3;
                    }
                    case 1: {
                        int n4;
                        int n5 = coderHistoryData.getAction();
                        int n6 = n5 < (n4 = coderHistoryData2.getAction()) ? -1 : (n5 > n4 ? 1 : 0);
                        if (n6 == 0) continue block7;
                        return n6;
                    }
                    case 2: {
                        UserListItem userListItem;
                        UserListItem userListItem2 = coderHistoryData.getCoder();
                        int n7 = userListItem2.compareTo((Object)(userListItem = coderHistoryData2.getCoder()));
                        if (n7 == 0) continue block7;
                        return n7;
                    }
                    case 3: {
                        int n8 = coderHistoryData.getComponentValue();
                        int n9 = coderHistoryData2.getComponentValue();
                        int n10 = n9 - n8;
                        if (n10 == 0) continue block7;
                        return n2 * (n10 > 0 ? 1 : -1);
                    }
                    case 4: {
                        double d;
                        double d2 = coderHistoryData.getPoints();
                        int n11 = Double.compare(d2, d = coderHistoryData2.getPoints());
                        if (n11 == 0) continue block7;
                        return n11;
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            return 0;
        }
    }
}

