/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.BroadcastDialog;
import com.topcoder.client.contestApplet.uilogic.panels.TablePanel;
import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.BroadcastManager;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.ComponentBroadcast;
import com.topcoder.netCommon.contestantMessages.RoundBroadcast;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class BroadcastSummaryPanel
extends TablePanel {
    private static final String[] headers = new String[]{"T", "Time", "Status", "Message"};
    private boolean enabled = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected String getTableName() {
        return "summary_table";
    }

    protected String getMenuName() {
        return "summary_table_menu";
    }

    public BroadcastSummaryPanel(ContestApplet contestApplet, UIPage uIPage) {
        super(contestApplet, uIPage, new BroadcastSummaryTableModel(contestApplet.getModel().getBroadcastManager()));
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BroadcastSummaryPanel.this.enabled) {
                    BroadcastSummaryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BroadcastSummaryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.table.addEventListener("key", new UIKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (BroadcastSummaryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    BroadcastSummaryPanel.this.openBroadcastEvent();
                }
            }
        });
        uIPage.getComponent("summary_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BroadcastSummaryPanel.this.openBroadcastEvent();
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openBroadcastEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private synchronized void openBroadcastEvent() {
        int n = this.getTable().getSelectedRow();
        if (n == -1) {
            return;
        }
        AdminBroadcast adminBroadcast = (AdminBroadcast)this.tableModel.get(n);
        BroadcastDialog broadcastDialog = new BroadcastDialog(this.ca, adminBroadcast, false);
        broadcastDialog.show();
    }

    private static class BroadcastSummaryTableModel
    extends SortedTableModel
    implements BroadcastListener {
        private BroadcastManager manager;

        public void newBroadcast(AdminBroadcast adminBroadcast) {
            this.update(this.manager.getBroadcasts());
        }

        public void refreshBroadcasts() {
            this.update(this.manager.getBroadcasts());
        }

        public synchronized void readBroadcast(AdminBroadcast adminBroadcast) {
            this.update(this.manager.getBroadcasts());
        }

        public BroadcastSummaryTableModel(BroadcastManager broadcastManager) {
            super(headers, new Class[]{class$java$lang$String == null ? (class$java$lang$String = BroadcastSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = BroadcastSummaryPanel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = BroadcastSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BroadcastSummaryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.manager = broadcastManager;
            this.addSortElement(new SortElement(1, true));
            broadcastManager.addBroadcastListener(this, true);
        }

        public Object getValueAt(int n, int n2) {
            AdminBroadcast adminBroadcast = (AdminBroadcast)this.get(n);
            switch (n2) {
                case 0: {
                    if (adminBroadcast instanceof ComponentBroadcast) {
                        return "P";
                    }
                    if (adminBroadcast instanceof RoundBroadcast) {
                        return "R";
                    }
                    return "G";
                }
                case 1: {
                    return new Long(adminBroadcast.getTime());
                }
                case 2: {
                    return this.manager.hasRead(adminBroadcast) ? "Read" : "Unread";
                }
                case 3: {
                    return Common.htmlEncode(adminBroadcast.getMessage());
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            AdminBroadcast adminBroadcast = (AdminBroadcast)object;
            AdminBroadcast adminBroadcast2 = (AdminBroadcast)object2;
            Iterator iterator = this.getSortListIterator();
            if (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        int n3 = adminBroadcast.getType() - adminBroadcast2.getType();
                        return n2 * n3;
                    }
                    case 1: {
                        long l = adminBroadcast.getTime() - adminBroadcast2.getTime();
                        return n2 * (l > 0L ? 1 : -1);
                    }
                    case 2: {
                        boolean bl = this.manager.hasRead(adminBroadcast);
                        boolean bl2 = this.manager.hasRead(adminBroadcast2);
                        if (bl && !bl2) {
                            return -1;
                        }
                        if (!bl && bl2) {
                            return 1;
                        }
                        return 0;
                    }
                    case 3: {
                        int n4 = adminBroadcast.getMessage().compareTo(adminBroadcast2.getMessage());
                        return n2 * n4;
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            throw new IllegalStateException("Problem sorting broadcasts: " + this.getItemList());
        }
    }
}

