/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIItemListener;
import com.topcoder.client.ui.event.UIKeyAdapter;
import java.awt.Color;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class SourceFindDialog
extends UIKeyAdapter
implements UIItemListener,
UIActionListener,
FrameLogic {
    private static final LocalPreferences localPref = LocalPreferences.getInstance();
    private UIPage page;
    private UIComponent frame;
    private UIComponent dial;
    private UIComponent target;
    private String text;
    private boolean backwardDir = false;
    private boolean ignoreCase = true;
    private boolean wrapAround = true;
    private boolean closeAfterFind = true;
    private boolean syntaxHighlight = false;
    private UIComponent findField;
    private UIComponent findOption;
    private UIComponent caseOption;
    private UIComponent wrapOption;
    private UIComponent closeOption;
    private UIComponent findButton;
    private Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"));

    public UIComponent getFrame() {
        return this.dial;
    }

    public SourceFindDialog(ContestApplet contestApplet, UIComponent uIComponent, UIComponent uIComponent2) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("source_find_dialog", true);
        this.frame = uIComponent;
        while (this.frame.getParent() != null) {
            this.frame = this.frame.getParent();
        }
        this.dial = this.page.getComponent("root_dialog", false);
        this.dial.setProperty("Owner", this.frame.getEventSource());
        this.target = uIComponent2;
        this.findField = this.page.getComponent("find_field");
        this.findOption = this.page.getComponent("find_option");
        this.findOption.setProperty("Selected", this.backwardDir);
        this.caseOption = this.page.getComponent("case_option");
        this.caseOption.setProperty("Selected", this.ignoreCase);
        this.wrapOption = this.page.getComponent("wrap_option");
        this.wrapOption.setProperty("Selected", this.wrapAround);
        this.closeOption = this.page.getComponent("close_option");
        this.closeOption.setProperty("Selected", this.closeAfterFind);
        this.findButton = this.page.getComponent("find_button");
        this.findOption.addEventListener("Item", this);
        this.caseOption.addEventListener("Item", this);
        this.wrapOption.addEventListener("Item", this);
        this.closeOption.addEventListener("Item", this);
        this.findButton.addEventListener("action", this);
        this.dial.addEventListener("Key", this);
        this.dial.performAction("pack");
        this.dial.setProperty("LocationRelativeTo", this.frame.getEventSource());
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setSyntaxHighlight(boolean bl) {
        this.syntaxHighlight = bl;
    }

    public void show() {
        this.dial.setProperty("Visible", Boolean.TRUE);
        this.dial.performAction("toFront");
    }

    public void hide() {
        this.dial.setProperty("Visible", Boolean.FALSE);
    }

    public void findAgain() {
        this.findButton.performAction("doClick");
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.findButton.performAction("doClick");
                break;
            }
            case 27: {
                this.hide();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.findOption.getEventSource()) {
            this.backwardDir = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.caseOption.getEventSource()) {
            this.ignoreCase = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.wrapOption.getEventSource()) {
            this.wrapAround = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.closeOption.getEventSource()) {
            this.closeAfterFind = itemEvent.getStateChange() == 1;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.findField.getProperty("Text");
        int n = string.length();
        String string2 = this.text;
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\\t", "    ");
        int n2 = string2.length();
        int n3 = this.backwardDir ? -1 : 1;
        int n4 = (Integer)this.target.getProperty("CaretPosition");
        int n5 = n4 + n3;
        boolean bl = this.wrapAround;
        while (true) {
            for (int i = n5; i >= 0 && i < n2; i += n3) {
                if (!string2.regionMatches(this.ignoreCase, i, string, 0, n)) continue;
                try {
                    Highlighter highlighter = (Highlighter)this.target.getProperty("Highlighter");
                    Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
                    for (int j = 0; j < highlightArray.length; ++j) {
                        if (!(highlightArray[j].getPainter() instanceof MyHighlightPainter)) continue;
                        highlighter.removeHighlight(highlightArray[j]);
                    }
                    highlighter.addHighlight(i + 1, i + n + 1, this.myHighlightPainter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.target.setProperty("CaretPosition", new Integer(i));
                if (this.closeAfterFind) {
                    this.hide();
                }
                return;
            }
            if (!bl) break;
            bl = false;
            n5 = this.backwardDir ? n2 - 1 : 0;
        }
        JOptionPane.showMessageDialog((JFrame)this.frame.getEventSource(), "The search string was not found", "Find", 2);
        if (this.closeAfterFind) {
            this.hide();
        }
    }

    private class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

