/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.CodingTimerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.uilogic.panels.RoomInfoTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.TimerPanel;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.contestant.view.RoundView;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.round.RoundProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class RoomListFrame
implements FrameLogic,
PhaseListener,
RoundView {
    private UIComponent frame;
    private UIPage page;
    private ContestApplet parentFrame = null;
    private RoomInfoTablePanel roomInfoPanel = null;
    private TimerPanel timerPanel = null;
    private UIComponent rounds;
    private static RoomListFrame singleton;
    private ContestSponsorPanel sponsorPanel;
    private Long selectedRoundID = null;
    private boolean enabled = true;
    private Set roundsToShow = Collections.synchronizedSet(new LinkedHashSet());

    public Long getSelectedRoundID() {
        return this.selectedRoundID;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.rounds.setProperty("Enabled", Boolean.TRUE);
        } else {
            this.rounds.setProperty("Enabled", Boolean.FALSE);
        }
        if (this.roomInfoPanel != null) {
            this.roomInfoPanel.setEnabled(bl);
        }
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public RoomListFrame(ContestApplet contestApplet) {
        this.parentFrame = contestApplet;
        this.page = contestApplet.getCurrentUIManager().getUIPage("room_list_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.create();
        Common.setLocationRelativeTo((Component)contestApplet.getMainFrame(), (Component)this.frame.getEventSource());
    }

    public static RoomListFrame getInstance(ContestApplet contestApplet) {
        if (singleton == null) {
            singleton = new RoomListFrame(contestApplet);
        }
        return singleton;
    }

    private void create() {
        this.rounds = this.page.getComponent("rounds");
        RoomInfoTablePanel roomInfoTablePanel = new RoomInfoTablePanel(this.parentFrame, this.page);
        CodingTimerPanel codingTimerPanel = new CodingTimerPanel(this.parentFrame, this.page);
        this.sponsorPanel = new ContestSponsorPanel(this.page.getComponent("sponsor_logo"), CommonData.getSponsorScoreBoardImageAddr(this.parentFrame.getSponsorName(), null));
        final ListCellRenderer listCellRenderer = (ListCellRenderer)this.rounds.getProperty("Renderer");
        this.rounds.setProperty("Renderer", new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof RoundModel) {
                    RoundModel roundModel = (RoundModel)object;
                    object = roundModel.getDisplayName();
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
        this.rounds.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoundModel roundModel = (RoundModel)RoomListFrame.this.rounds.getProperty("SelectedItem");
                if (roundModel != null) {
                    RoomListFrame.this.roomInfoPanel.setRound(roundModel);
                    RoomListFrame.this.selectedRoundID = roundModel.getRoundID();
                    RoomListFrame.this.setRoomPhase(roundModel);
                } else {
                    RoomListFrame.this.selectedRoundID = null;
                }
            }
        });
        this.frame.addEventListener("window", new UIWindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                RoomListFrame.this.show();
            }
        });
        this.parentFrame.getModel().getRoundViewManager().addListener(this);
        this.bindToActiveRounds();
        this.roomInfoPanel = roomInfoTablePanel;
        this.timerPanel = codingTimerPanel;
        this.frame.performAction("pack");
    }

    private void setRoomPhase(RoundModel roundModel) {
        this.updateSponsors(roundModel);
        this.setTimerPanelRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), roundModel);
    }

    private void updateSponsors(RoundModel roundModel) {
        this.sponsorPanel.updateURL(CommonData.getSponsorScoreBoardImageAddr(this.parentFrame.getSponsorName(), roundModel));
    }

    public void reset() {
        this.roomInfoPanel.clear();
    }

    public void hide() {
        this.frame.performAction("hide");
        this.reset();
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseLeaderBoard();
        }
    }

    public void show() {
        this.reloadRounds();
        this.frame.performAction("show");
    }

    public void reloadRounds() {
        Long l = this.selectedRoundID == null ? null : new Long(this.selectedRoundID);
        this.reset();
        this.rounds.performAction("removeAllItems");
        if (this.roundsToShow.size() > 0) {
            boolean bl = false;
            RoundModel[] roundModelArray = this.roundsToShow.toArray(new RoundModel[this.roundsToShow.size()]);
            RoundModel roundModel = roundModelArray[0];
            for (int i = 0; i < roundModelArray.length; ++i) {
                roundModel = roundModelArray[i];
                this.rounds.performAction("addItem", new Object[]{roundModel});
                if (!roundModel.getRoundID().equals(l)) continue;
                this.roomInfoPanel.setRound(roundModel);
                this.rounds.setProperty("SelectedIndex", new Integer(i));
                this.setRoomPhase(roundModel);
                bl = true;
            }
            if (!bl) {
                roundModel = roundModelArray[0];
                this.roomInfoPanel.setRound(roundModel);
                this.rounds.setProperty("SelectedIndex", new Integer(0));
                this.setRoomPhase(roundModel);
            }
        }
    }

    private TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void setTimerPanelRoundModel(RoundModel roundModel) {
        this.getTimerPanel().setRoundModel(roundModel);
    }

    public synchronized void phaseEvent(int n, RoundModel roundModel) {
        if (roundModel != null && roundModel.canDisplaySummary() != this.roundsToShow.contains(roundModel)) {
            if (roundModel.canDisplaySummary()) {
                this.roundsToShow.add(roundModel);
            } else {
                this.roundsToShow.remove(roundModel);
            }
            this.reloadRounds();
        }
        if (roundModel == null || roundModel.getRoundID().equals(this.selectedRoundID)) {
            this.setTimerPhase(n, roundModel);
        }
    }

    private void setTimerPhase(int n, RoundModel roundModel) {
        int n2 = -1;
        String string = null;
        switch (n) {
            case 0: {
                string = "TOPCODER TIME";
                n2 = 1;
                break;
            }
            case 7: {
                string = "PENDING SYSTESTS";
                n2 = 1;
                break;
            }
            case 9: {
                string = "CONTEST COMPLETE";
                n2 = 1;
                break;
            }
            case 2: {
                string = "REGISTRATION";
                n2 = 2;
                break;
            }
            case 3: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 1: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 4: {
                string = "CODING";
                n2 = 2;
                break;
            }
            case 5: {
                string = "INTERMISSION";
                n2 = 2;
                break;
            }
            case 6: {
                string = "CHALLENGE";
                n2 = 2;
                break;
            }
            case 10: {
                string = "VOTING";
                n2 = 2;
                break;
            }
            case 11: {
                string = "TIE BREAKING VOTE";
                n2 = 2;
                break;
            }
            case 8: {
                string = "SYSTEM TESTING";
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad phase type: " + n);
            }
        }
        this.getTimerPanel().setTitle(string);
        this.getTimerPanel().setMode(n2);
    }

    public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
        if (roundModel.getRoundID().equals(this.selectedRoundID)) {
            this.getTimerPanel().updateSystestProgress(n, n2);
        }
    }

    public void enableRound(RoundModel roundModel) {
    }

    public void clearRoundList() {
    }

    public void updateActiveRoundList(Contestant contestant) {
        RoundModel[] roundModelArray = contestant.getActiveRounds();
        if (roundModelArray.length == 0) {
            this.phaseEvent(0, null);
        } else {
            this.bindToActiveRounds();
            this.reloadRounds();
        }
    }

    private void bindToActiveRounds() {
        RoundModel[] roundModelArray = this.parentFrame.getModel().getActiveRounds();
        if (roundModelArray != null && roundModelArray.length > 0) {
            LinkedHashSet<RoundModel> linkedHashSet = new LinkedHashSet<RoundModel>(10);
            RoundModel roundModel = null;
            for (int i = 0; i < roundModelArray.length; ++i) {
                RoundModel roundModel2 = roundModelArray[i];
                RoundProperties roundProperties = roundModel2.getRoundProperties();
                if (!roundProperties.usesScore() || !roundProperties.getShowScoresOfOtherCoders().booleanValue()) continue;
                if (!roundModel2.containsPhaseListener(this)) {
                    roundModel2.addPhaseListener(this);
                }
                if (!roundModel2.canDisplaySummary()) continue;
                linkedHashSet.add(roundModel2);
                if (!roundModel2.getRoundID().equals(this.selectedRoundID)) continue;
                roundModel = roundModel2;
            }
            this.roundsToShow = Collections.synchronizedSet(linkedHashSet);
            if (this.roundsToShow.size() > 0) {
                if (roundModel == null) {
                    roundModel = (RoundModel)this.roundsToShow.iterator().next();
                }
                this.internalSetSelectedRound(roundModel);
            }
        }
    }

    private void internalSetSelectedRound(RoundModel roundModel) {
        this.getTimerPanel().setRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), roundModel);
    }
}

