/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.HyperLinkLoader;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.ComponentBroadcast;
import com.topcoder.netCommon.contestantMessages.RoundBroadcast;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;

public class BroadcastDialog
implements FrameLogic {
    private UIComponent frame;
    private UIPage page;
    private static final String[] genericBroadcastHeaders = new String[]{"Time"};
    private static final String[] roundBroadcastHeaders = new String[]{"Time", "Round"};
    private static final String[] problemBroadcastHeaders = new String[]{"Time", "Round", "Division", "Point Value", "Class", "Method", "Returns"};
    private AppletContext arenaContext;

    public BroadcastDialog(ContestApplet contestApplet, AdminBroadcast adminBroadcast) {
        this(contestApplet, adminBroadcast, true);
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public BroadcastDialog(ContestApplet contestApplet, AdminBroadcast adminBroadcast, boolean bl) {
        String string;
        String[] stringArray;
        String[] stringArray2;
        String string2;
        Object object;
        this.page = contestApplet.getCurrentUIManager().getUIPage("broadcast_dialog", true);
        this.frame = this.page.getComponent("root_dialog", false);
        contestApplet.getModel().getBroadcastManager().markBroadcastRead(adminBroadcast);
        this.arenaContext = contestApplet.getAppletContext();
        if (adminBroadcast instanceof ComponentBroadcast) {
            object = (ComponentBroadcast)adminBroadcast;
            string2 = "Problem Broadcast";
            stringArray2 = problemBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(object.getTime()), object.getRoundName(), "" + object.getDivision(), "" + object.getPointValue(), object.getClassName(), object.getMethodSignature(), object.getReturnType()};
            string = object.getMessage();
        } else if (adminBroadcast instanceof RoundBroadcast) {
            object = (RoundBroadcast)adminBroadcast;
            string2 = "Round Broadcast";
            stringArray2 = roundBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(object.getTime()), object.getRoundName()};
            string = object.getMessage();
        } else {
            string2 = "Admin Broadcast";
            stringArray2 = genericBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(adminBroadcast.getTime())};
            string = adminBroadcast.getMessage();
        }
        this.frame.setProperty("owner", contestApplet.getCurrentFrame());
        this.frame.setProperty("Title", string2);
        this.frame.create();
        this.createHeaderPanel(stringArray2, stringArray);
        this.createMessagePanel(string);
        if (bl) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        BroadcastDialog.this.frame.performAction("pack");
                        Dimension dimension = (Dimension)BroadcastDialog.this.page.getComponent("left_header_text").getProperty("size");
                        BroadcastDialog.this.page.getComponent("left_header_text").setProperty("preferredsize", dimension);
                        dimension = (Dimension)BroadcastDialog.this.page.getComponent("right_header_text").getProperty("size");
                        BroadcastDialog.this.page.getComponent("right_header_text").setProperty("preferredsize", dimension);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            this.frame.performAction("pack");
            object = (Dimension)this.page.getComponent("left_header_text").getProperty("size");
            this.page.getComponent("left_header_text").setProperty("preferredsize", object);
            object = (Dimension)this.page.getComponent("right_header_text").getProperty("size");
            this.page.getComponent("right_header_text").setProperty("preferredsize", object);
        }
        Common.setLocationRelativeTo((Component)contestApplet.getCurrentFrame(), (Component)this.frame.getEventSource());
        MoveFocus.moveFocus(this.frame);
    }

    private void createHeaderPanel(String[] stringArray, String[] stringArray2) {
        String string;
        int n;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(200 * stringArray2.length);
        int n2 = stringArray.length / 2;
        if (stringArray.length == 0) {
            n2 = -1;
        }
        for (n = 0; n <= n2; ++n) {
            string = stringArray[n] + ":  " + stringArray2[n];
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        string2 = stringBuffer.toString();
        this.page.getComponent("left_header_text").setProperty("text", string2);
        stringBuffer.setLength(0);
        for (n = n2 + 1; n < stringArray.length; ++n) {
            string = stringArray[n] + ":  " + stringArray2[n];
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        string2 = stringBuffer.toString();
        this.page.getComponent("right_header_text").setProperty("text", string2);
        Dimension dimension = (Dimension)this.page.getComponent("header_inner_panel").getProperty("preferredsize");
        this.page.getComponent("header_inner_panel").setProperty("preferredsize", new Dimension(dimension.width, 11 * (stringArray.length + 2)));
    }

    private void createMessagePanel(String string) {
        this.page.getComponent("message_editor_pane").setProperty("text", Common.htmlEncode(string));
        this.page.getComponent("message_editor_pane").addEventListener("hyperlink", new HyperLinkLoader(this.arenaContext));
    }

    public void show() {
        this.frame.performAction("show");
        this.frame.performAction("toFront");
        MoveFocus.moveFocus(this.frame);
    }
}

