/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.LoginException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class TopCoderHSLoginRoom
extends RoomModule {
    private boolean loginEnabled = true;
    private JPanel panel = new JPanel(new GridBagLayout());
    private JTextField userName = new JTextField();
    private JPasswordField passWord = new JPasswordField();
    private JButton loginButton = null;
    private JTextArea legalese = new JTextArea("Any use of the TopCoder Arena, including the practice area, is limited to personal, non-commercial or educational purposes only.  If you wish to utilize the TopCoder Arena, or any TopCoder information, including statistical information, for commercial purposes, including, but not limited to, recruiting, testing or training, please contact TopCoder by email: service@topcoder.com or by phone: 860-633-5540.  By logging into the arena, you indicate your agreement to these terms as well as those specified in the TopCoder Terms of Service on our website.", 5, 40);
    private JTextField legalese2 = new JTextField("All content on the website and in the arena (c)2003 TopCoder, Inc.  All Rights Reserved", 40);
    private JTextField legalese3 = new JTextField("Protected by U.S. patent number 6,569,012", 40);
    private JTextArea tunnelWarn = new JTextArea("**HTTP Tunneling is significantly slower than connecting directly and should only be used by people who are unable to connect otherwise.", 2, 40);
    private JCheckBox tunnel = null;
    private ActionListener lb_al = null;
    private ActionListener tu_al = null;
    private ActionListener un_al = null;
    private ActionListener pw_al = null;
    private DocumentListener documentListener;
    private ContestApplet ca;

    public TopCoderHSLoginRoom(ContestApplet contestApplet) {
        super(contestApplet, 0);
        this.ca = contestApplet;
        this.create();
    }

    public JPanel reload() {
        this.clear();
        return this.panel;
    }

    public void enter() {
        this.loginButton.addActionListener(this.lb_al);
        this.userName.addActionListener(this.un_al);
        this.passWord.addActionListener(this.pw_al);
        this.tunnel.addActionListener(this.tu_al);
        this.userName.getDocument().addDocumentListener(this.documentListener);
        this.passWord.getDocument().addDocumentListener(this.documentListener);
        this.resetFocus();
    }

    public void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.panel.setBackground(Common.BG_COLOR);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        ContestSponsorPanel contestSponsorPanel = new ContestSponsorPanel(this.ca, null, CommonData.getSponsorLoginImageAddr(this.ca.getCompanyName()));
        Common.insertInPanel(contestSponsorPanel, this.panel, gridBagConstraints, 0, 0, 3, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        Common.insertInPanel(this.createLoginPanel(339, 166, Common.BG_COLOR), this.panel, gridBagConstraints, 0, 1, 3, 1, 0.1, 0.0);
        gridBagConstraints.anchor = 11;
        Common.insertInPanel(this.createRegisterPanel(265, 50, Common.BG_COLOR), this.panel, gridBagConstraints, 0, 2, 3, 1, 0.1, 0.0);
        this.legalese.setEditable(false);
        this.legalese.setLineWrap(true);
        this.legalese.setWrapStyleWord(true);
        this.legalese.setForeground(Common.ID_COLOR);
        this.legalese.setBackground(Common.BG_COLOR);
        this.legalese.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 25, 5, 25);
        Common.insertInPanel(this.legalese, this.panel, gridBagConstraints, 0, 3, 3, 1, 0.0, 0.2);
        this.legalese2.setEditable(false);
        this.legalese2.setForeground(Common.ID_COLOR);
        this.legalese2.setBackground(Common.BG_COLOR);
        this.legalese2.setHorizontalAlignment(0);
        this.legalese2.setBorder(null);
        this.legalese3.setEditable(false);
        this.legalese3.setForeground(Common.ID_COLOR);
        this.legalese3.setBackground(Common.BG_COLOR);
        this.legalese3.setHorizontalAlignment(0);
        this.legalese3.setBorder(null);
        this.tunnelWarn.setEditable(false);
        this.tunnelWarn.setForeground(Common.ID_COLOR);
        this.tunnelWarn.setBackground(Common.BG_COLOR);
        this.tunnelWarn.setLineWrap(true);
        this.tunnelWarn.setWrapStyleWord(true);
        this.tunnelWarn.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(15, 25, 5, 25);
        Common.insertInPanel(this.tunnelWarn, this.panel, gridBagConstraints, 1, 4, 1, 1, 0.1, 0.0);
        Common.insertInPanel(this.legalese3, this.panel, gridBagConstraints, 1, 5, 1, 1, 0.1, 0.0);
        Common.insertInPanel(this.legalese2, this.panel, gridBagConstraints, 1, 6, 1, 1, 0.1, 0.0);
    }

    private JPanel createLoginPanel(int n, int n2, Color color) {
        ImageIconPanel imageIconPanel = new ImageIconPanel((LayoutManager)new GridBagLayout(), Common.getImage("login.gif", this.parentFrame));
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        imageIconPanel.setMinimumSize(new Dimension(n, n2));
        imageIconPanel.setPreferredSize(new Dimension(n, n2));
        imageIconPanel.setBackground(color);
        Common.insertInPanel(this.createInnerLoginPanel(230, 125), imageIconPanel, gridBagConstraints, 0, 0, 1, 1);
        return imageIconPanel;
    }

    public boolean leave() {
        this.loginButton.removeActionListener(this.lb_al);
        this.userName.removeActionListener(this.un_al);
        this.passWord.removeActionListener(this.pw_al);
        this.tunnel.removeActionListener(this.tu_al);
        this.userName.getDocument().removeDocumentListener(this.documentListener);
        this.passWord.getDocument().removeDocumentListener(this.documentListener);
        return true;
    }

    public void resetFocus() {
        MoveFocus.moveFocus(this.passWord);
        MoveFocus.moveFocus(this.userName);
    }

    public void clear() {
        this.loginEnabled = true;
        this.userName.setText("");
        this.passWord.setText("");
    }

    private JPanel createInnerLoginPanel(int n, int n2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 2;
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setOpaque(false);
        this.loginButton = Common.getTextButton("");
        JLabel jLabel = new JLabel("Username:");
        JLabel jLabel2 = new JLabel("Password:");
        this.loginButton.setIcon(Common.getImage("go_but.gif", this.parentFrame));
        this.loginButton.setPressedIcon(Common.getImage("go_but_in.gif", this.parentFrame));
        this.loginButton.setDisabledIcon(Common.getImage("go_but_gray.gif", this.parentFrame));
        this.loginButton.setBackground(Color.white);
        this.loginButton.setForeground(Color.white);
        this.loginButton.setEnabled(false);
        jLabel.setForeground(Common.ID_COLOR);
        jLabel2.setForeground(Common.ID_COLOR);
        this.tunnel = new JCheckBox("HTTP Tunneling**");
        this.tunnel.setBackground(Color.black);
        this.tunnel.setForeground(Color.white);
        this.tunnel.setContentAreaFilled(false);
        this.lb_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopCoderHSLoginRoom.this.loginButtonClick();
            }
        };
        this.un_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopCoderHSLoginRoom.this.userNameEvent();
            }
        };
        this.pw_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopCoderHSLoginRoom.this.passWordEvent();
            }
        };
        this.tu_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                TopCoderHSLoginRoom.this.checkLoginButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TopCoderHSLoginRoom.this.checkLoginButton();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        gridBagConstraints.anchor = 15;
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.userName, jPanel, gridBagConstraints, 1, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.anchor = 11;
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.passWord, jPanel, gridBagConstraints, 1, 1, 1, 1, 1.0, 0.0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        Common.insertInPanel(this.loginButton, jPanel, gridBagConstraints, 1, 2, 1, 1, 1.0, 1.0);
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.tunnel, jPanel, gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        return jPanel;
    }

    private JPanel createRegisterPanel(int n, int n2, Color color) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        JLabel jLabel = new JLabel("New User ?");
        JButton jButton = Common.getTextButton("Click here to Register");
        jLabel.setForeground(Common.ID_COLOR);
        jButton.setToolTipText("Register for a username/password");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopCoderHSLoginRoom.this.registerButtonClick();
            }
        });
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1);
        Common.insertInPanel(jButton, jPanel, gridBagConstraints, 1, 0, 1, 1);
        return jPanel;
    }

    private synchronized void loginButtonClick() {
        if (this.loginEnabled) {
            this.loginEnabled = false;
            try {
                this.parentFrame.getModel().login(this.userName.getText(), this.passWord.getPassword(), null);
            }
            catch (LoginException loginException) {
                this.parentFrame.popup(1, "Login Request", loginException.getMessage());
                this.parentFrame.getModel().reset();
            }
            if (this.parentFrame.getModel().isLoggedIn()) {
                this.parentFrame.getRoomManager().loadRoom(3, -1L, 1);
            }
            this.loginEnabled = true;
            this.clear();
            this.resetFocus();
        }
    }

    public void clearButtonClick(ActionEvent actionEvent) {
        this.clear();
    }

    public void registerButtonClick() {
        try {
            Common.showURL(this.ca.getAppletContext(), new URL("http://highschool.topcoder.com?module=Static&d1=registration&d2=registration"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    private void userNameEvent() {
        if (!this.isUsernameEmpty()) {
            MoveFocus.moveFocus(this.passWord);
        }
    }

    private void passWordEvent() {
        if (this.isEnabled()) {
            this.loginButton.doClick();
        }
    }

    private void checkLoginButton() {
        boolean bl = this.userName.getText().length() > 0 && this.passWord.getPassword().length > 0;
        this.loginButton.setEnabled(bl);
    }

    private boolean isUsernameEmpty() {
        return this.userName.getText().length() <= 0;
    }

    private boolean isEnabled() {
        return !this.isUsernameEmpty() && this.passWord.getPassword().length > 0;
    }

    protected void addViews() {
    }

    void clearViews() {
    }
}

