/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.ChallengeFrame;
import com.topcoder.client.contestApplet.frames.CodingFrame;
import com.topcoder.client.contestApplet.frames.TeamProblemFrame;
import com.topcoder.client.contestApplet.panels.ChatTabbedPane;
import com.topcoder.client.contestApplet.panels.TeamProblemPanel;
import com.topcoder.client.contestApplet.panels.TimeLine;
import com.topcoder.client.contestApplet.panels.room.RoomPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestApplet.panels.room.WorkPanel;
import com.topcoder.client.contestApplet.panels.room.comp.CompPanel;
import com.topcoder.client.contestApplet.panels.room.comp.CompetitionCompPanel;
import com.topcoder.client.contestApplet.panels.table.TeamContestantTablePanel;
import com.topcoder.client.contestApplet.panels.table.UserTablePanel;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.CodingView;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.contestant.view.RoundProblemsListener;
import com.topcoder.netCommon.contest.ContestConstants;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.problem.DataType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public final class TeamCoderRoom
extends RoomModule
implements CodingView,
PhaseListener,
CoderRoomInterface,
RoundProblemsListener {
    protected JButton challengeButton = null;
    private JComboBox componentList = new JComboBox();
    private JComboBox problemList = new JComboBox();
    private RoomPanel panel = null;
    private CompPanel compPanel = null;
    private ChatTabbedPane chatPanel = null;
    private UserTablePanel userPanel = null;
    private TeamContestantTablePanel contestantPanel = null;
    private CodingFrame codingRoom = null;
    private TeamProblemFrame teamProblemRoom = null;
    private ChallengeFrame statusFrame = null;
    private TimeLine timeLine = null;
    private TeamProblemPanel problemPanel = null;
    private ArrayList tempArgs = null;
    private int buttonStatus = 0;
    private CompetitionCompPanel ccp = null;
    private boolean openingProblem = false;
    private CoderComponent currentCoderComponent;
    private static final String SELECTONEPROBLEM = "Problems";
    private static final String SELECTONECOMPONENT = "Components";
    public static final String SPECTATOR_ROOM = "Spectator Room";
    private static final String DEFAULT_NAME = "Team Coder Room";
    private CoderComponent.Listener myCoderComponentListener = new CoderComponent.Listener(){

        public void coderComponentEvent(CoderComponent coderComponent) {
            if (coderComponent.hasSourceCode()) {
                TeamCoderRoom.this.codingRoom.updateComponentSource(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
            }
            coderComponent.removeListener(this);
        }
    };
    private ProblemModel.Listener myProblemModelListener = new ProblemModel.Listener(){

        public void updateProblemModel(ProblemModel problemModel) {
            if (TeamCoderRoom.this.openingProblem) {
                TeamCoderRoom.this.openingProblem = false;
                TeamCoderRoom.this.parentFrame.getInterFrame().hideMessage();
                for (int i = 0; i < problemModel.getComponents().length; ++i) {
                    if (!problemModel.getComponents()[i].getID().equals(TeamCoderRoom.this.currentCoderComponent.getComponent().getID())) continue;
                    TeamCoderRoom.this.updateCodingWindow(problemModel.getComponents()[i]);
                    break;
                }
            }
        }

        public void updateProblemModelReadOnly(ProblemModel problemModel) {
            if (TeamCoderRoom.this.openingProblem) {
                TeamCoderRoom.this.openingProblem = false;
                TeamCoderRoom.this.parentFrame.getInterFrame().hideMessage();
                TeamCoderRoom.this.updateTeamProblemWindow(problemModel);
            }
        }
    };

    public TeamCoderRoom(ContestApplet contestApplet) {
        super(contestApplet, 9);
        this.create("", true);
    }

    private String getDefaultName() {
        return DEFAULT_NAME;
    }

    public void setConnectionStatus(boolean bl) {
        this.panel.setStatusLabel(bl);
    }

    private void create(String string, boolean bl) {
        if (string == null) {
            string = this.getDefaultName();
        }
        this.panel = new RoomPanel(string, this.parentFrame, this.createWorkPanel(bl), new CompetitionCompPanel());
        this.compPanel = this.panel.getCompPanel();
        this.ccp = (CompetitionCompPanel)this.compPanel.getContestPanel();
        this.panel.showTimer();
    }

    public void setArgs(ArrayList arrayList) {
        this.tempArgs = arrayList;
    }

    private JPanel createWorkPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        WorkPanel workPanel = new WorkPanel(this.parentFrame);
        TimeLine timeLine = new TimeLine(this.parentFrame);
        TeamProblemPanel teamProblemPanel = new TeamProblemPanel(this.parentFrame, bl);
        this.problemList = teamProblemPanel.getProblemList();
        this.componentList = teamProblemPanel.getComponentList();
        this.problemList.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof ProblemModel) {
                    ProblemModel problemModel = (ProblemModel)object;
                    object = problemModel.getName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.componentList.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof ProblemComponentModel) {
                    ProblemComponentModel problemComponentModel = (ProblemComponentModel)object;
                    object = problemComponentModel.getClassName() + " - " + Common.formatNoFractions((double)problemComponentModel.getPoints());
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        if (!bl) {
            this.problemList.setVisible(false);
            this.componentList.setVisible(false);
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        jPanel.setBackground(Common.WPB_COLOR);
        UserTablePanel userTablePanel = new UserTablePanel(this.parentFrame);
        ChatTabbedPane chatTabbedPane = new ChatTabbedPane(this.parentFrame);
        chatTabbedPane.addChat("Room Chat", 1);
        chatTabbedPane.addChat("Team Chat", 2);
        TeamContestantTablePanel teamContestantTablePanel = new TeamContestantTablePanel(this.parentFrame);
        this.problemList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamCoderRoom.this.problemsListEvent();
            }
        });
        this.componentList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamCoderRoom.this.componentsListEvent();
            }
        });
        this.createNewCodingRoom();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 15, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 10, 2, 15);
        Common.insertInPanel(timeLine, workPanel, gridBagConstraints, 1, 0, 1, 1, 1.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 10, 5, 15);
        Common.insertInPanel(teamProblemPanel, workPanel, gridBagConstraints, 1, 1, 1, 1, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 10, 15, 15);
        Common.insertInPanel(chatTabbedPane, workPanel, gridBagConstraints, 1, 2, 1, 1, 1.0, 1.0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setMinimumSize(new Dimension(170, 0));
        jPanel2.setPreferredSize(new Dimension(170, 0));
        gridBagConstraints.insets = new Insets(5, 15, 5, 10);
        Common.insertInPanel(teamContestantTablePanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 0.1, 1.0);
        gridBagConstraints.insets = new Insets(5, 15, 15, 10);
        Common.insertInPanel(userTablePanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, 0.1, 0.8);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 3;
        Common.insertInPanel(jPanel2, workPanel, gridBagConstraints, 0, 0, 1, 3, 0.0, 0.1);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(workPanel, jPanel, gridBagConstraints, 1, 1, 1, 1, 1.0, 1.0);
        this.chatPanel = chatTabbedPane;
        this.userPanel = userTablePanel;
        this.contestantPanel = teamContestantTablePanel;
        this.timeLine = timeLine;
        this.problemPanel = teamProblemPanel;
        return jPanel;
    }

    public JPanel reload() {
        this.panel.getWorkPanel().revalidate();
        this.panel.getWorkPanel().repaint();
        return this.panel;
    }

    public void clear() {
        super.clear();
        this.problemList.setEnabled(true);
        this.problemList.removeAllItems();
        this.componentList.setEnabled(true);
        this.componentList.removeAllItems();
        this.userPanel.clear();
        this.contestantPanel.clear();
        this.chatPanel.clear();
    }

    public void enter() {
        this.chatPanel.enter();
    }

    public boolean leave() {
        if (this.codingRoom != null) {
            this.closeCodingWindow();
            this.codingRoom.hide();
        }
        if (this.teamProblemRoom != null) {
            this.closeTeamProblemWindow();
            this.teamProblemRoom.hide();
        }
        if (this.statusFrame != null) {
            this.statusFrame.hide();
        }
        this.chatPanel.leave();
        this.unsetModel();
        return true;
    }

    public void resetFocus() {
        this.chatPanel.leave();
        this.chatPanel.enter();
    }

    public CodingFrame getCodingFrame() {
        return this.codingRoom;
    }

    public synchronized void phaseEvent(int n, RoundModel roundModel) {
        this.setTimerPhase(n, roundModel);
        this.timeLine.setPhase(n);
        this.problemPanel.setPhase(n);
        switch (n) {
            case 4: {
                this.problemList.setEnabled(true);
                this.componentList.setEnabled(true);
                break;
            }
            case 5: {
                this.codingRoom.setButtons(false, false, false, false, false, true, false, false);
                this.codingRoom.enableText(false);
                this.codingRoom.setButtons(false, false, false, false, false, true, false, false);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 0: 
            case 8: 
            case 9: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown phase (" + n + ").");
            }
        }
    }

    private void setTimerPhase(int n, RoundModel roundModel) {
        int n2 = -1;
        String string = null;
        switch (n) {
            case 0: {
                string = "TOPCODER TIME";
                n2 = 1;
                break;
            }
            case 7: {
                string = "PENDING SYSTESTS";
                n2 = 1;
                break;
            }
            case 9: {
                string = "CONTEST COMPLETE";
                n2 = 1;
                break;
            }
            case 2: {
                string = "REGISTRATION";
                n2 = 2;
                break;
            }
            case 3: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 1: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 4: {
                string = "CODING";
                n2 = 2;
                break;
            }
            case 5: {
                string = "INTERMISSION";
                n2 = 2;
                break;
            }
            case 6: {
                string = "CHALLENGE";
                n2 = 2;
                break;
            }
            case 8: {
                string = "SYSTEM TESTING";
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad phase type: " + n);
            }
        }
        this.getTimerPanel().setTitle(string);
        this.getTimerPanel().setMode(n2);
        this.statusFrame.getTimerPanel().setTitle(string);
        this.statusFrame.getTimerPanel().setMode(n2);
        TimerPanel timerPanel = this.codingRoom.getTimerPanel();
        timerPanel.setTitle(string);
        TimerPanel timerPanel2 = null;
        if (this.teamProblemRoom != null) {
            timerPanel2 = this.teamProblemRoom.getTimerPanel();
            timerPanel2.setTitle(string);
        }
        boolean bl = timerPanel.isRoundModelInitialized();
        if (roundModel != null && !bl) {
            timerPanel.setRoundModel(roundModel);
            if (timerPanel2 != null) {
                timerPanel2.setRoundModel(roundModel);
            }
        }
        timerPanel.setMode(n2);
    }

    public void showStatusWindow() {
        this.statusFrame.showFrame(true);
    }

    public void timeOutEvent(int n) {
        switch (n) {
            case 34: {
                this.codingRoom.setButtons(true, true, true, true, true, false, true, false);
                break;
            }
            case 4: {
                this.codingRoom.setButtons(true, true, true, true, true, false, true, false);
                break;
            }
            case 15: {
                this.codingRoom.setButtons(true, true, true, false, false, true, true, true);
            }
        }
    }

    public void roundProblemsEvent() {
        RoundModel roundModel = this.roomModel.getRoundModel();
        this.createProblems(roundModel.getAssignedComponents(this.roomModel.getDivisionID()), roundModel.getProblems(this.roomModel.getDivisionID()));
    }

    private void createProblems(ProblemComponentModel[] problemComponentModelArray, ProblemModel[] problemModelArray) {
        int n;
        this.problemList.removeAllItems();
        this.componentList.removeAllItems();
        this.problemList.addItem(SELECTONEPROBLEM);
        this.componentList.addItem(SELECTONECOMPONENT);
        for (n = 0; n < problemModelArray.length; ++n) {
            this.problemList.addItem(problemModelArray[n]);
        }
        for (n = 0; n < problemComponentModelArray.length; ++n) {
            this.componentList.addItem(problemComponentModelArray[n]);
        }
    }

    protected void addViews() {
        if (!this.roomModel.hasRoundModel()) {
            throw new IllegalStateException("No round associated with: " + this.roomModel);
        }
        RoundModel roundModel = this.roomModel.getRoundModel();
        roundModel.addPhaseListener(this);
        roundModel.addRoundProblemsListener(this);
        if (!roundModel.hasProblems(this.roomModel.getDivisionID())) {
            throw new IllegalStateException("Missing problem labels for round: " + roundModel);
        }
        this.createProblems(roundModel.getAssignedComponents(this.roomModel.getDivisionID()), roundModel.getProblems(this.roomModel.getDivisionID()));
        this.createNewStatusRoom();
        this.getTimerPanel().setRoundModel(roundModel);
        this.codingRoom.getTimerPanel().setRoundModel(roundModel);
        this.statusFrame.getTimerPanel().setRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), null);
        this.roomModel.addChatView(this.chatPanel);
        this.roomModel.addChallengeView(this.statusFrame.getChallengePanel());
        if (this.statusFrame.getAssignmentPanel() != null) {
            this.roomModel.addChallengeView(this.statusFrame.getAssignmentPanel());
            this.roomModel.addAssignmentView(this.statusFrame.getAssignmentPanel());
        }
        this.roomModel.addUserListView(this.userPanel);
        this.roomModel.addUserListView(this.chatPanel);
        this.roomModel.addCodingView(this);
        Coder[] coderArray = this.roomModel.getCoders();
        UserListItem[] userListItemArray = new UserListItem[coderArray.length];
        for (int i = 0; i < coderArray.length; ++i) {
            Coder coder = coderArray[i];
            userListItemArray[i] = new UserListItem(coder.getHandle(), coder.getRating().intValue(), coder.getUserType());
        }
        this.contestantPanel.updateUserList(userListItemArray);
        this.ccp.updateContestInfo(this.roomModel.getStatus());
        this.compPanel.setContestName(this.roomModel.getName());
    }

    protected void clearViews() {
        this.ccp.updateContestInfo("");
        this.compPanel.setContestName("");
        this.contestantPanel.clear();
        if (this.roomModel != null) {
            this.roomModel.removeCodingView(this);
            this.roomModel.removeUserListView(this.chatPanel);
            this.roomModel.removeUserListView(this.userPanel);
            if (this.statusFrame != null && this.statusFrame.getAssignmentPanel() != null) {
                this.roomModel.removeChallengeView(this.statusFrame.getAssignmentPanel());
                this.roomModel.removeAssignmentView(this.statusFrame.getAssignmentPanel());
            }
            this.roomModel.removeChallengeView(this.statusFrame.getChallengePanel());
            this.roomModel.removeChatView(this.chatPanel);
            if (this.roomModel.hasRoundModel()) {
                this.getTimerPanel().unsetRoundModel();
                this.roomModel.getRoundModel().removePhaseListener(this);
                this.roomModel.getRoundModel().removeRoundProblemsListener(this);
            } else {
                throw new IllegalStateException("No round associated with: " + this.roomModel);
            }
        }
    }

    public void updateCompileError(ArrayList arrayList) {
        this.codingRoom.updateCompile((Boolean)arrayList.get(0), (String)arrayList.get(1));
    }

    public void setTestInfo(DataType[] dataTypeArray, int n) {
        Object var3_3 = null;
        this.codingRoom.testComponentID = n;
        this.codingRoom.setCR(this);
        ProblemComponentModel problemComponentModel = this.codingRoom.getComponentModel();
    }

    private void test(ArrayList arrayList, int n) {
        this.parentFrame.getInterFrame().showMessage("Testing...", this.codingRoom, 15);
        this.parentFrame.getRequester().requestTest((ArrayList)arrayList.get(1), n);
    }

    private void updateCodingWindow(ProblemComponentModel problemComponentModel) {
        this.createNewCodingRoom();
        this.componentList.setEnabled(false);
        this.codingRoom.clear();
        this.codingRoom.updateComponentInfo(problemComponentModel);
        this.codingRoom.showFrame(true);
    }

    public void updateTeamProblemWindow(ProblemModel problemModel) {
        this.createNewTeamProblemRoom();
        this.problemList.setEnabled(false);
        this.teamProblemRoom.clear();
        this.teamProblemRoom.updateProblemInfo(problemModel);
        this.teamProblemRoom.showFrame(true);
    }

    private void createNewCodingRoom() {
        if (this.codingRoom != null) {
            this.codingRoom.hide();
            this.codingRoom.dispose();
            this.codingRoom = null;
        }
        this.codingRoom = new CodingFrame(this.parentFrame);
        this.codingRoom.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TeamCoderRoom.this.closeCodingWindow();
            }
        });
        this.codingRoom.create();
        if (this.roomModel != null) {
            this.codingRoom.getTimerPanel().setRoundModel(this.roomModel.getRoundModel());
            this.setTimerPhase(this.roomModel.getRoundModel().getPhase(), null);
        }
    }

    public void createNewTeamProblemRoom() {
        if (this.teamProblemRoom != null) {
            this.teamProblemRoom.hide();
            this.teamProblemRoom.dispose();
            this.teamProblemRoom = null;
        }
        this.teamProblemRoom = new TeamProblemFrame(this.parentFrame);
        this.teamProblemRoom.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TeamCoderRoom.this.closeTeamProblemWindow();
            }
        });
        this.teamProblemRoom.create();
        if (this.roomModel != null) {
            this.teamProblemRoom.getTimerPanel().setRoundModel(this.roomModel.getRoundModel());
            this.setTimerPhase(this.roomModel.getRoundModel().getPhase(), null);
        }
    }

    private void createNewStatusRoom() {
        if (this.statusFrame != null) {
            this.statusFrame.hide();
            this.statusFrame.dispose();
            this.statusFrame = null;
        }
        this.statusFrame = new ChallengeFrame(this.parentFrame, this.roomModel);
    }

    private void problemsListEvent() {
        int n = this.problemList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.tempArgs = null;
        Object e = this.problemList.getItemAt(n);
        if (e.equals(SELECTONEPROBLEM)) {
            return;
        }
        String string = this.parentFrame.getModel().getCurrentUser();
        if (!this.roomModel.isAssigned(string)) {
            Common.showMessage("Not assigned", "You are not assigned to this room.", this.parentFrame.getCurrentFrame());
            return;
        }
        this.openingProblem = true;
        ProblemModel problemModel = (ProblemModel)e;
        problemModel.addListener(this.myProblemModelListener);
        this.parentFrame.getRequester().requestOpenProblemForReading(this.roomModel.getRoundModel().getRoundID(), problemModel.getProblemID());
    }

    private void componentsListEvent() {
        int n = this.componentList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.tempArgs = null;
        Object e = this.componentList.getItemAt(n);
        if (e.equals(SELECTONECOMPONENT)) {
            return;
        }
        String string = this.parentFrame.getModel().getCurrentUser();
        if (!this.roomModel.isAssigned(string)) {
            Common.showMessage("Not assigned", "You are not assigned to this room.", this.parentFrame.getCurrentFrame());
            return;
        }
        ProblemComponentModel problemComponentModel = (ProblemComponentModel)e;
        string = this.parentFrame.getModel().getCurrentTeam();
        this.currentCoderComponent = this.roomModel.getCoder(string).getComponent(problemComponentModel.getID());
        this.currentCoderComponent.addListener(this.myCoderComponentListener);
        problemComponentModel.getProblem().addListener(this.myProblemModelListener);
        this.openingProblem = true;
        this.parentFrame.getRequester().requestOpenComponentForCoding(problemComponentModel.getID());
    }

    public void closeCodingWindow() {
        this.openingProblem = false;
        this.componentList.setEnabled(true);
        if (!this.codingRoom.isSaved()) {
            this.codingRoom.setButtons(false, false, false, false, false, false, false, false);
        }
        if (this.currentCoderComponent != null) {
            this.currentCoderComponent.removeListener(this.myCoderComponentListener);
            this.currentCoderComponent.getComponent().getProblem().removeListener(this.myProblemModelListener);
            this.currentCoderComponent = null;
        }
        this.resetFocus();
    }

    public boolean isCodingWindowOpened() {
        return this.currentCoderComponent != null;
    }

    private void closeTeamProblemWindow() {
        this.openingProblem = false;
        this.problemList.setEnabled(true);
        this.resetFocus();
    }

    public void challengeButtonEvent(ActionEvent actionEvent) {
        this.statusFrame.showFrame(true);
    }

    private TimerPanel getTimerPanel() {
        return this.panel.getTimerPanel();
    }

    public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
        if (!ContestConstants.isPracticeRoomType((int)this.roomModel.getType())) {
            this.getTimerPanel().updateSystestProgress(n, n2);
        }
    }

    public void enableRound(RoundModel roundModel) {
    }
}

