/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.connectiontype.ConnectionType;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.LoginException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ShowdownLoginRoom
extends RoomModule {
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final JTextField firstNameField = new JTextField();
    private final JTextField lastNameField = new JTextField();
    private final JTextField emailField = new JTextField();
    private final JTextField phoneField = new JTextField();
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private JButton loginButton;
    private final JTextArea legalese = new JTextArea("", 5, 40);
    private final JTextField legalese2 = new JTextField("All content in the arena (c)2008 TopCoder, Inc.  All Rights Reserved", 40);
    private ActionListener lb_al;
    private ActionListener un_al;
    private ActionListener pw_al;
    private DocumentListener documentListener;
    private final ContestApplet ca;
    private boolean loginEnabled = true;

    public ShowdownLoginRoom(ContestApplet contestApplet) {
        super(contestApplet, 0);
        this.ca = contestApplet;
        this.create();
    }

    public JPanel reload() {
        this.clear();
        return this.panel;
    }

    public void enter() {
        this.loginButton.addActionListener(this.lb_al);
        this.usernameField.addActionListener(this.un_al);
        this.passwordField.addActionListener(this.pw_al);
        this.usernameField.getDocument().addDocumentListener(this.documentListener);
        this.passwordField.getDocument().addDocumentListener(this.documentListener);
        this.resetFocus();
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.panel.setBackground(Common.BG_COLOR);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        ContestSponsorPanel contestSponsorPanel = new ContestSponsorPanel(this.ca, CommonData.getSponsorLoginImageAddr(this.ca.getSponsorName()));
        Common.insertInPanel(contestSponsorPanel, this.panel, gridBagConstraints, 0, 0, 3, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        Common.insertInPanel(this.createLoginPanel(), this.panel, gridBagConstraints, 0, 1, 3, 1, 0.1, 0.0);
        gridBagConstraints.anchor = 11;
        Common.insertInPanel(ShowdownLoginRoom.createGuestPanel(), this.panel, gridBagConstraints, 0, 2, 3, 1, 0.1, 0.0);
        this.legalese.setEditable(false);
        this.legalese.setLineWrap(true);
        this.legalese.setWrapStyleWord(true);
        this.legalese.setForeground(Common.ID_COLOR);
        this.legalese.setBackground(Common.BG_COLOR);
        this.legalese.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 25, 5, 25);
        JLabel jLabel = new JLabel("*** By logging into the arena you are agreeing to these rules and regulations ***");
        jLabel.setForeground(Common.ID_COLOR);
        Common.insertInPanel(jLabel, this.panel, gridBagConstraints, 0, 4, 3, 1, 0.0, 0.0);
        gridBagConstraints.anchor = 10;
        String string = this.getTerms();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setForeground(Common.ID_COLOR);
        jTextArea.setBackground(Common.BG_COLOR);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 25, 5, 25);
        Common.insertInPanel(jScrollPane, this.panel, gridBagConstraints, 0, 5, 3, 1, 1.0, 1.0);
        this.legalese2.setEditable(false);
        this.legalese2.setForeground(Common.ID_COLOR);
        this.legalese2.setBackground(Common.BG_COLOR);
        this.legalese2.setHorizontalAlignment(0);
        this.legalese2.setBorder(null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(15, 25, 5, 25);
        Common.insertInPanel(this.legalese2, this.panel, gridBagConstraints, 1, 6, 1, 1, 0.1, 0.0);
    }

    private String getTerms() {
        String string = "";
        try {
            string = Common.getURLContent(new URL(System.getProperty("com.topcoder.showdown.termsURL")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private JPanel createLoginPanel() {
        int n = 339;
        int n2 = 230;
        Color color = Common.BG_COLOR;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        Common.insertInPanel(this.createInnerLoginPanel(), jPanel, gridBagConstraints, 0, 0, 1, 1);
        return jPanel;
    }

    public boolean leave() {
        this.loginButton.removeActionListener(this.lb_al);
        this.usernameField.removeActionListener(this.un_al);
        this.passwordField.removeActionListener(this.pw_al);
        this.usernameField.getDocument().removeDocumentListener(this.documentListener);
        this.passwordField.getDocument().removeDocumentListener(this.documentListener);
        return true;
    }

    public void resetFocus() {
        MoveFocus.moveFocus(this.passwordField);
        MoveFocus.moveFocus(this.usernameField);
    }

    public void clear() {
        this.loginEnabled = true;
        this.usernameField.setText("");
        this.passwordField.setText("");
        this.firstNameField.setText("");
        this.lastNameField.setText("");
        this.phoneField.setText("");
        this.emailField.setText("");
    }

    private JPanel createInnerLoginPanel() {
        int n = 230;
        int n2 = 300;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setOpaque(false);
        this.loginButton = Common.getTextButton("");
        JLabel jLabel = new JLabel("First Name:");
        JLabel jLabel2 = new JLabel("Last Name:");
        JLabel jLabel3 = new JLabel("Email:");
        JLabel jLabel4 = new JLabel("*Cell Phone:");
        JLabel jLabel5 = new JLabel("");
        JLabel jLabel6 = new JLabel("Username:");
        JLabel jLabel7 = new JLabel("Password:");
        this.loginButton.setIcon(Common.getImage("go_but.gif", this.parentFrame));
        this.loginButton.setPressedIcon(Common.getImage("go_but_in.gif", this.parentFrame));
        this.loginButton.setDisabledIcon(Common.getImage("go_but_gray.gif", this.parentFrame));
        this.loginButton.setBackground(Color.white);
        this.loginButton.setForeground(Color.white);
        this.loginButton.setEnabled(false);
        jLabel.setForeground(Common.ID_COLOR);
        jLabel2.setForeground(Common.ID_COLOR);
        jLabel3.setForeground(Common.ID_COLOR);
        jLabel6.setForeground(Common.ID_COLOR);
        jLabel4.setForeground(Common.ID_COLOR);
        jLabel7.setForeground(Common.ID_COLOR);
        this.lb_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowdownLoginRoom.this.loginButtonClick();
            }
        };
        this.un_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowdownLoginRoom.this.userNameEvent();
            }
        };
        this.pw_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShowdownLoginRoom.this.passWordEvent();
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ShowdownLoginRoom.this.checkLoginButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ShowdownLoginRoom.this.checkLoginButton();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        gridBagConstraints.anchor = 11;
        int n3 = 0;
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, n3, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.firstNameField, jPanel, gridBagConstraints, 1, n3, 1, 1, 1.0, 1.0);
        int n4 = n3 + 1;
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, n4, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.lastNameField, jPanel, gridBagConstraints, 1, n4, 1, 1, 1.0, 1.0);
        int n5 = n4 + 1;
        Common.insertInPanel(jLabel3, jPanel, gridBagConstraints, 0, n5, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.emailField, jPanel, gridBagConstraints, 1, n5, 1, 1, 1.0, 1.0);
        int n6 = n5 + 1;
        Common.insertInPanel(jLabel4, jPanel, gridBagConstraints, 0, n6, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.phoneField, jPanel, gridBagConstraints, 1, n6, 1, 1, 1.0, 1.0);
        JTextArea jTextArea = new JTextArea("* Your cell phone number will only be used for us to easily contact you in the event that you are one of the daily winners.", 3, 40);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setForeground(Color.RED);
        jTextArea.setBackground(Common.BG_COLOR);
        jTextArea.setPreferredSize(new Dimension(0, 0));
        jTextArea.setFont(jLabel4.getFont());
        int n7 = n6 + 1;
        Common.insertInPanel(jTextArea, jPanel, gridBagConstraints, 0, n7, 2, 1, 0.0, 1.0);
        int n8 = n7 + 1;
        Common.insertInPanel(jLabel5, jPanel, gridBagConstraints, 0, n8, 1, 1, 0.0, 1.0);
        int n9 = n8 + 1;
        Common.insertInPanel(jLabel6, jPanel, gridBagConstraints, 0, n9, 1, 1, 0.0, 1.0);
        Common.insertInPanel(this.usernameField, jPanel, gridBagConstraints, 1, n9, 1, 1, 1.0, 1.0);
        int n10 = n9 + 1;
        Common.insertInPanel(jLabel7, jPanel, gridBagConstraints, 0, n10, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.passwordField, jPanel, gridBagConstraints, 1, n10, 1, 1, 1.0, 1.0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        int n11 = n10 + 1;
        Common.insertInPanel(this.loginButton, jPanel, gridBagConstraints, 1, n11, 1, 1, 1.0, 1.0);
        return jPanel;
    }

    private static JPanel createGuestPanel() {
        int n = 300;
        int n2 = 30;
        Color color = Common.BG_COLOR;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        jPanel.setMinimumSize(new Dimension(n, n2));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        JLabel jLabel = new JLabel("New User? Fill in all fields.");
        JLabel jLabel2 = new JLabel("Returning User? Just provide Username / Password.");
        jLabel.setForeground(Common.ID_COLOR);
        jLabel2.setForeground(Common.ID_COLOR);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1);
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, 1, 1, 1);
        return jPanel;
    }

    private synchronized void loginButtonClick() {
        if (this.loginEnabled) {
            this.loginEnabled = false;
            Contestant contestant = this.parentFrame.getModel();
            try {
                String string = this.usernameField.getText();
                char[] cArray = this.passwordField.getPassword();
                String string2 = this.firstNameField.getText();
                String string3 = this.lastNameField.getText();
                String string4 = this.phoneField.getText();
                String string5 = this.emailField.getText();
                this.parentFrame.getModel().setConnectionType(ConnectionType.DIRECT);
                contestant.loginWithEmail(string, cArray, string2, string3, string5, "Sun", string4);
            }
            catch (LoginException loginException) {
                this.parentFrame.popup(1, "Login Request", loginException.getMessage());
                contestant.reset();
            }
            if (contestant.isLoggedIn()) {
                this.parentFrame.showImportantMessages();
                this.parentFrame.getRoomManager().loadRoom(3, -1L, 1);
                this.clear();
            } else {
                this.loginEnabled = true;
            }
            this.resetFocus();
        }
    }

    private void userNameEvent() {
        if (!this.isUsernameEmpty()) {
            MoveFocus.moveFocus(this.passwordField);
        }
    }

    private void passWordEvent() {
        if (this.isEnabled()) {
            this.loginButton.doClick();
        }
    }

    private void checkLoginButton() {
        boolean bl = this.usernameField.getText().length() > 0 && this.passwordField.getPassword().length > 0;
        this.loginButton.setEnabled(bl);
    }

    private boolean isUsernameEmpty() {
        return this.usernameField.getText().length() <= 0;
    }

    private boolean isEnabled() {
        return !this.isUsernameEmpty() && this.passwordField.getPassword().length > 0;
    }

    protected void addViews() {
    }

    void clearViews() {
    }
}

