/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.main.MainMenuPanel;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.contestApplet.rooms.LobbyRoom;
import com.topcoder.client.contestApplet.rooms.LongCoderRoom;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.rooms.TeamCoderRoom;
import com.topcoder.client.contestApplet.rooms.TopCoderLoginRoom;
import com.topcoder.client.contestApplet.uilogic.frames.RoomInfoFrame;
import com.topcoder.client.contestApplet.uilogic.panels.IntermissionPanelManager;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.TimeOutException;
import com.topcoder.client.contestant.view.RoomViewManager;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.ContestConstants;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;

public final class RoomManager
implements RoomViewManager {
    private ContestApplet ca = null;
    private RoomModule currentRoom = null;
    protected String roomVersion = null;
    private RoomModule loginRoom = null;
    private LobbyRoom lobbyRoom = null;
    private CoderRoom coderRoom = null;
    private CoderRoom longCoderRoom = null;
    private TeamCoderRoom teamCoderRoom = null;
    private CoderRoom spectatorRoom = null;
    private int currentRoomType = 0;
    private long currentRoomID = -1L;
    private IntermissionPanelManager is = null;
    private Thread loadRoom = null;
    private JPanel mainPanel = null;
    private JPanel navPanel = null;
    private MainMenuPanel menuPanel = null;
    private int intermissionType = 1;
    private boolean loading = false;
    private Object loadingLock = new Object();

    public RoomManager(ContestApplet contestApplet, String string) {
        this.ca = contestApplet;
        this.roomVersion = string;
        this.is = new IntermissionPanelManager(contestApplet);
        try {
            this.loginRoom = (RoomModule)Class.forName("com.topcoder.client.contestApplet.rooms." + string + "LoginRoom").getConstructor(contestApplet.getClass()).newInstance(contestApplet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Error instantiating login room: " + exception.getMessage());
        }
    }

    private RoomModule createRoom(RoomModel roomModel) {
        RoomModule roomModule = null;
        switch (roomModel.getType()) {
            case 3: {
                roomModule = this.lobbyRoom = new LobbyRoom(this.ca);
                break;
            }
            case 8: {
                roomModule = new LobbyRoom(this.ca, roomModel.getType());
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: {
                if (roomModel.getRoundModel().getRoundType().isLongRound()) {
                    this.longCoderRoom = new LongCoderRoom(this.ca);
                    roomModule = this.longCoderRoom;
                    break;
                }
                this.coderRoom = new CoderRoom(this.ca);
                roomModule = this.coderRoom;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                this.teamCoderRoom = new TeamCoderRoom(this.ca);
                roomModule = this.teamCoderRoom;
                break;
            }
            default: {
                this.loginRoom = new TopCoderLoginRoom(this.ca);
                roomModule = this.loginRoom;
            }
        }
        this.currentRoomType = roomModel.getType();
        return roomModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInitRoom() {
        this.blockIfLoading();
        try {
            if (this.currentRoom != null) {
                this.currentRoom.leave();
            }
            this.mainPanel = this.ca.getMainFrame().getMainPanel();
            this.navPanel = this.ca.getMainFrame().getNavPanel();
            this.menuPanel = this.ca.getMainFrame().getMenuPanel();
            this.currentRoomType = 0;
            this.currentRoom = this.loginRoom;
            this.mainPanel.removeAll();
            this.mainPanel.add(this.loginRoom.reload());
            this.loginRoom.enter();
        }
        finally {
            this.doneLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockIfLoading() {
        Object object = this.loadingLock;
        synchronized (object) {
            while (this.loading) {
                try {
                    this.loadingLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.loading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneLoading() {
        Object object = this.loadingLock;
        synchronized (object) {
            this.loading = false;
            this.loadingLock.notify();
        }
    }

    public void loadRoom(int n, int n2) {
        this.loadRoom(n, -1L, n2);
    }

    public void loadRoom(int n, long l, int n2) {
        this.blockIfLoading();
        this.intermissionType = n2;
        try {
            if (!this.currentRoom.leave()) {
                return;
            }
            this.currentRoomType = n;
            this.currentRoomID = l;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        if (n == 0) {
            this.loadNewRoom(false);
        } else {
            this.loadNewRoom(true);
        }
    }

    private void loadNewRoom(final boolean bl) {
        this.loadRoom = new Thread(new Runnable(){

            public void run() {
                block13: {
                    boolean bl2 = false;
                    String string = null;
                    String string2 = null;
                    try {
                        if (bl) {
                            while (true) {
                                try {
                                    RoomManager.this.moveToRoom(RoomManager.this.currentRoomType, RoomManager.this.currentRoomID);
                                    break block13;
                                }
                                catch (TimeOutException timeOutException) {
                                    if (ContestConstants.isPracticeRoomType((int)RoomManager.this.currentRoomType)) {
                                        Thread.yield();
                                        continue;
                                    }
                                    throw timeOutException;
                                }
                                break;
                            }
                        }
                        RoomManager.this.loadLoginRoom();
                    }
                    catch (TimeOutException timeOutException) {
                        string = "Request Timeout";
                        string2 = "Your Move request timed out...logging you off";
                        bl2 = true;
                    }
                    catch (RuntimeException runtimeException) {
                        string = "Error";
                        string2 = "Error while processing your move request, logging you off...";
                        bl2 = true;
                        throw runtimeException;
                    }
                    finally {
                        RoomManager.this.doneLoading();
                        if (bl2) {
                            RoomManager.this.ca.getModel().logoff();
                            Common.showMessage(string, string2, RoomManager.this.ca.getMainFrame());
                        }
                    }
                }
            }
        }, "Room Loader");
        this.loadIntermission();
    }

    private void createNewRoom(RoomModel roomModel) {
        if (this.currentRoom != null && !this.currentRoom.leave()) {
            return;
        }
        this.currentRoomType = roomModel.getType();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (this.currentRoomType) {
            case 3: 
            case 8: {
                this.currentRoom = this.lobbyRoom;
                break;
            }
            case 1: 
            case 5: {
                this.currentRoom = this.spectatorRoom;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: {
                if (roomModel.getRoundModel().getRoundType().isLongRound()) {
                    this.currentRoom = this.longCoderRoom;
                    break;
                }
                this.currentRoom = this.coderRoom;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                this.currentRoom = this.teamCoderRoom;
                break;
            }
            default: {
                this.currentRoom = this.loginRoom;
            }
        }
        if (this.currentRoom == null) {
            this.currentRoom = this.createRoom(roomModel);
        }
        this.currentRoom.clear();
    }

    private void loadLoginRoom() {
        if (this.currentRoom != null && !this.currentRoom.leave()) {
            return;
        }
        this.currentRoom = this.loginRoom;
        this.currentRoom.clear();
        this.showCurrentRoom();
    }

    private void loadIntermission() {
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        RoomManager.this.navPanel.setVisible(false);
                        MoveFocus.moveFocus(RoomManager.this.ca.getMainFrame());
                        RoomManager.this.mainPanel.removeAll();
                        RoomManager.this.mainPanel.add(RoomManager.this.is.getIntermissionPanel(RoomManager.this.intermissionType));
                        RoomManager.this.mainPanel.revalidate();
                        RoomManager.this.mainPanel.repaint();
                        RoomManager.this.loadRoom.setDaemon(true);
                        RoomManager.this.loadRoom.start();
                    }
                    catch (RuntimeException runtimeException) {
                        RoomManager.this.doneLoading();
                        throw runtimeException;
                    }
                }
            }, "Intermission");
            thread.start();
        }
        catch (RuntimeException runtimeException) {
            this.doneLoading();
            throw runtimeException;
        }
    }

    public RoomModule getCurrentRoom() {
        return this.currentRoom;
    }

    public int getCurrentRoomType() {
        return this.currentRoomType;
    }

    public long getCurrentRoomID() {
        return this.currentRoomID;
    }

    public boolean leave() {
        return this.currentRoom.leave();
    }

    private void moveToRoom(int n, long l) throws TimeOutException {
        this.ca.getModel().move(n, l);
    }

    public void watch(final long l) {
        RoomModel roomModel = this.ca.getModel().getRoom(l);
        if (!roomModel.hasWatchView()) {
            try {
                roomModel = this.ca.getModel().watch(l);
                final RoomInfoFrame roomInfoFrame = new RoomInfoFrame(this.ca, roomModel);
                roomModel.setWatchView(roomInfoFrame);
                roomInfoFrame.getFrame().addEventListener("window", new UIWindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void windowClosing(WindowEvent windowEvent) {
                        try {
                            RoomManager.this.ca.getModel().unwatch(l);
                        }
                        finally {
                            if (roomInfoFrame.isEnabled()) {
                                roomInfoFrame.unsetModel();
                            }
                        }
                    }
                });
            }
            catch (TimeOutException timeOutException) {
                this.ca.popup(1, "Watch Request", "Your watch request timed out.");
                return;
            }
        }
        ((RoomInfoFrame)roomModel.getWatchView()).showFrame(true);
    }

    private void showCurrentRoom() {
        this.menuPanel.setMenuConfig(this.currentRoomType, this.currentRoom.roomModel);
        JPanel jPanel = this.currentRoom.reload();
        this.currentRoom.setConnectionStatus(true);
        MoveFocus.moveFocus(this.mainPanel);
        this.mainPanel.removeAll();
        jPanel.revalidate();
        jPanel.repaint();
        this.mainPanel.add(jPanel);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        if (this.currentRoomType != 0) {
            this.navPanel.setVisible(true);
        }
        this.currentRoom.resetFocus();
        this.currentRoom.enter();
    }

    public void setCurrentRoom(RoomModel roomModel) {
        this.createNewRoom(roomModel);
        roomModel.setCurrentRoomView(this.currentRoom);
        this.showCurrentRoom();
    }

    public void addRoom(RoomModel roomModel) {
    }

    public void removeRoom(RoomModel roomModel) {
    }

    public void clearRooms() {
    }
}

