/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.connectiontype.ConnectionType;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.uilogic.frames.AuthenticatorDialog;
import com.topcoder.client.contestApplet.uilogic.frames.BackgroundTaskStatusDialog;
import com.topcoder.client.contestApplet.uilogic.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.LoginException;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIKeyListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public abstract class BaseLoginRoom
extends RoomModule {
    private boolean loginEnabled = true;
    private UIComponent panel;
    private UIComponent userName;
    private UIComponent passWord;
    private UIComponent loginButton;
    private UIComponent proxyButton;
    private UIComponent connection;
    private UIComponent autoDetectButton;
    private UIComponent legalese;
    private UIComponent legalese2;
    private UIComponent legalese3;
    private UIComponent versioning;
    private UIActionListener lb_al = null;
    private UIActionListener pb_al = null;
    private UIActionListener un_al = null;
    private UIActionListener pw_al = null;
    private UIActionListener autoDectec_al = null;
    private UIKeyListener pw_kl = null;
    private DocumentListener documentListener;
    protected ContestApplet ca;
    protected UIPage page;
    private ContestSponsorPanel sponsorPanel;
    private static final int MAX_PASSWORD_LENGTH = 30;

    protected abstract String getSponsorCompany();

    protected abstract URL getRegistrationURL() throws MalformedURLException;

    protected abstract String getLegaleseText();

    public BaseLoginRoom(ContestApplet contestApplet) {
        super(contestApplet, 0);
        this.ca = contestApplet;
        this.page = this.ca.getCurrentUIManager().getUIPage("login");
        this.legalese = this.page.getComponent("legalese");
        this.legalese2 = this.page.getComponent("legalese2");
        this.legalese3 = this.page.getComponent("legalese3");
        this.versioning = this.page.getComponent("versioning");
        this.panel = this.page.getComponent("root_panel");
        this.legalese.setProperty("text", this.getLegaleseText());
        this.legalese2.setProperty("text", "All content on the website and in the arena (c)2003 TopCoder, Inc.  All Rights Reserved");
        this.legalese3.setProperty("text", "Protected by U.S. patent number 6,569,012");
        this.versioning.setProperty("text", "Arena Applet version " + CommonData.CURRENT_VERSION + " (" + CommonData.UPDATE_DATE + ")");
        this.create();
    }

    public JPanel reload() {
        this.clear();
        return (JPanel)this.panel.getEventSource();
    }

    public void enter() {
        this.loginButton.addEventListener("action", this.lb_al);
        this.proxyButton.addEventListener("action", this.pb_al);
        this.userName.addEventListener("action", this.un_al);
        this.passWord.addEventListener("action", this.pw_al);
        this.passWord.addEventListener("key", this.pw_kl);
        this.autoDetectButton.addEventListener("action", this.autoDectec_al);
        ((Document)this.userName.getProperty("document")).addDocumentListener(this.documentListener);
        ((Document)this.passWord.getProperty("document")).addDocumentListener(this.documentListener);
        this.resetFocus();
    }

    public void create() {
        this.loginButton = this.page.getComponent("login_button");
        this.userName = this.page.getComponent("username");
        this.passWord = this.page.getComponent("password");
        this.connection = this.page.getComponent("select_connection");
        this.autoDetectButton = this.page.getComponent("autodetect_connection");
        this.proxyButton = this.page.getComponent("proxy_button");
        ConnectionType[] connectionTypeArray = ConnectionType.getAvailableTypes();
        this.connection.setProperty("items", connectionTypeArray);
        String string = this.loadConnectionTypeId();
        this.connection.setProperty("selecteditem", this.findOption(this.connection, string));
        this.connection.setProperty("tooltiptext", this.buildConnectionToolTip(connectionTypeArray));
        this.page.getComponent("register").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.registerButtonClick();
            }
        });
        this.lb_al = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.loginButtonClick();
            }
        };
        this.pb_al = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.proxyButtonClick();
            }
        };
        this.un_al = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.userNameEvent();
            }
        };
        this.pw_al = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.passWordEvent();
            }
        };
        this.pw_kl = new UIKeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (BaseLoginRoom.this.checkPasswordLength(keyEvent)) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (BaseLoginRoom.this.checkPasswordLength(keyEvent)) {
                    keyEvent.consume();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (BaseLoginRoom.this.checkPasswordLength(keyEvent)) {
                    keyEvent.consume();
                }
            }
        };
        this.autoDectec_al = new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.autoDetectButtonClick();
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BaseLoginRoom.this.checkLoginButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BaseLoginRoom.this.checkLoginButton();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.sponsorPanel = new ContestSponsorPanel(this.page.getComponent("sponsor_logo"), CommonData.getSponsorLoginImageAddr(this.getSponsorCompany()));
    }

    public boolean leave() {
        this.loginButton.removeEventListener("action", this.lb_al);
        this.proxyButton.removeEventListener("action", this.pb_al);
        this.userName.removeEventListener("action", this.un_al);
        this.passWord.removeEventListener("action", this.pw_al);
        this.passWord.removeEventListener("key", this.pw_kl);
        this.autoDetectButton.removeEventListener("action", this.autoDectec_al);
        ((Document)this.userName.getProperty("document")).removeDocumentListener(this.documentListener);
        ((Document)this.passWord.getProperty("document")).removeDocumentListener(this.documentListener);
        return true;
    }

    public void resetFocus() {
        MoveFocus.moveFocus(this.userName);
    }

    public void clear() {
        this.loginEnabled = true;
        this.userName.setProperty("text", "");
        this.passWord.setProperty("text", "");
    }

    private ConnectionType findOption(UIComponent uIComponent, String string) {
        ConnectionType connectionType = ConnectionType.getById((String)string);
        if (connectionType == null) {
            return (ConnectionType)uIComponent.performAction("getItemAt", new Object[]{new Integer(0)});
        }
        return connectionType;
    }

    private String buildConnectionToolTip(ConnectionType[] connectionTypeArray) {
        String string = "<html><p>Select the proper connection type for you,\nor use the autodetect button next to this option:</p>";
        for (int i = 0; i < connectionTypeArray.length; ++i) {
            string = string + "<li><b>" + connectionTypeArray[i].getName() + ": </b>" + connectionTypeArray[i].getDescription().replaceAll("\n", "<br>");
        }
        string = string + "</html>";
        return string;
    }

    private String loadConnectionTypeId() {
        return LocalPreferences.getInstance().getProperty("com.topcoder.client.contestApplet.LocalPreferences.connectionType");
    }

    private void saveConnectionTypeId() {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setProperty("com.topcoder.client.contestApplet.LocalPreferences.connectionType", this.getSelectConnectionId());
        try {
            localPreferences.savePreferences();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getSelectConnectionId() {
        return ((ConnectionType)this.connection.getProperty("selecteditem")).getId();
    }

    private synchronized void loginButtonClick() {
        if (this.loginEnabled) {
            String string = this.getSelectConnectionId();
            if (!string.equals(this.loadConnectionTypeId())) {
                this.saveConnectionTypeId();
            }
            this.parentFrame.getModel().setConnectionType(ConnectionType.getById((String)string));
            this.loginEnabled = false;
            try {
                String string2 = this.parentFrame.getModel().getCurrentAppletVersion();
                if (!string2.equals("") && !CommonData.isVersionCurrent(string2)) {
                    this.parentFrame.popup(1, "Login Request", "Your current applet version is out of date.  Please restart the applet and refresh your internet browser cache.");
                    this.parentFrame.getModel().reset();
                } else {
                    this.parentFrame.getModel().login((String)this.userName.getProperty("Text"), (char[])this.passWord.getProperty("Password"), null);
                }
            }
            catch (LoginException loginException) {
                this.parentFrame.popup(1, "Login Request", loginException.getMessage());
                this.parentFrame.getModel().reset();
            }
            if (this.parentFrame.getModel().isLoggedIn()) {
                this.parentFrame.showImportantMessages();
                this.parentFrame.getRoomManager().loadRoom(3, -1L, 1);
            } else {
                this.parentFrame.getModel().reset();
            }
            this.loginEnabled = true;
            this.clear();
            this.resetFocus();
        }
    }

    private void proxyButtonClick() {
        AuthenticatorDialog authenticatorDialog = new AuthenticatorDialog(this.ca);
        authenticatorDialog.show();
    }

    public void clearButtonClick(ActionEvent actionEvent) {
        this.clear();
    }

    public void registerButtonClick() {
        try {
            Common.showURL(this.ca.getAppletContext(), this.getRegistrationURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    private void userNameEvent() {
        if (!this.isUsernameEmpty()) {
            MoveFocus.moveFocus(this.passWord);
        }
    }

    private void passWordEvent() {
        if (this.isEnabled()) {
            this.loginButton.performAction("doClick");
        }
    }

    private boolean checkPasswordLength(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        char[] cArray = (char[])this.passWord.getProperty("Password");
        if (cArray.length > 30) {
            char[] cArray2 = new char[30];
            System.arraycopy(cArray, 0, cArray2, 0, 30);
            cArray = cArray2;
            this.passWord.setProperty("Text", new String(cArray));
            return true;
        }
        int n = (Integer)this.passWord.getProperty("SelectionEnd") - (Integer)this.passWord.getProperty("SelectionStart");
        return c > '\u001f' && c < '\u007f' && cArray.length >= 30 && n < 1;
    }

    private void checkLoginButton() {
        boolean bl = ((String)this.userName.getProperty("Text")).length() > 0 && ((char[])this.passWord.getProperty("Password")).length > 0;
        this.loginButton.setProperty("Enabled", bl);
    }

    private boolean isUsernameEmpty() {
        return ((String)this.userName.getProperty("Text")).length() <= 0;
    }

    private boolean isEnabled() {
        return !this.isUsernameEmpty() && ((char[])this.passWord.getProperty("Password")).length > 0;
    }

    protected void addViews() {
    }

    void clearViews() {
    }

    private void autoDetectButtonClick() {
        final ConnectionType[] connectionTypeArray = new ConnectionType[1];
        final BackgroundTaskStatusDialog backgroundTaskStatusDialog = new BackgroundTaskStatusDialog(this.parentFrame, this.parentFrame.getCurrentFrame(), "Autodetect", "Detecting connection type. Please wait...");
        backgroundTaskStatusDialog.addCancelActionListener(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseLoginRoom.this.parentFrame.getModel().cancelAutoDetectConnectionType();
                backgroundTaskStatusDialog.updateMessage("Cancelling....");
            }
        });
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    connectionTypeArray[0] = BaseLoginRoom.this.parentFrame.getModel().autoDetectConnectionType(new Contestant.StatusListener(){

                        public void updateStatus(String string) {
                            backgroundTaskStatusDialog.updateMessage(string);
                        }
                    });
                    if (connectionTypeArray[0] != null) {
                        BaseLoginRoom.this.connection.setProperty("SelectedItem", BaseLoginRoom.this.findOption(BaseLoginRoom.this.connection, connectionTypeArray[0].getId()));
                        BaseLoginRoom.this.saveConnectionTypeId();
                    }
                }
                finally {
                    backgroundTaskStatusDialog.dispose();
                }
            }
        }, "Autodetect");
        thread.setDaemon(true);
        thread.start();
        backgroundTaskStatusDialog.setVisible(true);
        backgroundTaskStatusDialog.dispose();
        if (connectionTypeArray[0] != null) {
            Common.showMessage("Autodetect", "Connection type: " + connectionTypeArray[0].getName() + " selected.", this.parentFrame.getCurrentFrame());
        } else {
            Common.showMessage("Autodetect", "Could not detect Connection type.", this.parentFrame.getCurrentFrame());
        }
    }

    public UIPage getPage() {
        return this.page;
    }
}

