/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.common.PopUpHelper;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableHeaderRenderer;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

public abstract class TablePanel
extends JPanel {
    ContestApplet ca = null;
    SortedTableModel tableModel;
    JTable contestTable;
    boolean headersVisible = true;
    private JPopupMenu contestPopup = new JPopupMenu();

    protected TablePanel(ContestApplet contestApplet, String string, SortedTableModel sortedTableModel) {
        this(contestApplet, string, sortedTableModel, true);
    }

    TablePanel(ContestApplet contestApplet, String string, SortedTableModel sortedTableModel, boolean bl) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.headersVisible = bl;
        this.tableModel = sortedTableModel;
        this.contestTable = this.createTable((TableModel)sortedTableModel);
        UIManager.put("MenuItem.selectionBackground", Common.HB_COLOR);
        this.createTablePanel(string, 0, 0);
    }

    private void setContestPopup(JPopupMenu jPopupMenu) {
        this.contestPopup = jPopupMenu;
    }

    void setContestPopup(String string, MenuItemInfo[] menuItemInfoArray) {
        this.setContestPopup(PopUpHelper.createPopupMenu(string, menuItemInfoArray));
    }

    private JTable createTable(TableModel tableModel) {
        JTable jTable = new JTable(tableModel);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setBackground(Common.TB_COLOR);
        jTable.setForeground(Common.TF_COLOR);
        jTable.setSelectionBackground(Common.HB_COLOR);
        jTable.setSelectionForeground(Common.HF_COLOR);
        jTable.setShowGrid(false);
        jTable.setSelectionMode(0);
        jTable.getColumnModel().setColumnMargin(0);
        this.setHeaders(jTable);
        ContestTableCellRenderer contestTableCellRenderer = new ContestTableCellRenderer(null, 12);
        jTable.setDefaultRenderer(String.class, contestTableCellRenderer);
        return jTable;
    }

    private void setHeaders(JTable jTable) {
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderRenderer(new ContestTableHeaderRenderer(this.headersVisible, null, 12));
            jTable.getColumnModel().getColumn(i).setCellRenderer(new ContestTableCellRenderer(null, 12));
        }
    }

    private void createTablePanel(String string, int n, int n2) {
        JScrollPane jScrollPane = new JScrollPane(this.contestTable);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(-1, -1, -1, -1);
        this.setBorder(Common.getTitledBorder(string));
        this.setPreferredSize(new Dimension(n, n2));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(Common.TB_COLOR);
        this.contestTable.setPreferredScrollableViewportSize(jScrollPane.getSize());
        Common.insertInPanel(jScrollPane, this, gridBagConstraints, 0, 0, 1, 1);
        this.setBackground(Common.WPB_COLOR);
        this.setOpaque(false);
    }

    public void clear() {
        this.tableModel.clear();
    }

    public JTable getTable() {
        return this.contestTable;
    }

    public SortedTableModel getTableModel() {
        return this.tableModel;
    }

    void rightClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
            int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
            ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
            ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
            this.showContestPopup(mouseEvent);
        }
    }

    void showContestPopup(MouseEvent mouseEvent) {
        this.contestPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }
}

