/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.client.contestApplet.widgets.CellRendererFactory;
import com.topcoder.client.contestApplet.widgets.LongCodeViewer;
import com.topcoder.netCommon.contestantMessages.response.SubmissionHistoryResponse;
import com.topcoder.shared.language.BaseLanguage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class SubmissionHistoryPanel
extends TablePanel {
    private static final String[] headers = new String[]{" ", "Submission", "Time", "Language", "Score"};
    private static final String[] exampleHeaders = new String[]{" ", "Example Submission", "Time", "Language"};
    private static final Class[] classes = new Class[]{String.class, Integer.class, Date.class, String.class, Double.class};
    private static final Class[] exampleClasses = new Class[]{String.class, Integer.class, Date.class, String.class, Double.class};
    private final MenuItemInfo[] OPEN_POPUP = new MenuItemInfo[]{new MenuItemInfo("Source", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            SubmissionHistoryPanel.this.openSourceEvent();
        }
    })};
    private final MenuItemInfo[] EXAMPLE_POPUP = new MenuItemInfo[]{new MenuItemInfo("Source", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            SubmissionHistoryPanel.this.openSourceEvent();
        }
    }), new MenuItemInfo("Last example results", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SubmissionHistoryPanel.this.ca.getModel().getRound(SubmissionHistoryPanel.this.response.getRoundId()).getRoundTypeId() == -2) {
                Common.showMessage("Error", "Not available for this round", SubmissionHistoryPanel.this.ca);
            } else {
                SubmissionHistoryPanel.this.openResultsEvent();
            }
        }
    })};
    private SubmissionHistoryResponse response;

    public SubmissionHistoryPanel(ContestApplet contestApplet, SubmissionHistoryResponse submissionHistoryResponse) {
        super(contestApplet, submissionHistoryResponse.isExampleHistory() ? "Example Submissions" : "Full Submissions", new SubmissionHistoryTableModel(submissionHistoryResponse));
        this.response = submissionHistoryResponse;
        this.setContestPopup("", submissionHistoryResponse.isExampleHistory() ? this.EXAMPLE_POPUP : this.OPEN_POPUP);
        this.contestTable.setRowMargin(3);
        this.contestTable.setRowSelectionAllowed(true);
        this.contestTable.setColumnSelectionAllowed(false);
        this.contestTable.setAutoResizeMode(3);
        TableColumnModel tableColumnModel = this.contestTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(10);
        tableColumnModel.getColumn(1).setMaxWidth(70);
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(CellRendererFactory.apply(tableColumn.getCellRenderer(), new SimpleDateFormat("MM-dd-yyyy HH:mm:ss"), 0));
        tableColumn.setHeaderRenderer(CellRendererFactory.apply(tableColumn.getHeaderRenderer(), 0));
        tableColumn.setWidth(120);
        if (!submissionHistoryResponse.isExampleHistory()) {
            TableColumn tableColumn2 = tableColumnModel.getColumn(4);
            tableColumn2.setCellRenderer(CellRendererFactory.apply(tableColumn2.getCellRenderer(), new DecimalFormat("0.00"), 4));
            tableColumn2.setHeaderRenderer(CellRendererFactory.apply(tableColumn2.getHeaderRenderer(), 0));
        }
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SubmissionHistoryPanel.this.mouseClickEvent(mouseEvent);
            }
        });
        this.contestTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SubmissionHistoryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.contestTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SubmissionHistoryPanel.this.openSourceEvent();
                }
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openSourceEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
        }
    }

    private synchronized void openSourceEvent() {
        int n = this.contestTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        n = (Integer)this.tableModel.get(n);
        LongCodeViewer longCodeViewer = new LongCodeViewer(this.ca, this.ca.getCurrentFrame(), this.response.getRoundId(), this.response.getHandle(), this.response.getComponentId(), this.response.isExampleHistory(), this.response.getNumber(n), true);
        longCodeViewer.show();
    }

    private synchronized void openResultsEvent() {
        this.ca.getRequester().requestLongTestResults(this.response.getComponentId(), this.getRoom(), this.response.getHandle(), 0);
    }

    private long getRoom() {
        return this.ca.getModel().getRound(this.response.getRoundId()).getRoomByCoder(this.response.getHandle()).getRoomID();
    }

    private static class SubmissionHistoryTableModel
    extends SortedTableModel {
        private SubmissionHistoryResponse response;

        public SubmissionHistoryTableModel(SubmissionHistoryResponse submissionHistoryResponse) {
            super(submissionHistoryResponse.isExampleHistory() ? exampleHeaders : headers, submissionHistoryResponse.isExampleHistory() ? exampleClasses : classes);
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            this.addSortElement(new SortElement(3, false));
            if (!submissionHistoryResponse.isExampleHistory()) {
                this.addSortElement(new SortElement(4, false));
            }
            this.response = submissionHistoryResponse;
            int n = submissionHistoryResponse.getCount();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Integer(i));
            }
            this.update(arrayList);
        }

        public Object getValueAt(int n, int n2) {
            int n3 = ((Number)this.get(n)).intValue();
            return this.getDirectValueAt(n3, n2);
        }

        private Object getDirectValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.response.hasPendingTest(n) ? "*" : " ";
                }
                case 1: {
                    return new Integer(this.response.getNumber(n));
                }
                case 2: {
                    return new Date(this.response.getTime(n));
                }
                case 3: {
                    return BaseLanguage.getLanguage((int)this.response.getLanguageId(n)).getName();
                }
                case 4: {
                    return new Double(this.response.getScore(n));
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                Comparable comparable;
                int n3;
                SortElement sortElement = (SortElement)iterator.next();
                int n4 = sortElement.getColumn();
                int n5 = n3 = sortElement.isOpposite() ? -1 : 1;
                Comparable comparable2 = (Comparable)this.getDirectValueAt(n, n4);
                int n6 = comparable2.compareTo(comparable = (Comparable)this.getDirectValueAt(n2, n4));
                if (n6 == 0) continue;
                return n3 * n6;
            }
            return 0;
        }
    }
}

