/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserTableModel;
import com.topcoder.client.contestApplet.panels.table.UserTablePanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class HSRegistrantsTablePanel
extends UserTablePanel {
    private JFrame jf = null;
    public JLabel totalLabel;
    public JLabel newbieLabel;

    public HSRegistrantsTablePanel(ContestApplet contestApplet, JFrame jFrame) {
        super(contestApplet, "Who's registered", new UserTableModel(contestApplet.getModel(), CommonData.hsRegistrantsHeader), true);
        this.jf = jFrame;
        this.setContestPopup("User Info", this.USER_POPUP);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                HSRegistrantsTablePanel.this.tableCountEvent();
            }
        });
        this.setToolTipText("List of users currently registered for the competition.");
        this.totalLabel = new JLabel("TESTING");
        this.totalLabel.setForeground(Common.THF_COLOR);
        this.totalLabel.setBackground(Common.THB_COLOR);
        this.totalLabel.setFont(this.totalLabel.getFont().deriveFont(1));
        this.newbieLabel = new JLabel("NEWBIE");
        this.newbieLabel.setForeground(Common.THF_COLOR);
        this.newbieLabel.setBackground(Common.THB_COLOR);
        this.newbieLabel.setFont(this.totalLabel.getFont().deriveFont(1));
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HSRegistrantsTablePanel.this.doubleClickEvent(mouseEvent);
            }
        });
        this.tableModel.sort(0, false);
    }

    public int getRowCount() {
        return this.contestTable.getRowCount();
    }

    void tableCountEvent() {
        ((TitledBorder)this.getBorder()).setTitle("");
        if (this.totalLabel != null) {
            this.totalLabel.setText("Total registered [" + this.contestTable.getRowCount() + "]");
            this.newbieLabel.setText("New [" + this.getNewCount() + "]");
        }
        this.revalidate();
        this.repaint();
    }

    public int getNewCount() {
        int n = 0;
        for (int i = 0; i < this.contestTable.getRowCount(); ++i) {
            if (((UserNameEntry)this.contestTable.getValueAt(i, 1)).getRank() != 0) continue;
            ++n;
        }
        return n;
    }

    void doubleClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (this.isEnabled()) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showContestPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    protected void infoPopupEvent() {
        int n = this.contestTable.getSelectedRow();
        String string = ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.jf);
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getUserType());
    }
}

