/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.table.BaseAlgoSummaryTablePanel;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.ChallengeView;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;

public final class DivSummaryTablePanel
extends BaseAlgoSummaryTablePanel
implements ChallengeView {
    private String title;
    public int totalRooms = 0;
    private RoundModel roundModel;
    private Integer divisionID;
    private Integer roomCount = new Integer(0);

    public DivSummaryTablePanel(ContestApplet contestApplet, RoundModel roundModel, JFrame jFrame, boolean bl, Integer n) {
        super(contestApplet, jFrame, bl, false);
        this.roundModel = roundModel;
        this.divisionID = n;
        this.title = this.buildPrefixForTitle() + "Summary (Loading...)";
        this.init();
    }

    private String buildPrefixForTitle() {
        if (this.roundModel.getRoundProperties().hasDivisions()) {
            return "Division " + this.getDivisionID() + " ";
        }
        return "";
    }

    protected String getTitle() {
        return this.title;
    }

    private void setTitle(String string) {
        this.title = this.buildPrefixForTitle() + "Summary " + string;
        this.setBorder(Common.getTitledBorder(this.title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChallengeTable(RoomModel roomModel) {
        if (roomModel == null) {
            return;
        }
        Integer n = this.roomCount;
        synchronized (n) {
            this.roomCount = new Integer(this.roomCount + 1);
            if (this.roomCount < this.totalRooms) {
                this.setTitle("(Loading... " + this.roomCount + "/" + this.totalRooms + ")");
            } else {
                this.setTitle("");
            }
        }
        this.getTableModel().updateChallengeTable();
    }

    protected RoundModel getRoundModel() {
        return this.roundModel;
    }

    protected Integer getDivisionID() {
        return this.divisionID;
    }

    public RoomModel getRoomByCoder(String string) {
        return this.getRoundModel().getRoomByCoder(string);
    }

    protected Collection getCoders() {
        ArrayList<Coder> arrayList = new ArrayList<Coder>(500);
        RoomModel[] roomModelArray = this.getRoundModel().getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.getDivisionID().intValue() || !roomModelArray[i].hasCoders()) continue;
            Coder[] coderArray = roomModelArray[i].getCoders();
            for (int j = 0; j < coderArray.length; ++j) {
                arrayList.add(coderArray[j]);
            }
        }
        return arrayList;
    }

    protected boolean isRoomLeader(String string) {
        return this.roundModel.isRoomLeader(string);
    }
}

