/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.question;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.question.QuestionPanel;
import com.topcoder.netCommon.contest.Answer;
import com.topcoder.netCommon.contest.Question;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SingleChoicePanel
extends QuestionPanel {
    private List answers = null;
    private JRadioButton[] selections = null;
    private Question question;

    public SingleChoicePanel(String string, Question question) {
        this.question = question;
        JTextArea jTextArea = new JTextArea(question.getQuestionText(), 4, 40);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setLayout(new GridBagLayout());
        this.setBorder(Common.getTitledBorder(string));
        this.setBackground(Color.black);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        jTextArea.setSelectedTextColor(Common.HF_COLOR);
        jTextArea.setSelectionColor(Common.HB_COLOR);
        jTextArea.setBackground(Common.MB_COLOR);
        jTextArea.setForeground(Common.MF_COLOR);
        int n = 0;
        Common.insertInPanel(jScrollPane, this, gridBagConstraints, 0, n++, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.answers = question.getAnswerText();
        this.selections = new JRadioButton[this.answers.size()];
        for (int i = 0; i < this.answers.size(); ++i) {
            JRadioButton jRadioButton = new JRadioButton((String)this.answers.get(i), false);
            jRadioButton.setBackground(Color.black);
            jRadioButton.setForeground(Color.white);
            Common.insertInPanel(jRadioButton, this, gridBagConstraints, 0, n++, 1, 1, 0.1, 0.1);
            this.selections[i] = jRadioButton;
            buttonGroup.add(jRadioButton);
        }
    }

    public Answer getAnswer() {
        ArrayList arrayList = new ArrayList(this.answers.size());
        boolean bl = false;
        for (int i = 0; i < this.answers.size(); ++i) {
            if (!this.selections[i].isSelected()) continue;
            bl = true;
            arrayList.add(this.answers.get(i));
            break;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "You must provide an answer to the question: \r\n" + this.question.getQuestionText(), "Error", 0);
            return null;
        }
        return this.question.getAnswer(arrayList);
    }
}

