/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.main;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import java.awt.Color;
import java.awt.Font;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.border.BevelBorder;

public class TCCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private LocalPreferences pref = LocalPreferences.getInstance();

    public TCCheckBoxMenuItem(MenuItemInfo menuItemInfo) {
        super(menuItemInfo.getText());
        this.addActionListener(menuItemInfo.getActionListener());
        this.setMenuItemProperties();
        String string = menuItemInfo.getPropertyName();
        if (string != null) {
            this.setState(this.pref.isTrue(string));
        }
        if (menuItemInfo.getHasMnemonic()) {
            this.setMnemonic(menuItemInfo.getMnemonic());
        }
        this.addObserver();
    }

    private void addObserver() {
        this.pref.addSaveObserver(new Observer(){

            public void update(Observable observable, Object object) {
                TCCheckBoxMenuItem.this.setFontFromPreferences();
            }
        });
    }

    private void setFontFromPreferences() {
        String string = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.menufont", "");
        int n = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.menufontsize", 10);
        this.setFont(new Font(string, 0, n));
        this.revalidate();
        this.repaint();
    }

    private void setMenuItemProperties() {
        this.setFontFromPreferences();
        this.setForeground(Color.white);
        this.setBackground(Common.MENU_COLOR);
        this.setBorder(new BevelBorder(0));
    }
}

