/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.main;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.HeartbeatListener;
import com.topcoder.netCommon.contestantMessages.response.data.LeaderboardItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FaderPanel
extends JPanel
implements HeartbeatListener {
    private JLabel round = null;
    private JLabel room = null;
    private JLabel user = null;
    private JLabel seed = null;
    private JLabel score = null;
    private Contestant model;
    private List rooms = new LinkedList();
    private Iterator iterator = this.rooms.iterator();
    private boolean everyOtherSecond = false;
    private boolean enabled = false;

    public FaderPanel(Contestant contestant) {
        super(new GridBagLayout());
        this.model = contestant;
        this.setOpaque(false);
        this.round = new JLabel("");
        this.room = new JLabel("");
        this.user = new JLabel("");
        this.seed = new JLabel("");
        this.score = new JLabel("");
        this.round.setForeground(Common.STATUS_COLOR);
        this.round.setToolTipText("Round");
        this.room.setToolTipText("Room");
        this.user.setToolTipText("Coder handle.");
        this.seed.setToolTipText("Room seed.");
        this.score.setToolTipText("Current points accumulated.");
        this.create();
        this.start();
        LocalPreferences.getInstance().addSaveObserver(new Observer(){

            public void update(Observable observable, Object object) {
                FaderPanel.this.setEnabled();
            }
        });
        this.setEnabled();
    }

    private void setEnabled() {
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        boolean bl = this.enabled = !localPreferences.getBoolean("com.topcoder.client.contestApplet.panels.main.FaderPanel.enabled", false);
        if (!this.enabled) {
            this.clear();
        }
    }

    public void start() {
        this.model.addHeartbeatListener(this);
    }

    public void stop() {
        this.model.removeHeartbeatListener(this);
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setMinimumSize(new Dimension(125, 20));
        jPanel.setPreferredSize(new Dimension(125, 20));
        jPanel.add(this.round);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setMinimumSize(new Dimension(50, 20));
        jPanel2.setPreferredSize(new Dimension(50, 20));
        jPanel2.add(this.room);
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setMinimumSize(new Dimension(85, 20));
        jPanel3.setPreferredSize(new Dimension(85, 20));
        jPanel3.add(this.user);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setMinimumSize(new Dimension(15, 20));
        jPanel4.setPreferredSize(new Dimension(15, 20));
        jPanel4.add(this.seed);
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setMinimumSize(new Dimension(45, 20));
        jPanel5.setPreferredSize(new Dimension(45, 20));
        jPanel5.add(this.score);
        Common.insertInPanel(jPanel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(jPanel2, this, gridBagConstraints, 1, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(jPanel3, this, gridBagConstraints, 2, 0, 1, 1, 1.0, 0.1);
        Common.insertInPanel(jPanel4, this, gridBagConstraints, 3, 0, 1, 1, 1.0, 0.1);
        Common.insertInPanel(jPanel5, this, gridBagConstraints, 4, 0, 1, 1, 0.1, 0.1);
    }

    private void refreshIterator() {
        this.rooms.clear();
        RoundModel[] roundModelArray = this.model.getActiveRounds();
        for (int i = 0; i < roundModelArray.length; ++i) {
            if (!roundModelArray[i].hasCoderRooms()) continue;
            this.rooms.addAll(Arrays.asList(roundModelArray[i].getCoderRooms()));
        }
        this.iterator = this.rooms.iterator();
    }

    private RoomModel getNextRoom() {
        if (!this.iterator.hasNext()) {
            this.refreshIterator();
            if (!this.iterator.hasNext()) {
                return null;
            }
        }
        return (RoomModel)this.iterator.next();
    }

    public void tick() {
        boolean bl = this.everyOtherSecond = !this.everyOtherSecond;
        if (!this.enabled || this.everyOtherSecond) {
            return;
        }
        this.updateColors(Color.black, Color.black, 0);
        RoomModel roomModel = this.getNextRoom();
        if (roomModel != null && roomModel.hasLeader()) {
            LeaderboardItem leaderboardItem = roomModel.getLeader();
            this.updateDisplay(this.getRoundLabel(roomModel.getRoundModel()), this.getRoomLabel(roomModel), leaderboardItem.getUserName(), leaderboardItem.getSeed(), leaderboardItem.getPoints(), leaderboardItem.getUserRating(), "");
            this.repaint();
        }
    }

    private String getRoomLabel(RoomModel roomModel) {
        return roomModel.getName();
    }

    private String getRoundLabel(RoundModel roundModel) {
        return roundModel.getDisplayName() + ":";
    }

    public void clear() {
        this.round.setText("");
        this.room.setText("");
        this.user.setText("");
        this.user.setIcon(null);
        this.seed.setText("");
        this.score.setText("");
    }

    private void updateDisplay(String string, String string2, String string3, int n, double d, int n2, String string4) {
        this.round.setText(string);
        this.room.setText(string2);
        this.user.setText(string3);
        this.seed.setText(String.valueOf(n));
        this.score.setText(Common.formatScore(d));
        this.updateColors(Common.getRankColor(n2), Color.white, n2);
    }

    private void updateColors(Color color, Color color2, int n) {
        this.room.setForeground(color2);
        this.user.setForeground(color);
        this.user.setIcon(Common.getRankIcon(n));
        this.seed.setForeground(color2);
        this.score.setForeground(color2);
    }
}

