/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.main;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.panels.main.TCMenu;
import com.topcoder.client.contestApplet.panels.main.TCMenuItem;
import com.topcoder.client.contestApplet.rooms.RoomManager;
import com.topcoder.client.contestApplet.uilogic.frames.DivSummaryFrame;
import com.topcoder.client.contestApplet.uilogic.frames.RoundScheduleFrame;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.contestant.view.RoomListListener;
import com.topcoder.client.contestant.view.RoundView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JMenuItem;

public class ActiveRoundsMenu
extends TCMenu
implements RoundView {
    private ContestApplet contestApplet;
    private Contestant contestantModel;
    private RoomManager roomManager;
    private boolean gotRounds = false;
    private static final String NO_ACTIVE_CONTESTS = "No Active Contests";
    private JMenuItem dummy = new TCMenuItem("No Active Contests");
    private boolean enabled = true;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (!(jMenuItem instanceof SubMenu)) continue;
            ((SubMenu)jMenuItem).setPanelEnabled(bl);
        }
    }

    public ActiveRoundsMenu(String string, int n, int n2, char c, ContestApplet contestApplet) {
        super(string, n, n2, c);
        this.contestApplet = contestApplet;
        this.contestantModel = contestApplet.getModel();
        this.roomManager = contestApplet.getRoomManager();
        this.dummy.setEnabled(false);
        this.add(this.dummy);
    }

    public void clearRoundList() {
        this.removeAll();
        this.gotRounds = false;
        this.add(this.dummy);
    }

    public void updateActiveRoundList(Contestant contestant) {
        this.clearRoundList();
        RoundModel[] roundModelArray = contestant.getActiveRounds();
        Arrays.sort(roundModelArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((RoundModel)object).getRoundType().getRatingType() - ((RoundModel)object2).getRoundType().getRatingType();
                if (n != 0) {
                    return n;
                }
                return ((RoundModel)object).getRoundID().compareTo(((RoundModel)object2).getRoundID());
            }
        });
        int n = -1;
        for (int i = 0; i < roundModelArray.length; ++i) {
            if (n == -1) {
                n = roundModelArray[i].getRoundType().getRatingType();
            } else if (n != roundModelArray[i].getRoundType().getRatingType()) {
                this.addSeparator();
                n = roundModelArray[i].getRoundType().getRatingType();
            }
            this.newActiveRound(roundModelArray[i]);
        }
    }

    private void newActiveRound(RoundModel roundModel) {
        if (!this.gotRounds) {
            this.removeAll();
            this.gotRounds = true;
        }
        this.add(new SubMenu(roundModel));
    }

    private final class SubMenu
    extends TCMenu
    implements PhaseListener,
    RoomListListener {
        private boolean enabled;
        private final RoundModel roundModel;
        private TCMenuItem statementItem;
        private final TCMenuItem registerEnterItem;
        private final TCMenuItem enterItem;
        private final TCMenuItem registrantsItem;
        private final TCMenuItem scheduleItem;
        private final TCMenuItem adminRoomItem;
        private final TCMenuItem myTeamInfoItem;
        private final TCMenuItem teamsInfoItem;
        private final TCMenu coderRoomsMenu;
        private boolean divOpen;
        private DivSummaryFrame divFrame;
        private final TCMenuItem divSummaryItem;
        private final ActionListener moveRoomActionListener;

        public void setPanelEnabled(boolean bl) {
            this.enabled = bl;
            if (this.divFrame != null) {
                this.divFrame.setPanelEnabled(bl);
            }
        }

        SubMenu(final RoundModel roundModel) {
            super(roundModel.getDisplayName());
            this.enabled = true;
            this.statementItem = null;
            this.registerEnterItem = new TCMenuItem("Register", 'g');
            this.enterItem = new TCMenuItem("Enter", 'n');
            this.registrantsItem = new TCMenuItem("Registrants", 'n');
            this.scheduleItem = new TCMenuItem("Schedule", 's');
            this.adminRoomItem = new TCMenuItem("Admin Room", 'a');
            this.myTeamInfoItem = new TCMenuItem("My Team Info", 'm');
            this.teamsInfoItem = new TCMenuItem("Teams Info", 't');
            this.coderRoomsMenu = new TCMenu("Rooms", 'r');
            this.divOpen = false;
            this.divFrame = null;
            this.divSummaryItem = new TCMenuItem("Division Summary", 'd');
            this.moveRoomActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TCMenuItem tCMenuItem = (TCMenuItem)actionEvent.getSource();
                    if (!tCMenuItem.hasUserData()) {
                        throw new IllegalStateException("Missing room model in menu item: " + tCMenuItem);
                    }
                    RoomModel roomModel = (RoomModel)tCMenuItem.getUserData();
                    ActiveRoundsMenu.this.roomManager.loadRoom(roomModel.getType(), roomModel.getRoomID(), 2);
                }
            };
            this.roundModel = roundModel;
            if (roundModel.getRoundType().isLongRound()) {
                this.statementItem = new TCMenuItem("Statement", 's');
                this.statementItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SubMenu.this.statementEvent();
                    }
                });
            }
            this.registerEnterItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SubMenu.this.registerEvent();
                }
            });
            this.enterItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SubMenu.this.enterEvent();
                }
            });
            this.registrantsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActiveRoundsMenu.this.contestantModel.getRequester().requestRegisterUsers(roundModel.getRoundID());
                }
            });
            this.scheduleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new RoundScheduleFrame(ActiveRoundsMenu.this.contestApplet, roundModel, ActiveRoundsMenu.this.contestApplet.getCurrentFrame()).show();
                }
            });
            if (!roundModel.getRoundType().hasDivisions()) {
                this.divSummaryItem.setText("Summary");
            }
            this.divSummaryItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SubMenu.this.divFrame == null || !SubMenu.this.divFrame.isVisible()) {
                        SubMenu.this.divFrame = new DivSummaryFrame(roundModel, ActiveRoundsMenu.this.contestApplet);
                        SubMenu.this.divFrame.showFrame(true);
                    } else {
                        SubMenu.this.divFrame.requestFocus();
                    }
                }
            });
            this.adminRoomItem.addActionListener(this.moveRoomActionListener);
            if (this.statementItem != null) {
                this.add(this.statementItem);
            }
            this.add(this.registerEnterItem);
            this.add(this.enterItem);
            this.add(this.registrantsItem);
            if (roundModel.getRoundTypeId() != -2 && roundModel.getRoundTypeId() != -1) {
                this.add(this.scheduleItem);
            }
            boolean bl = ActiveRoundsMenu.this.contestantModel.getUserInfo().isAdmin();
            this.add(this.divSummaryItem);
            boolean bl2 = ActiveRoundsMenu.this.contestantModel.getUserInfo().isWeakestLinkParticipant();
            if (bl2) {
                this.myTeamInfoItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = (int)roundModel.getRoundID().longValue();
                        ActiveRoundsMenu.this.contestantModel.getRequester().requestWLMyTeamInfo(n);
                    }
                });
                this.add(this.myTeamInfoItem);
            }
            if (roundModel.getRoundTypeId() == 11) {
                this.teamsInfoItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = (int)roundModel.getRoundID().longValue();
                        ActiveRoundsMenu.this.contestantModel.getRequester().requestWLTeamsInfo(n);
                    }
                });
                this.add(this.teamsInfoItem);
            }
            roundModel.addPhaseListener(this);
            roundModel.addRoomListListener(this);
            this.reset();
            this.roomListEvent(roundModel);
        }

        private void reset() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = ActiveRoundsMenu.this.contestantModel.getUserInfo().isAdmin();
            int n = this.roundModel.getPhase();
            this.removeDialogs(n);
            switch (n) {
                case 2: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                case 0: 
                case 1: {
                    break;
                }
                case 3: 
                case 4: {
                    bl2 = true;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    bl4 = this.roundModel.canDisplaySummary();
                    bl3 = this.roundModel.hasCoderRooms() || bl5 && this.roundModel.hasAdminRoom();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid phase: " + this.roundModel.getPhase());
                }
            }
            if (bl5) {
                bl4 = true;
            }
            if (this.roundModel.getRoundType().isLongRound()) {
                bl = bl2;
                this.statementItem.setEnabled(n >= 2 && n <= 9);
            }
            if (this.roundModel.getRoundTypeId() == -2) {
                bl = false;
            }
            if (this.roundModel.getRoundTypeId() == -1) {
                bl = false;
            }
            this.registerEnterItem.setEnabled(bl);
            this.enterItem.setEnabled(bl3);
            this.coderRoomsMenu.setEnabled(bl3);
            this.divSummaryItem.setEnabled(bl3 && bl4);
            this.revalidate();
            this.repaint();
        }

        private void removeDialogs(int n) {
            switch (n) {
                case 11: {
                    ActiveRoundsMenu.this.contestApplet.disposeVotingFrame();
                    break;
                }
                case 9: {
                    ActiveRoundsMenu.this.contestApplet.disposeTieBreakVotingFrame();
                }
            }
        }

        private void registerEvent() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.roundModel.getRoundType().isLongRound();
            switch (this.roundModel.getPhase()) {
                case 0: 
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                case 3: 
                case 4: {
                    bl2 = true;
                }
                default: {
                    if (bl3 && bl2) break;
                    throw new IllegalArgumentException("Invalid phase: " + this.roundModel.getPhase());
                }
            }
            if (bl3) {
                bl = bl2;
            }
            if (bl) {
                ActiveRoundsMenu.this.contestantModel.getRequester().requestRegisterEventInfo(this.roundModel.getRoundID());
            }
        }

        private void statementEvent() {
            int n = this.roundModel.getPhase();
            if (n < 2 || n > 9) {
                throw new IllegalArgumentException("Invalid phase: " + this.roundModel.getPhase());
            }
            ActiveRoundsMenu.this.contestApplet.showProblemStatement(this.roundModel.getProblems(this.roundModel.getCoderRooms()[0].getDivisionID())[0]);
        }

        private void enterEvent() {
            switch (this.roundModel.getPhase()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ActiveRoundsMenu.this.roomManager.loadRoom(7, this.roundModel.getRoundID(), 2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid phase: " + this.roundModel.getPhase());
                }
            }
        }

        public void enableRound(RoundModel roundModel) {
            this.registerEnterItem.setEnabled(this.roundModel.getMenuStatus());
            this.enterItem.setEnabled(this.roundModel.getMenuStatus());
            this.reset();
        }

        public void phaseEvent(int n, RoundModel roundModel) {
            this.reset();
        }

        public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
        }

        public void roomListEvent(RoundModel roundModel) {
            Object[] objectArray;
            this.remove(this.adminRoomItem);
            this.remove(this.coderRoomsMenu);
            if (ActiveRoundsMenu.this.contestantModel.getUserInfo().isAdmin() && roundModel.hasAdminRoom()) {
                objectArray = roundModel.getAdminRoom();
                this.adminRoomItem.setUserData(objectArray);
                this.add(this.adminRoomItem);
            }
            if (roundModel.hasCoderRooms()) {
                objectArray = roundModel.getCoderRooms();
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = objectArray[i].getName();
                }
                this.coderRoomsMenu.removeAll();
                this.coderRoomsMenu.buildIndexedCascadingMenu(stringArray, objectArray, this.moveRoomActionListener);
                this.add(this.coderRoomsMenu);
            }
            this.reset();
        }
    }
}

