/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.panels.AdditionalFontsConfigurationPanel;
import com.topcoder.client.contestApplet.panels.ChallengeConfigurationPanel;
import com.topcoder.client.contestApplet.panels.ChatConfigurationPanel;
import com.topcoder.client.contestApplet.panels.HighlightConfigurationPanel;
import com.topcoder.client.contestApplet.panels.ProblemConfigurationPanel;
import com.topcoder.client.contestApplet.panels.StdEdConfigurationPanel;
import com.topcoder.client.contestApplet.panels.SummaryConfigurationPanel;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public final class TabbedAppletConfigurationPanel
extends JPanel {
    private JTabbedPane tabbedCfgPane;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private ChatConfigurationPanel chatPanel;
    private StdEdConfigurationPanel stdEdPanel;
    private ProblemConfigurationPanel probPanel;
    private ChallengeConfigurationPanel chalPanel;
    private SummaryConfigurationPanel summPanel;
    private AdditionalFontsConfigurationPanel menuPanel;
    private HighlightConfigurationPanel highlightPanel;
    boolean changesPending = false;
    private JDialog parent;

    public TabbedAppletConfigurationPanel(JDialog jDialog) {
        super(false);
        this.parent = jDialog;
        this.setBackground(Common.BG_COLOR);
        this.tabbedCfgPane = new JTabbedPane();
        this.chatPanel = new ChatConfigurationPanel(this.parent);
        this.stdEdPanel = new StdEdConfigurationPanel(this.parent);
        this.probPanel = new ProblemConfigurationPanel(this.parent);
        this.chalPanel = new ChallengeConfigurationPanel(this.parent);
        this.summPanel = new SummaryConfigurationPanel(this.parent);
        this.menuPanel = new AdditionalFontsConfigurationPanel();
        this.highlightPanel = new HighlightConfigurationPanel(this.parent);
        this.tabbedCfgPane.addTab("Chat", null, new JScrollPane(this.chatPanel), "Chat colors.");
        this.tabbedCfgPane.addTab("Editors", null, new JScrollPane(this.stdEdPanel), "Standard Editor.");
        this.tabbedCfgPane.addTab("Problems / Messages", null, new JScrollPane(this.probPanel), "Summary, info, and so forth.");
        this.tabbedCfgPane.addTab("Challenge", null, new JScrollPane(this.chalPanel), "Source view during challenges.");
        this.tabbedCfgPane.addTab("Room Summary", null, new JScrollPane(this.summPanel), "Room summary.");
        this.tabbedCfgPane.addTab("Additional Fonts", null, new JScrollPane(this.menuPanel), "Menu / Summary font.");
        this.tabbedCfgPane.addTab("Syntax Highlighting", null, new JScrollPane(this.highlightPanel), "Highlighting font.");
        this.tabbedCfgPane.setSelectedIndex(0);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabbedCfgPane);
    }

    public void saveAll() {
        this.chatPanel.saveChatPreferences();
        this.stdEdPanel.saveStdEdPreferences();
        this.probPanel.saveProblemPreferences();
        this.chalPanel.saveChallengePreferences();
        this.summPanel.savePreferences();
        this.menuPanel.saveMenuPreferences();
        this.highlightPanel.saveHighlightPreferences();
        Frame[] frameArray = Frame.getFrames();
        for (int i = frameArray.length - 1; i >= 0; --i) {
            frameArray[i].repaint();
        }
    }

    public boolean isChangesPending() {
        return this.summPanel.areChangesPending() || this.chalPanel.areChangesPending() || this.chatPanel.areChangesPending() || this.stdEdPanel.areChangesPending() || this.probPanel.areChangesPending() || this.menuPanel.areChangesPending() || this.highlightPanel.areChangesPending();
    }
}

