/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.frames.AppletPreferencesFrame;
import com.topcoder.client.contestApplet.frames.MainFrame;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestApplet.widgets.MyTitledBorder;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class StdEdConfigurationPanel
extends JPanel {
    private JDialog parent;
    private JTextPane stdPreview;
    private String stdPreviewStr = "10 BEEP\n20 GOSUB 40\n30 GOTO 10\n40 PRINT \"WHEE\"\n50 RETURN\n";
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private JComboBox stdFonts;
    private JComboBox stdFontSizes;
    private JRadioButton javaRadioButton;
    private JRadioButton cplusplusRadioButton;
    private JRadioButton csharpRadioButton;
    private JRadioButton vbRadioButton;
    private JRadioButton pythonRadioButton;
    private JComboBox stdCommentsStyle;
    private JComboBox stdLiteralsStyle;
    private JComboBox stdKeywordsStyle;
    private JComboBox stdDefaultStyle;
    private JRadioButton syntaxYesButton;
    private JRadioButton syntaxNoButton;
    private JTextField tabSize;
    private HashMap map = new HashMap();
    private HashMap keys = new HashMap();
    int r;
    private boolean changesPending = false;
    private boolean needsNewWindow = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private AppletPreferencesFrame parentFrame;

    public StdEdConfigurationPanel(JDialog jDialog) {
        super(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.parent = jDialog;
        this.parentFrame = (AppletPreferencesFrame)this.parent;
        this.setBackground(Common.BG_COLOR);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1), false);
        jPanel2.setBackground(Common.BG_COLOR);
        jPanel3.setBackground(Common.BG_COLOR);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        jPanel4.setBackground(Common.BG_COLOR);
        JPanel jPanel5 = new JPanel(new BorderLayout(), false);
        jPanel5.setBackground(Common.BG_COLOR);
        RoundBorder roundBorder = new RoundBorder(Common.LIGHT_GREY, 5, true);
        MyTitledBorder myTitledBorder = new MyTitledBorder(roundBorder, "Standard Preview", 1, 1);
        myTitledBorder.setTitleColor(Common.PT_COLOR);
        jPanel5.setBorder(myTitledBorder);
        this.stdPreview = new JTextPane();
        this.stdPreview.setEditable(false);
        jPanel5.add(this.stdPreview);
        jPanel3.add(jPanel5);
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keysave", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keysave")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keycompile", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keycompile")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keytest", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keytest")));
        this.keys.put("com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit", this.createHotKeyTextArea(this.localPref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit")));
        Vector vector = Common.enumerateFonts();
        Object[] objectArray = new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"};
        Object[] objectArray2 = new Object[]{"Normal", "Bold", "Italic", "Bold Italic"};
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createHeaderJLabel("Standard"), jPanel4, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        this.stdFonts = new JComboBox(vector);
        this.stdFontSizes = new JComboBox<Object>(objectArray);
        this.stdFonts.setSelectedItem(this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont"));
        this.stdFontSizes.setSelectedItem(String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize")));
        this.stdFontSizes.setEditable(false);
        this.stdFonts.setEditable(false);
        this.stdFonts.addActionListener(this.handler);
        this.stdFontSizes.addActionListener(this.handler);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Font: "), jPanel4, gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.stdFonts, jPanel4, gridBagConstraints, 1, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Size: "), jPanel4, gridBagConstraints, 2, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.stdFontSizes, jPanel4, gridBagConstraints, 3, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Foreground: "), jPanel4, gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore"), jPanel4, gridBagConstraints, 1, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Background: "), jPanel4, gridBagConstraints, 2, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"), jPanel4, gridBagConstraints, 3, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Selected Text: "), jPanel4, gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt"), jPanel4, gridBagConstraints, 1, 3, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.createJLabel("Selection: "), jPanel4, gridBagConstraints, 2, 3, 1, 1, 0.0, 0.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"), jPanel4, gridBagConstraints, 3, 3, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.createJLabel("Tab Size: "), jPanel4, gridBagConstraints, 0, 4, 1, 1, 0.0, 0.0);
        this.tabSize = new JTextField();
        this.tabSize.setText(String.valueOf(LocalPreferences.getInstance().getTabSize()));
        this.tabSize.setPreferredSize(new Dimension(35, 20));
        Common.insertInPanel(this.tabSize, jPanel4, gridBagConstraints, 1, 4, 3, 1, 0.0, 0.0);
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Default Language: "), jPanel4, gridBagConstraints, 0, 5, 1, 1, 0.0, 0.0);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Common.BG_COLOR);
        ButtonGroup buttonGroup = new ButtonGroup();
        ContestApplet contestApplet = ((MainFrame)((AppletPreferencesFrame)this.parent).getParent()).getContestApplet();
        int n = 5;
        Integer n2 = new Integer(0);
        HashMap hashMap = contestApplet.getModel().getUserInfo().getPreferences();
        n = hashMap.containsKey(n2) ? (Integer)hashMap.get(n2) : 1;
        this.javaRadioButton = new JRadioButton("Java", n == 1);
        this.javaRadioButton.setBackground(Common.BG_COLOR);
        this.javaRadioButton.setForeground(Common.FG_COLOR);
        this.javaRadioButton.setOpaque(false);
        if (CommonData.allowsJava(this.parentFrame.getApplet().getCompanyName())) {
            jPanel6.add(this.javaRadioButton);
            buttonGroup.add(this.javaRadioButton);
        }
        this.cplusplusRadioButton = new JRadioButton("C++", n == 3);
        this.cplusplusRadioButton.setBackground(Common.BG_COLOR);
        this.cplusplusRadioButton.setForeground(Common.FG_COLOR);
        this.cplusplusRadioButton.setOpaque(false);
        if (CommonData.allowsCPP(this.parentFrame.getApplet().getCompanyName())) {
            jPanel6.add(this.cplusplusRadioButton);
            buttonGroup.add(this.cplusplusRadioButton);
        }
        this.csharpRadioButton = new JRadioButton("C#", n == 4);
        this.csharpRadioButton.setBackground(Common.BG_COLOR);
        this.csharpRadioButton.setForeground(Common.FG_COLOR);
        this.csharpRadioButton.setOpaque(false);
        if (CommonData.allowsCS(this.parentFrame.getApplet().getCompanyName())) {
            jPanel6.add(this.csharpRadioButton);
            buttonGroup.add(this.csharpRadioButton);
        }
        this.vbRadioButton = new JRadioButton("VB", n == 5);
        this.vbRadioButton.setBackground(Common.BG_COLOR);
        this.vbRadioButton.setForeground(Common.FG_COLOR);
        this.vbRadioButton.setOpaque(false);
        if (CommonData.allowsVB(this.parentFrame.getApplet().getCompanyName())) {
            jPanel6.add(this.vbRadioButton);
            buttonGroup.add(this.vbRadioButton);
        }
        this.pythonRadioButton = new JRadioButton("Python", n == 6);
        this.pythonRadioButton.setBackground(Common.BG_COLOR);
        this.pythonRadioButton.setForeground(Common.FG_COLOR);
        this.pythonRadioButton.setOpaque(false);
        if (CommonData.allowsPython(this.parentFrame.getApplet().getCompanyName())) {
            jPanel6.add(this.pythonRadioButton);
            buttonGroup.add(this.pythonRadioButton);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel6, jPanel4, gridBagConstraints, 1, 5, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.createHeaderJLabel("Hot Keys"), jPanel4, gridBagConstraints, 0, 6, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Find: "), jPanel4, gridBagConstraints, 0, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind"), jPanel4, gridBagConstraints, 1, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Go to: "), jPanel4, gridBagConstraints, 2, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto"), jPanel4, gridBagConstraints, 3, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Undo: "), jPanel4, gridBagConstraints, 0, 8, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo"), jPanel4, gridBagConstraints, 1, 8, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Redo: "), jPanel4, gridBagConstraints, 2, 8, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo"), jPanel4, gridBagConstraints, 3, 8, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Save: "), jPanel4, gridBagConstraints, 0, 9, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.keysave"), jPanel4, gridBagConstraints, 1, 9, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Compile: "), jPanel4, gridBagConstraints, 2, 9, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.keycompile"), jPanel4, gridBagConstraints, 3, 9, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Test: "), jPanel4, gridBagConstraints, 0, 10, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.keytest"), jPanel4, gridBagConstraints, 1, 10, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Submit: "), jPanel4, gridBagConstraints, 2, 10, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel((JComponent)this.keys.get("com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit"), jPanel4, gridBagConstraints, 3, 10, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.createJLabel(""), jPanel4, gridBagConstraints, 0, 11, 1, 1, 1.0, 1.0);
        Common.insertInPanel(jPanel4, jPanel2, gridBagConstraints, 1, 1, 1, 1);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.add(jPanel);
        this.resetPreview();
        this.needsNewWindow = true;
    }

    private JLabel createHeaderJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.PT_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 1, jLabel.getFont().getSize()));
        return jLabel;
    }

    private JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        return jLabel;
    }

    private JTextField createHotKeyTextArea(String string) {
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(100, 20));
        jTextField.setText(string);
        jTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17) {
                    int n = keyEvent.getModifiers();
                    if ((n & ~16) > 0) {
                        StdEdConfigurationPanel.this.changesPending = true;
                        jTextField.setText(StdEdConfigurationPanel.this.modifiersToString(n) + KeyEvent.getKeyText(keyEvent.getKeyCode()));
                        MoveFocus.moveFocus(StdEdConfigurationPanel.this.parent);
                    }
                }
                keyEvent.consume();
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        return jTextField;
    }

    private String modifiersToString(int n) {
        String string = "";
        if ((n & 2) > 0) {
            string = string + "Ctrl+";
        }
        if ((n & 8) > 0) {
            string = string + "Alt+";
        }
        if ((n & 1) > 0) {
            string = string + "Shift+";
        }
        return string;
    }

    private JButton createJButton(Color color) {
        JButton jButton = new JButton();
        jButton.setBackground(color);
        jButton.addActionListener(this.handler);
        jButton.setPreferredSize(new Dimension(35, 20));
        return jButton;
    }

    private JPanel createSyntaxPanel(String string, String string2, JComboBox jComboBox, Object[] objectArray, GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        jPanel.setBackground(Common.BG_COLOR);
        Common.insertInPanel((JButton)this.map.get(string), jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        jComboBox.setSelectedIndex(Integer.parseInt(this.localPref.getProperty(string2, "0")));
        jComboBox.setEditable(false);
        jComboBox.addActionListener(this.handler);
        Common.insertInPanel(jComboBox, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        return jPanel;
    }

    private void resetPreview() {
        this.stdPreview.setText("");
        this.stdPreview.setSelectedTextColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt")).getBackground());
        this.stdPreview.setSelectionColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb")).getBackground());
        try {
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore")).getBackground());
            this.stdPreview.setBackground(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback")).getBackground());
            StyleConstants.setFontFamily(this.attr, (String)this.stdFonts.getSelectedItem());
            StyleConstants.setFontSize(this.attr, Integer.parseInt((String)this.stdFontSizes.getSelectedItem()));
            this.stdPreview.getDocument().insertString(this.stdPreview.getDocument().getLength(), this.stdPreviewStr, this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.needsNewWindow) {
            this.parent.pack();
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public int getLanguage() {
        int n = 1;
        if (this.javaRadioButton.isSelected()) {
            n = 1;
        } else if (this.cplusplusRadioButton.isSelected()) {
            n = 3;
        } else if (this.csharpRadioButton.isSelected()) {
            n = 4;
        } else if (this.vbRadioButton.isSelected()) {
            n = 5;
        } else if (this.pythonRadioButton.isSelected()) {
            n = 6;
        }
        return n;
    }

    public void saveStdEdPreferences() {
        Serializable serializable;
        Object object;
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        Object object2 = this.map.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            serializable = (JButton)this.map.get(object);
            hashMap.put((String)object, serializable.getBackground());
        }
        object2 = this.keys.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            serializable = (JTextField)this.keys.get(object);
            this.localPref.setProperty((String)object, ((JTextComponent)serializable).getText());
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont", (String)this.stdFonts.getSelectedItem());
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize", (String)this.stdFontSizes.getSelectedItem());
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdtabsize", this.tabSize.getText());
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = ((MainFrame)((AppletPreferencesFrame)this.parent).getParent()).getContestApplet();
        ((ContestApplet)object2).getRequester().requestSetLanguage(this.getLanguage());
        object = ((ContestApplet)object2).getModel().getUserInfo().getPreferences();
        serializable = new Integer(0);
        ((HashMap)object).put(serializable, new Integer(this.getLanguage()));
        ((ContestApplet)object2).getModel().getUserInfo().setPreferences((HashMap)object);
        this.changesPending = false;
    }

    private static JRadioButton getSelection(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != buttonGroup.getSelection()) continue;
            return jRadioButton;
        }
        return null;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    StdEdConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                StdEdConfigurationPanel.this.resetPreview();
            } else if (object instanceof JComboBox) {
                StdEdConfigurationPanel.this.changesPending = true;
                StdEdConfigurationPanel.this.resetPreview();
            }
        }
    }
}

