/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ProblemPanel
extends JPanel {
    private ContestApplet ca = null;
    private JComponent problemSelector = null;
    private JLabel phaseStatus = null;
    private JLabel phaseDesc = null;
    private JButton summary = null;
    private CoderRoom coderRoom;
    private boolean enabled = true;

    public ProblemPanel(ContestApplet contestApplet, CoderRoom coderRoom, JComponent jComponent) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.coderRoom = coderRoom;
        this.setOpaque(false);
        this.setBorder(new RoundBorder(Common.PB_COLOR, 5, true));
        this.setMinimumSize(new Dimension(0, 60));
        this.setPreferredSize(new Dimension(0, 60));
        this.problemSelector = jComponent;
        this.create();
        this.setPhase(0);
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.refreshSummaryButton();
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.phaseStatus = new JLabel("");
        this.phaseDesc = new JLabel("");
        this.phaseStatus.setFont(new Font("SansSerif", 0, 10));
        this.phaseStatus.setForeground(Common.THF_COLOR);
        this.phaseDesc.setFont(new Font("SansSerif", 0, 10));
        this.phaseDesc.setForeground(Color.white);
        JLabel jLabel = new JLabel(Common.getImage("dotted_line.gif", this.ca));
        JLabel jLabel2 = new JLabel(Common.getImage("dotted_line.gif", this.ca));
        JComponent jComponent = this.problemSelector;
        this.summary = Common.getImageButton("g_summary_but.gif", this.ca);
        this.summary.setMnemonic('s');
        this.summary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProblemPanel.this.enabled) {
                    ProblemPanel.this.statusWindowEvent(actionEvent);
                }
            }
        });
        jPanel.setBackground(Common.BG_COLOR);
        gridBagConstraints.insets = new Insets(0, 0, -1, 10);
        gridBagConstraints.insets = new Insets(0, 0, -1, 0);
        gridBagConstraints.insets = new Insets(0, 5, -1, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        Common.insertInPanel(jComponent, jPanel, gridBagConstraints, 1, 0, 1, 2, 0.0, 0.1);
        gridBagConstraints.insets = new Insets(0, 10, -1, 5);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 2, 0, 1, 2, 0.0, 0.1);
        Common.insertInPanel(this.summary, jPanel, gridBagConstraints, 3, 0, 1, 2, 0.0, 0.1);
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 4, 0, 1, 2, 0.0, 0.1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        Common.insertInPanel(this.phaseStatus, jPanel, gridBagConstraints, 5, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        Common.insertInPanel(this.phaseDesc, jPanel, gridBagConstraints, 5, 1, 1, 1, 1.0, 0.1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(jPanel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
    }

    public void setPhase(int n) {
        switch (n) {
            case 0: {
                this.phaseStatus.setText("COMPETITION STATUS : COMPETITION INACTIVE");
                this.phaseDesc.setText("The contest is currently not running.");
                break;
            }
            case 2: {
                this.phaseStatus.setText("COMPETITION STATUS : REGISTRATION PHASE");
                this.phaseDesc.setText("Select event registration from the main menu.");
                break;
            }
            case 1: 
            case 3: {
                this.phaseStatus.setText("COMPETITION STATUS : STARTS IN");
                this.phaseDesc.setText("The competition will start at the end of the countdown.");
                break;
            }
            case 4: {
                this.phaseStatus.setText("COMPETITION STATUS : CODING PHASE");
                this.phaseDesc.setText("Select a problem from the problem list.");
                break;
            }
            case 5: {
                this.phaseStatus.setText("COMPETITION STATUS : INTERMISSION");
                this.phaseDesc.setText("Please wait for the challenge phase to start.");
                break;
            }
            case 6: {
                this.phaseStatus.setText("COMPETITION STATUS : CHALLENGE PHASE");
                this.phaseDesc.setText("Please select the status window from the tools menu.");
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.phaseStatus.setText("COMPETITION STATUS : SYSTEM TESTING PHASE");
                this.phaseDesc.setText("Please wait for the system test phase to end.");
                break;
            }
            case 12: {
                this.phaseStatus.setText("MODERATED CHAT STATUS : CHATTING");
                this.phaseDesc.setText("Ask questions with /moderator.");
                break;
            }
            default: {
                System.err.println("Unknown phase (" + n + ").");
            }
        }
        this.refreshSummaryButton();
    }

    private void refreshSummaryButton() {
        boolean bl = this.enabled && this.coderRoom.getRoomModel() != null && this.coderRoom.getRoomModel().getRoundModel().canDisplaySummary();
        this.summary.setEnabled(bl);
        if (bl) {
            this.summary.setIcon(Common.getImage("g_summary_but.gif", this.ca));
        } else {
            this.summary.setIcon(Common.getImage("no_g_summary_but.gif", this.ca));
        }
    }

    private void statusWindowEvent(ActionEvent actionEvent) {
        this.coderRoom.challengeButtonEvent(actionEvent);
    }
}

