/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClearProblemsPanel
extends JDialog
implements ActionListener,
WindowListener {
    JButton clearButton = new JButton("Clear");
    JButton closeButton = new JButton("Close");
    JCheckBox[] chkBoxes;
    ProblemComponentModel[] components;
    private ContestApplet ca;

    public ClearProblemsPanel(JFrame jFrame, ContestApplet contestApplet) {
        super(jFrame, "Clear Problem(s)", true);
        this.ca = contestApplet;
        Common.setLocationRelativeTo((Component)jFrame, this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Container container = this.getContentPane();
        container.setBackground(Common.WPB_COLOR);
        container.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(89, 27);
        this.closeButton.setMaximumSize(dimension);
        this.clearButton.setMaximumSize(dimension);
        JLabel jLabel = new JLabel("Select Problem(s) to Clear: ");
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        RoomModel roomModel = contestApplet.getModel().getCurrentRoom();
        RoundModel roundModel = roomModel.getRoundModel();
        this.components = roundModel.getAssignedComponents(roomModel.getDivisionID());
        this.chkBoxes = new JCheckBox[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.chkBoxes[i] = new JCheckBox("" + this.components[i].getPoints().intValue());
            this.chkBoxes[i].setForeground(Common.FG_COLOR);
            this.chkBoxes[i].setBackground(Common.WPB_COLOR);
            container.add((Component)this.chkBoxes[i], new GridBagConstraints(0, 2 + i, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 25, 0, 0), 0, 0));
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.clearButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 4 + this.components.length, 3, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.windowClosing(new WindowEvent(this, 201));
        } else if (object == this.clearButton) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.components.length; ++i) {
                if (!this.chkBoxes[i].isSelected()) continue;
                arrayList.add(new Long(i));
            }
            Long[] longArray = new Long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                longArray[i] = this.components[((Long)arrayList.get(i)).intValue()].getID();
            }
            this.ca.getRequester().requestClearPracticeProblem(this.ca.getModel().getCurrentRoom().getRoomID(), longArray);
            this.dispose();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

