/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.widgets.MyTitledBorder;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ChatConfigurationPanel
extends JPanel {
    private JDialog parent;
    private JPanel preview = null;
    private JTextPane chatPreview = new JTextPane();
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    Font curFont;
    private HashMap map = new HashMap();
    private JComboBox fonts;
    private JComboBox fontSizes;
    private String lastFont;
    private String lastFontSize;
    private JPanel rest;
    private int r;
    private boolean changesPending = false;
    private boolean needsNewWindow = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();

    public ChatConfigurationPanel(JDialog jDialog) {
        super(new BorderLayout(), false);
        this.parent = jDialog;
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        this.rest = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.setBackground(Common.BG_COLOR);
        jPanel.setBackground(Common.BG_COLOR);
        this.rest.setBackground(Common.BG_COLOR);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        this.fonts = new JComboBox(Common.enumerateFonts());
        this.fontSizes = new JComboBox<Object>(new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"});
        this.fonts.setSelectedItem(this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        this.fontSizes.setSelectedItem(String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize")));
        this.fonts.addActionListener(this.handler);
        this.fontSizes.addActionListener(this.handler);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(this.createJLabel("Font: "), jPanel, gridBagConstraints, 1, 1, 1, 1, 1.0, 1.0);
        Common.insertInPanel(this.fonts, jPanel, gridBagConstraints, 2, 1, 1, 1, 1.0, 1.0);
        Common.insertInPanel(this.createJLabel("Size: "), jPanel, gridBagConstraints, 3, 1, 1, 1, 1.0, 1.0);
        Common.insertInPanel(this.fontSizes, jPanel, gridBagConstraints, 4, 1, 1, 1, 1.0, 1.0);
        this.r = 0;
        Common.insertInPanel(this.createJLabel("Foreground"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel(this.createJLabel("Background"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.systemback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generalback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.mefore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.mefore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.meback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.meback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback")));
        this.map.put("com.topcoder.client.contestApplet.panels.ChatPanel.handleback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback")));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore")));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack")));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore")));
        this.map.put("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack", this.createJButton(LocalPreferences.getInstance().getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack")));
        ++this.r;
        Common.insertInPanel(this.createJLabel("System"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Emphasis System"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("General"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("General to You"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Quote Thyself"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.mefore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.meback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Whisper"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Whisper to You"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Moderated Chat Question"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Moderated Chat Speaker"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore"), this.rest, gridBagConstraints, 2, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Handle Background"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.handleback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Chat Panel Background"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Find Background"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        ++this.r;
        Common.insertInPanel(this.createJLabel("Find Highlight"), this.rest, gridBagConstraints, 1, this.r, 1, 1, 1.0, 1.0);
        Common.insertInPanel((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight"), this.rest, gridBagConstraints, 3, this.r, 1, 1, 1.0, 1.0);
        this.preview = new JPanel();
        this.preview.setBackground(Common.BG_COLOR);
        this.preview.setForeground(Common.FG_COLOR);
        RoundBorder roundBorder = new RoundBorder(Common.LIGHT_GREY, 5, true);
        MyTitledBorder myTitledBorder = new MyTitledBorder(roundBorder, "Preview", 1, 1);
        myTitledBorder.setTitleColor(Common.PT_COLOR);
        this.preview.setBorder(myTitledBorder);
        this.chatPreview = new JTextPane();
        this.preview.add(this.chatPreview);
        Common.insertInPanel(this.preview, this.rest, gridBagConstraints, 4, 0, 1, this.r + 1, 1.0, 1.0);
        this.resetPreview();
        this.add((Component)jPanel, "North");
        this.add((Component)this.rest, "Center");
        this.needsNewWindow = true;
    }

    private JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        return jLabel;
    }

    private JButton createJButton(Color color) {
        JButton jButton = new JButton();
        jButton.setBackground(color);
        jButton.addActionListener(this.handler);
        return jButton;
    }

    private void resetPreview() {
        this.chatPreview.setEditable(false);
        this.chatPreview.setText("");
        this.chatPreview.setBackground(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback")).getBackground());
        this.lastFont = (String)this.fonts.getSelectedItem();
        this.lastFontSize = (String)this.fontSizes.getSelectedItem();
        try {
            StyleConstants.setFontFamily(this.attr, (String)this.fonts.getSelectedItem());
            StyleConstants.setFontSize(this.attr, Integer.parseInt((String)this.fontSizes.getSelectedItem()));
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.systemback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "System> Pick a readable font.\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback")).getBackground());
            StyleConstants.setItalic(this.attr, true);
            StyleConstants.setBold(this.attr, true);
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "System> Or you'll be sorry!\n", this.attr);
            StyleConstants.setForeground(this.attr, Color.yellow);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")).getBackground());
            StyleConstants.setItalic(this.attr, false);
            StyleConstants.setBold(this.attr, false);
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "Pops> ", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "a general message\n", this.attr);
            StyleConstants.setForeground(this.attr, Color.yellow);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "Pops> ", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "you: a general message to you\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.mefore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.meback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "**you are quoting yourself\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "You whisper to AdamSelene: Hello.\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "AdamSelene whispers to you: Hello!\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "Moderated chat question?\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "A moderated chat answer!\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "Text you ", this.attr);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "search", this.attr);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "ed for!\n", this.attr);
            StyleConstants.setForeground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")).getBackground());
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "Other ", this.attr);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), "search", this.attr);
            StyleConstants.setBackground(this.attr, ((JButton)this.map.get("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")).getBackground());
            this.chatPreview.getDocument().insertString(this.chatPreview.getDocument().getLength(), " matches when using\nthe highlight option!\n", this.attr);
            if (this.needsNewWindow) {
                this.parent.pack();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void saveChatPreferences() {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JButton jButton = (JButton)this.map.get(string);
            hashMap.put(string, jButton.getBackground());
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont", (String)this.fonts.getSelectedItem());
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize", (String)this.fontSizes.getSelectedItem());
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    ChatConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                ChatConfigurationPanel.this.resetPreview();
            } else if (!(!(object instanceof JComboBox) || ((String)ChatConfigurationPanel.this.fonts.getSelectedItem()).equals(ChatConfigurationPanel.this.lastFont) && ((String)ChatConfigurationPanel.this.fontSizes.getSelectedItem()).equals(ChatConfigurationPanel.this.lastFontSize))) {
                ChatConfigurationPanel.this.changesPending = true;
                ChatConfigurationPanel.this.resetPreview();
            }
        }
    }
}

