/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.HyperLinkLoader;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.panels.coding.CodingTimerPanel;
import com.topcoder.client.contestApplet.panels.coding.TeamProblemInfoPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class TeamProblemFrame
extends JFrame {
    private ContestApplet parentFrame = null;
    private CodingTimerPanel timerPanel = null;
    private TeamProblemInfoPanel problemPanel = null;
    private JEditorPane problemPane = new JEditorPane("text/html", "");
    private JScrollPane problemScroll = null;
    private JButton assignButton;
    private LocalPreferences pref = LocalPreferences.getInstance();
    private static final String FRAMELOCATION = "com.topcoder.jmaContestApplet.frames.codingframe.location";
    private static final String FRAMESIZE = "com.topcoder.jmaContestApplet.frames.codingframe.size";
    private ProblemModel problem;
    private ProblemComponentModel component;

    public TeamProblemFrame(ContestApplet contestApplet) {
        super("TopCoder Competition Arena - Team Problem");
        this.parentFrame = contestApplet;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TeamProblemFrame.this.closeTeamProblemWindow();
            }
        });
        this.problemPane.addHyperlinkListener(new HyperLinkLoader(contestApplet.getAppletContext()));
    }

    public void clear() {
        this.problemPane.setText("");
        this.problemScroll.getVerticalScrollBar().setValue(0);
    }

    public void showFrame(boolean bl) {
        this.show();
    }

    public TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void updateProblemInfo(ProblemModel problemModel) {
        this.problem = problemModel;
        this.updateAll();
    }

    public void create() {
        Serializable serializable;
        TeamProblemInfoPanel teamProblemInfoPanel;
        CodingTimerPanel codingTimerPanel;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.timerPanel = codingTimerPanel = new CodingTimerPanel(this.parentFrame);
        this.problemPanel = teamProblemInfoPanel = new TeamProblemInfoPanel(this.parentFrame);
        JPanel jPanel = Common.createMessagePanel("Problem Statement", this.problemPane, 0, 0, Common.BG_COLOR);
        this.problemPane.setFont(new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize")));
        this.problemPane.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        this.problemPane.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        this.problemScroll = (JScrollPane)jPanel.getComponent(0);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 15, 5, 5);
        Common.insertInPanel(teamProblemInfoPanel, this.getContentPane(), gridBagConstraints, 0, 0, 2, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        Common.insertInPanel(codingTimerPanel, this.getContentPane(), gridBagConstraints, 2, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        Common.insertInPanel(new ContestSponsorPanel(this.parentFrame, CommonData.getSponsorCodingFrameImageAddr(this.parentFrame.getSponsorName(), null)), this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 2, 3, 1, 0.1, 0.1);
        this.pack();
        Point point = this.pref.getLocation(FRAMELOCATION);
        if (point == null) {
            serializable = this.parentFrame.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.setLocation(point);
        serializable = this.pref.getSize(FRAMESIZE);
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        this.setSize(Common.adjustWindowSize(point, (Dimension)serializable));
    }

    private void updateAll() {
        ProblemRenderer problemRenderer = new ProblemRenderer(this.problem.getProblem());
        problemRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string = "";
        try {
            string = problemRenderer.toHTML((Language)JavaLanguage.JAVA_LANGUAGE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = this.problem.getName();
        String string3 = "";
        DataType[] dataTypeArray = new DataType[]{};
        DataType dataType = new DataType("int");
        this.problemPane.setText(string);
        this.problemPane.setCaretPosition(0);
        this.problemPanel.updateProblemInfo(this.problem, JavaLanguage.JAVA_LANGUAGE.getId());
    }

    private void closeTeamProblemWindow() {
        this.pref.setLocation(FRAMELOCATION, this.getLocation());
        this.pref.setSize(FRAMESIZE, this.getSize());
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

