/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLDocument;

public final class StatementViewer
extends JFrame {
    private static final String FRAMELOCATION = "com.topcoder.jmaContestApplet.frames.statementViewer.location";
    private static final String FRAMESIZE = "com.topcoder.jmaContestApplet.frames.statementViewer.size";
    private final JEditorPane problemPane = new JEditorPane("text/html", "");
    private final LocalPreferences pref = LocalPreferences.getInstance();
    private final ContestApplet contestApplet;
    private boolean enabled = true;
    private JScrollPane problemScroll;
    private JButton registerButton = null;
    private ProblemModel problem;
    private ProblemModel.Listener problemListener;
    private PhaseListener phaseListener;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.registerButton.setEnabled(this.enabled && this.isRegistrationOpen());
    }

    private boolean isRegistrationOpen() {
        return false;
    }

    public StatementViewer(ContestApplet contestApplet) {
        super("Statement Viewer");
        this.contestApplet = contestApplet;
        this.problemListener = new ProblemModel.Listener(){

            public void updateProblemModelReadOnly(ProblemModel problemModel) {
            }

            public void updateProblemModel(ProblemModel problemModel) {
                StatementViewer.this.refreshView();
            }
        };
        this.phaseListener = new PhaseListener(){

            public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
            }

            public void phaseEvent(int n, RoundModel roundModel) {
                StatementViewer.this.updateRegisterButton();
            }

            public void enableRound(RoundModel roundModel) {
            }
        };
        this.getContentPane().setBackground(Common.BG_COLOR);
        this.create();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatementViewer.this.closeWindow();
            }
        });
    }

    public void clear() {
        this.problemPane.setText("");
        this.problemScroll.getVerticalScrollBar().setValue(0);
    }

    public void setProblemStatement(ProblemModel problemModel) {
        if (this.problem != problemModel) {
            this.clear();
            this.removeListeners();
            this.problem = problemModel;
            this.updateTitle();
            this.addListeners();
        }
        this.updateView();
        this.updateRegisterButton();
    }

    private void updateTitle() {
        this.setTitle(this.problem.getName() + " statement " + (this.problem.hasProblemStatement() ? "" : "(loading...)"));
    }

    private void addListeners() {
        this.problem.addListener(this.problemListener);
        this.problem.getRound().addPhaseListener(this.phaseListener);
    }

    private void removeListeners() {
        if (this.problem != null) {
            this.problem.getRound().removePhaseListener(this.phaseListener);
            this.problem.removeListener(this.problemListener);
            this.problem = null;
        }
    }

    private void updateRegisterButton() {
        int n = this.problem.getRound().getPhase();
        this.registerButton.setEnabled(n >= 2 && n <= 4);
    }

    private void updateView() {
        if (!this.problem.hasProblemStatement()) {
            this.contestApplet.getRequester().requestOpenProblemForReading(this.problem.getRound().getRoundID(), this.problem.getProblemID());
            return;
        }
        this.refreshView();
    }

    private void refreshView() {
        if (!this.problem.hasProblemStatement()) {
            throw new IllegalStateException("No server object for problem");
        }
        this.updateTitle();
        ProblemRenderer problemRenderer = new ProblemRenderer(this.problem.getProblem());
        problemRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string = "";
        try {
            string = problemRenderer.toHTML(this.getLanguage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.problemPane.setText(string);
        this.problemPane.setCaretPosition(0);
    }

    private Language getLanguage() {
        Integer n = new Integer(0);
        HashMap hashMap = this.contestApplet.getModel().getUserInfo().getPreferences();
        if (hashMap.containsKey(n)) {
            if ((Integer)hashMap.get(n) == 0) {
                return JavaLanguage.JAVA_LANGUAGE;
            }
            return BaseLanguage.getLanguage((int)((Integer)hashMap.get(n)));
        }
        return JavaLanguage.JAVA_LANGUAGE;
    }

    private void create() {
        Serializable serializable;
        JPanel jPanel = Common.createMessagePanel("Problem Statement", this.problemPane, 0, 0, Common.BG_COLOR);
        this.problemScroll = (JScrollPane)jPanel.getComponent(0);
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize") + "pt;}");
        this.problemPane.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore"));
        this.problemPane.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback"));
        this.problemPane.setEditable(false);
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        Point point = this.pref.getLocation(FRAMELOCATION);
        if (point == null) {
            serializable = this.contestApplet.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.setLocation(point);
        serializable = this.pref.getSize(FRAMESIZE);
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        serializable = Common.adjustWindowSize(point, (Dimension)serializable);
        this.setSize((Dimension)serializable);
    }

    private JPanel createButtonPanel() {
        this.registerButton = new JButton("Register");
        this.registerButton.setForeground(Common.FG_COLOR);
        this.registerButton.setBackground(Color.black);
        this.registerButton.setFocusPainted(false);
        this.registerButton.setToolTipText("Register on this contest");
        this.registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatementViewer.this.registerButtonEvent();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.registerButton);
        return jPanel;
    }

    private void registerButtonEvent() {
        this.contestApplet.getRequester().requestRegisterEventInfo(this.problem.getRound().getRoundID());
    }

    private void closeWindow() {
        this.removeListeners();
        this.clear();
        if (!this.enabled) {
            return;
        }
        this.pref.setLocation(FRAMELOCATION, this.getLocation());
        this.pref.setSize(FRAMESIZE, this.getSize());
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

