/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.Standard.StandardEditorPanel;
import com.topcoder.client.contestApplet.frames.SourceFindDialog;
import com.topcoder.client.contestApplet.panels.table.BaseAlgoSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.ChallengeTablePanel;
import com.topcoder.client.contestApplet.panels.table.DivSummaryTablePanel;
import com.topcoder.client.contestApplet.widgets.MouseLessEditorPane;
import com.topcoder.client.contestApplet.widgets.MouseLessTextArea;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentChallengeData;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.HighlightedOutput;
import com.topcoder.util.syntaxhighlighter.HtmlOutput;
import com.topcoder.util.syntaxhighlighter.SyntaxHighlighter;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.html.HTMLDocument;

public final class SourceViewer
extends JFrame
implements Observer {
    private static final String FRAMELOCATION = "com.topcoder.jmaContestApplet.frames.sourceViewer.location";
    private static final String FRAMESIZE = "com.topcoder.jmaContestApplet.frames.sourceViewer.size";
    private static final String DIVIDERLOC = "com.topcoder.jmaContestApplet.frames.sourceViewer.dividerloc";
    private final JEditorPane problemPane = new JEditorPane("text/html", "");
    private JEditorPane code = new MouseLessEditorPane("text/html", "");
    private final MouseLessTextArea status = new MouseLessTextArea("");
    private final LocalPreferences pref = LocalPreferences.getInstance();
    private final ContestApplet contestApplet;
    private String writer;
    private CoderComponent coderComponent;
    private SyntaxHighlighter highlighter;
    private boolean enabled = true;
    private boolean showChallengeSucceeded = true;
    private JScrollPane problemScroll;
    private JButton challengeButton = null;
    private JButton findButton = null;
    private SourceFindDialog findDialog;
    private SourceViewerListener challengePanel = null;
    private final boolean challengeable;
    private ProblemModel problem;
    private JSplitPane splitPane;
    private boolean allowCopy;
    private String oldText;
    private Language oldLanguage;
    private String oldHtml;
    private static SourceViewer otherViewer = null;
    private static Object viewerLock = new Object();
    private static final int TAB_COUNT = 20;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            if (this.challengeable) {
                this.challengeButton.setEnabled(true);
            }
        } else if (this.challengeable) {
            this.challengeButton.setEnabled(false);
        }
    }

    public SourceViewer(ContestApplet contestApplet, boolean bl) {
        this(contestApplet, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceViewer(ContestApplet contestApplet, boolean bl, boolean bl2) {
        super("Source Code Viewer");
        Object object = viewerLock;
        synchronized (object) {
            if (otherViewer != null && otherViewer != this) {
                otherViewer.closeWindow();
                otherViewer.dispose();
            }
            otherViewer = this;
        }
        this.allowCopy = bl2;
        this.contestApplet = contestApplet;
        this.getContentPane().setBackground(Common.BG_COLOR);
        this.challengeable = bl;
        this.create();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SourceViewer.this.closeWindow();
            }
        });
    }

    SourceViewer(ContestApplet contestApplet) {
        this(contestApplet, false);
    }

    public void setChallengeable(boolean bl) {
        if (this.challengeButton != null) {
            this.challengeButton.setEnabled(bl);
        }
    }

    public void clear() {
        if (this.isVisible()) {
            return;
        }
        this.problemPane.setText("");
        this.problemScroll.getVerticalScrollBar().setValue(0);
        this.code.setText("");
        this.code.revalidate();
        this.oldText = null;
        this.oldLanguage = null;
        this.oldHtml = null;
    }

    public void setProblem(ProblemModel problemModel) {
        this.problem = problemModel;
    }

    public void setCode(String string, Language language) {
        Object object;
        String string2 = "";
        try {
            Object object2;
            object = this.pref.getConfigManager();
            if (!object.existsNamespace("com.topcoder.util.syntaxhighlighter")) {
                object2 = StandardEditorPanel.class.getResource("/syntaxhighlighter/config.xml");
                object.add((URL)object2);
            }
            this.highlighter = new SyntaxHighlighter();
            object2 = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont");
            int n = 0;
            int n2 = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize");
            for (int i = 0; i < this.highlighter.getLanguages().length; ++i) {
                TextStyle[] textStyleArray = this.highlighter.getLanguages()[i].getStyles();
                for (int j = 0; j < textStyleArray.length; ++j) {
                    if (textStyleArray[j].getName().equals("KEYWORD_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("BLOCK_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("LITERAL_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", "0"));
                    } else if (textStyleArray[j].getName().equals("DEFAULT_STYLE")) {
                        textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault"));
                        n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", "0"));
                    }
                    textStyleArray[j].setBGColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
                    textStyleArray[j].setFont(new Font((String)object2, n, n2));
                }
            }
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        try {
            if (this.pref.isViewerSyntaxHighlight() && string != null && !string.trim().equals("")) {
                this.code.setContentType("text/html");
                object = new HtmlOutput(this.pref.getTabSize());
                try {
                    this.highlighter.highlightText(string, language.getName(), (HighlightedOutput)object);
                    string2 = ((HtmlOutput)object).getText();
                }
                catch (Exception exception) {
                    string2 = HtmlOutput.span(HtmlOutput.convertStringToHtml(string), new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
                }
            } else {
                this.code.setContentType("text/plain");
                string2 = string;
            }
        }
        catch (StackOverflowError stackOverflowError) {
            string2 = HtmlOutput.span(HtmlOutput.convertStringToHtml(string), new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
        }
        if (this.oldText == null || !this.oldText.equals(string2) || this.oldLanguage == null || !this.oldLanguage.equals(language)) {
            this.code.setText(string2);
            this.code.setCaretPosition(0);
            this.oldText = string2;
            this.oldLanguage = language;
            this.code.revalidate();
        }
        this.refreshStatement();
        this.findDialog.setText(string);
        this.findDialog.setSyntaxHighlight(this.pref.isViewerSyntaxHighlight());
    }

    public void refreshStatement() {
        JavaLanguage javaLanguage = this.oldLanguage == null ? JavaLanguage.JAVA_LANGUAGE : this.oldLanguage;
        ProblemRenderer problemRenderer = new ProblemRenderer(this.problem.getProblem());
        problemRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string = "";
        try {
            string = problemRenderer.toHTML((Language)javaLanguage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.oldHtml == null || !this.oldHtml.equals(string)) {
            this.problemPane.setText(string);
            this.problemPane.setCaretPosition(0);
            this.oldHtml = string;
        }
    }

    public void setWriter(String string) {
        this.writer = string;
    }

    public void setCoderComponent(CoderComponent coderComponent) {
        this.coderComponent = coderComponent;
        this.setChallengeable(false);
        if (coderComponent.getStatus() == 140) {
            this.status.setText("This problem has been successfully challenged.");
        } else {
            this.status.setText("");
        }
    }

    public void setPanel(SourceViewerListener sourceViewerListener) {
        this.challengePanel = sourceViewerListener;
    }

    private void create() {
        Serializable serializable;
        JPanel jPanel;
        Serializable serializable2;
        if (this.allowCopy) {
            this.code = new JEditorPane("text/html", "");
            this.code.setEditable(false);
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(this.code);
        jPanel2.setBackground(Common.MB_COLOR);
        jPanel2.setForeground(Common.MF_COLOR);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(13);
        JPanel jPanel3 = Common.createMessagePanel("Problem Statement", this.problemPane, 0, 0, Common.BG_COLOR);
        JPanel jPanel4 = Common.createMessagePanel("Source Code", jScrollPane, 0, 0, Common.BG_COLOR);
        this.problemScroll = (JScrollPane)jPanel3.getComponent(0);
        if (this.challengeable) {
            serializable2 = this.createButtonPanel();
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel4, "Center");
            jPanel.add((Component)serializable2, "South");
        } else {
            jPanel = jPanel4;
        }
        this.splitPane = new JSplitPane(0, true, jPanel3, jPanel);
        this.pref.addSaveObserver(this);
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize") + "pt;}");
        this.problemPane.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore"));
        this.problemPane.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback"));
        this.code.setFont(new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")));
        this.problemPane.setEditable(false);
        this.code.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
        this.code.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        this.code.setDisabledTextColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.getContentPane().add((Component)this.splitPane, gridBagConstraints);
        serializable2 = this.pref.getLocation(FRAMELOCATION);
        if (serializable2 == null) {
            serializable = this.contestApplet.getCurrentFrame();
            serializable2 = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        serializable2 = Common.adjustWindowLocation((Point)serializable2);
        this.setLocation((Point)serializable2);
        serializable = this.pref.getSize(FRAMESIZE);
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        serializable = Common.adjustWindowSize((Point)serializable2, (Dimension)serializable);
        this.setSize((Dimension)serializable);
        String string = this.pref.getProperty(DIVIDERLOC);
        if (string == null) {
            string = "80";
        }
        this.splitPane.setDividerLocation(Integer.parseInt(string));
        this.findDialog = new SourceFindDialog(jPanel4, this.code);
        this.addKeyListener(new KeyHandler());
        jPanel4.addKeyListener(new KeyHandler());
        this.splitPane.addKeyListener(new KeyHandler());
    }

    private JPanel createButtonPanel() {
        this.challengeButton = new JButton("Challenge");
        this.challengeButton.setForeground(Common.FG_COLOR);
        this.challengeButton.setBackground(Color.black);
        this.challengeButton.setFocusPainted(false);
        this.challengeButton.setToolTipText("Challenge this code");
        this.challengeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceViewer.this.challengeButtonEvent();
            }
        });
        this.findButton = new JButton("Find");
        this.findButton.setForeground(Common.FG_COLOR);
        this.findButton.setBackground(Color.black);
        this.findButton.setFocusPainted(false);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceViewer.this.findButtonEvent();
            }
        });
        this.status.setDisabledTextColor(Color.red);
        this.status.setFont(new Font("", 3, 13));
        this.status.setBackground(Common.THB_COLOR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.challengeButton, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.findButton, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.status, jPanel, gridBagConstraints, 2, 0, 1, 1, 0.9, 0.0);
        return jPanel;
    }

    private void challengeButtonEvent() {
        if (this.challengePanel != null && this.challengePanel instanceof BaseAlgoSummaryTablePanel) {
            ((BaseAlgoSummaryTablePanel)this.challengePanel).doChallenge(this.writer, this.coderComponent, this);
        }
    }

    private void findButtonEvent() {
        this.findDialog.show();
    }

    private void closeWindow() {
        if (!this.enabled) {
            return;
        }
        this.pref.removeSaveObserver(this);
        if (this.challengePanel != null) {
            this.challengePanel.sourceViewerClosing();
        }
        if (this.coderComponent != null && this.writer != null) {
            this.contestApplet.getRequester().requestCloseComponent(this.coderComponent.getComponent().getID(), this.writer);
        }
        this.pref.setLocation(FRAMELOCATION, this.getLocation());
        this.pref.setSize(FRAMESIZE, this.getSize());
        this.pref.setProperty(DIVIDERLOC, String.valueOf(this.splitPane.getDividerLocation()));
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void notifyChallengeSucceeded(String string, String string2) {
        if (this.showChallengeSucceeded) {
            this.status.setText("This problem has been successfully challenged.");
            this.showChallengeSucceeded = false;
        }
    }

    public void doChallengeRequest(ArrayList arrayList) {
        ComponentChallengeData componentChallengeData = this.coderComponent.getComponent().getComponentChallengeData();
        if (((Boolean)arrayList.get(0)).booleanValue()) {
            String string = this.writer;
            this.contestApplet.setCurrentFrame(this);
            this.contestApplet.getInterFrame().showMessage("Challenging...", this.contestApplet.getCurrentFrame(), 0);
            this.contestApplet.getRequester().requestChallenge(string, componentChallengeData.getComponentID(), (ArrayList)arrayList.get(1));
        }
        if (this.challengePanel != null) {
            if (this.challengePanel instanceof ChallengeTablePanel) {
                ((ChallengeTablePanel)this.challengePanel).setOldArgs((ArrayList)arrayList.get(1), componentChallengeData.getComponentID());
            } else if (this.challengePanel instanceof DivSummaryTablePanel) {
                ((DivSummaryTablePanel)this.challengePanel).setOldArgs((ArrayList)arrayList.get(1), componentChallengeData.getComponentID());
            }
        }
    }

    public void update(Observable observable, Object object) {
        try {
            this.code.setFont(new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")));
            this.code.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"));
            this.code.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
            this.code.setDisabledTextColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private TabSet getTabSet(int n) {
        String string = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont");
        int n2 = 0;
        int n3 = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize");
        Font font = new Font(string, n2, n3);
        int n4 = StyleContext.getDefaultStyleContext().getFontMetrics(font).stringWidth(" ");
        TabStop[] tabStopArray = new TabStop[20];
        for (int i = 0; i < 20; ++i) {
            tabStopArray[i] = new TabStop(n * n4 * (i + 1), 0, 1);
        }
        return new TabSet(tabStopArray);
    }

    public static interface SourceViewerListener {
        public void sourceViewerClosing();
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 70: {
                    if (!keyEvent.isAltDown()) break;
                    keyEvent.consume();
                    SourceViewer.this.findButtonEvent();
                    return;
                }
                case 114: {
                    keyEvent.consume();
                    SourceViewer.this.findDialog.findAgain();
                    return;
                }
            }
        }
    }
}

