/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.SourceViewer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.netCommon.contestantMessages.response.RoundStatsResponse;
import com.topcoder.netCommon.contestantMessages.response.data.RoundStatsProblem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class RoundStatsFrame
extends JFrame {
    private static final Color BACKGROUND = Common.WPB_COLOR;
    private static final Color PANEL_BACKGROUND = Common.PB_COLOR;
    private static final GridBagConstraints GBC = Common.getDefaultConstraints();
    private final ContestApplet contestApplet;
    private final Coder coder;
    private final int roundId;
    private final String coderName;
    private final SourceViewer sourceViewer;

    private RoundStatsFrame(ContestApplet contestApplet, RoundStatsResponse roundStatsResponse, Coder coder, int n) {
        super("Round Stats");
        this.contestApplet = contestApplet;
        this.coder = coder;
        this.roundId = n;
        this.coderName = roundStatsResponse.getCoderName();
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setBackground(BACKGROUND);
        container.setLayout(new GridBagLayout());
        RoundStatsFrame.GBC.insets = RoundStatsFrame.beginInsets();
        this.insertInContentPane(RoundStatsFrame.createLabel("Elimination Round: " + roundStatsResponse.getRoundName()), 0);
        RoundStatsFrame.GBC.insets = RoundStatsFrame.middleInsets();
        this.insertInContentPane(this.createPanel(roundStatsResponse), 1);
        RoundStatsFrame.GBC.insets = RoundStatsFrame.endInsets();
        RoundStatsFrame.GBC.fill = 0;
        this.insertInContentPane(this.createOkButton(), 2);
        this.pack();
        this.sourceViewer = new SourceViewer(contestApplet);
    }

    private JComponent createPanel(RoundStatsResponse roundStatsResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(Common.getTitledBorder("Statistics for team member " + this.coderName + ":"));
        jPanel.setBackground(BACKGROUND);
        jPanel.setPreferredSize(new Dimension(600, 170));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInsidePanel(roundStatsResponse));
        return jPanel;
    }

    private Component createInsidePanel(RoundStatsResponse roundStatsResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setLayout(new GridBagLayout());
        RoundStatsFrame.GBC.anchor = 17;
        RoundStatsFrame.GBC.fill = 17;
        RoundStatsProblem[] roundStatsProblemArray = roundStatsResponse.getProblems();
        RoundStatsFrame.GBC.insets = RoundStatsFrame.beginInsets();
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createLabel("Problem"), jPanel, 0, 0);
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createLabel("Points"), jPanel, 1, 0);
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createLabel("Status"), jPanel, 2, 0);
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createLabel("Time to Submit"), jPanel, 3, 0);
        RoundStatsFrame.GBC.insets = RoundStatsFrame.middleInsets();
        for (int i = 0; i < roundStatsProblemArray.length; ++i) {
            boolean bl;
            RoundStatsProblem roundStatsProblem = roundStatsProblemArray[i];
            boolean bl2 = bl = i == roundStatsProblemArray.length - 1;
            if (bl) {
                RoundStatsFrame.GBC.insets = RoundStatsFrame.endInsets();
            }
            String string = roundStatsProblem.getClassName();
            double d = roundStatsProblem.getEarnedPoints();
            double d2 = roundStatsProblem.getPointValue();
            String string2 = roundStatsProblem.getStatusString();
            String string3 = roundStatsProblem.getTimeToSubmit();
            long l = roundStatsProblem.getComponentId();
            this.addToPanel(jPanel, i, string, d, d2, string2, string3, l);
        }
        RoundStatsFrame.GBC.anchor = 11;
        return jPanel;
    }

    private void addToPanel(JComponent jComponent, int n, String string, double d, double d2, String string2, String string3, long l) {
        boolean bl;
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createProblemLabel(string), jComponent, 0, ++n);
        String string4 = d == 0.0 ? "0" : "" + d;
        String string5 = string4 + "/" + (int)d2;
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createProblemLabel(string5), jComponent, 1, n);
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createProblemLabel(string2), jComponent, 2, n);
        RoundStatsFrame.insertInPanel(RoundStatsFrame.createProblemLabel(string3), jComponent, 3, n);
        JComponent jComponent2 = this.createViewCodeButton(l);
        RoundStatsFrame.insertInPanel(jComponent2, jComponent, 4, n);
        boolean bl2 = bl = !string2.equals("Unopened");
        if (bl) {
            final CoderComponent coderComponent = this.coder.getComponent(new Long(l));
            coderComponent.addListener(new CoderComponent.Listener(){

                public void coderComponentEvent(CoderComponent coderComponent) {
                    if (!coderComponent.hasSourceCode()) {
                        throw new IllegalStateException("Missing source code for coder: " + coderComponent.getCoder().getHandle());
                    }
                    RoundStatsFrame.this.sourceViewer.clear();
                    RoundStatsFrame.this.sourceViewer.setCode(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
                    Double d = coderComponent.getComponent().getPoints();
                    RoundStatsFrame.this.sourceViewer.setTitle(coderComponent.getCoder().getHandle() + "'s " + Common.formatNoFractions(d) + "-point Problem");
                    String string = coderComponent.getCoder().getHandle();
                    RoundStatsFrame.this.sourceViewer.setWriter(string);
                    RoundStatsFrame.this.sourceViewer.show();
                }
            });
            ProblemModel problemModel = coderComponent.getComponent().getProblem();
            problemModel.addListener(new ProblemModel.Listener(){

                public void updateProblemModel(ProblemModel problemModel) {
                    if (problemModel.hasProblemStatement()) {
                        if (RoundStatsFrame.this.sourceViewer == null) {
                            throw new IllegalStateException("Source viewer not initialized!");
                        }
                    } else {
                        throw new IllegalStateException("Missing statement for problem " + problemModel);
                    }
                    RoundStatsFrame.this.sourceViewer.show();
                    RoundStatsFrame.this.sourceViewer.setProblem(problemModel);
                    RoundStatsFrame.this.sourceViewer.setCoderComponent(coderComponent);
                    RoundStatsFrame.this.sourceViewer.refreshStatement();
                }

                public void updateProblemModelReadOnly(ProblemModel problemModel) {
                }
            });
        }
        jComponent2.setVisible(bl);
    }

    private JComponent createViewCodeButton(final long l) {
        JButton jButton = new JButton("View Code");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RoundStatsFrame.this.contestApplet != null) {
                    RoundStatsFrame.this.contestApplet.viewCodeRequest(RoundStatsFrame.this.coderName, l, RoundStatsFrame.this.roundId);
                }
            }
        });
        return jButton;
    }

    private JComponent createOkButton() {
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoundStatsFrame.this.dispose();
            }
        });
        return jButton;
    }

    private void insertInContentPane(JComponent jComponent, int n) {
        RoundStatsFrame.insertInPanel(jComponent, this.getContentPane(), n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n) {
        RoundStatsFrame.insertInPanel(jComponent, container, 0, n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2) {
        RoundStatsFrame.insertInPanel(jComponent, container, n, n2, 1.0);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2, double d) {
        Common.insertInPanel(jComponent, container, GBC, n, n2, 1, 1, d, 0.0);
    }

    private static JComponent createLabel(String string) {
        return RoundStatsFrame.createLabel(string, Common.PT_COLOR);
    }

    private static JComponent createLabel(String string, Color color) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(color);
        return jLabel;
    }

    private static JComponent createProblemLabel(String string) {
        return RoundStatsFrame.createLabel(string, Color.white);
    }

    private static Insets beginInsets() {
        return RoundStatsFrame.newInsets(15, 5);
    }

    private static Insets middleInsets() {
        return RoundStatsFrame.newInsets(5, 5);
    }

    private static Insets endInsets() {
        return RoundStatsFrame.newInsets(5, 15);
    }

    private static Insets newInsets(int n, int n2) {
        return new Insets(n, 15, n2, 15);
    }

    public static void showFrame(ContestApplet contestApplet, RoundStatsResponse roundStatsResponse, Coder coder, int n) {
        RoundStatsFrame roundStatsFrame = new RoundStatsFrame(contestApplet, roundStatsResponse, coder, n);
        if (contestApplet != null) {
            Common.setLocationRelativeTo((Component)contestApplet.getCurrentFrame(), roundStatsFrame);
        }
        roundStatsFrame.show();
    }
}

