/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.panels.coding.CodingTimerPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestApplet.panels.table.RoomInfoTablePanel;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.contestant.view.RoundView;
import com.topcoder.netCommon.contest.round.RoundProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public final class RoomListFrame
extends JFrame
implements PhaseListener,
RoundView {
    private ContestApplet parentFrame = null;
    private RoomInfoTablePanel roomInfoPanel = null;
    private TimerPanel timerPanel = null;
    private JLabel roundsLabel = new JLabel("Rounds: ");
    private JComboBox rounds = new JComboBox();
    private static RoomListFrame singleton;
    private Long selectedRoundID = null;
    private boolean enabled = true;
    private Set roundsToShow = Collections.synchronizedSet(new LinkedHashSet());

    public Long getSelectedRoundID() {
        return this.selectedRoundID;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.rounds.setEnabled(true);
        } else {
            this.rounds.setEnabled(false);
        }
        if (this.roomInfoPanel != null) {
            this.roomInfoPanel.setEnabled(bl);
        }
    }

    public RoomListFrame(ContestApplet contestApplet) {
        super("Competition Room Details");
        this.parentFrame = contestApplet;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.create();
        Common.setLocationRelativeTo((Component)contestApplet.getMainFrame(), this);
    }

    public static RoomListFrame getInstance(ContestApplet contestApplet) {
        if (singleton == null) {
            singleton = new RoomListFrame(contestApplet);
        }
        return singleton;
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JLabel jLabel = new JLabel();
        RoomInfoTablePanel roomInfoTablePanel = new RoomInfoTablePanel(this.parentFrame);
        CodingTimerPanel codingTimerPanel = new CodingTimerPanel(this.parentFrame);
        roomInfoTablePanel.setMinimumSize(new Dimension(275, 350));
        roomInfoTablePanel.setPreferredSize(new Dimension(275, 350));
        jLabel.setForeground(Common.STATUS_COLOR);
        jLabel.setText("NOTE: * represents a close race (50 points)");
        this.rounds.setMinimumSize(new Dimension(200, 20));
        this.rounds.setPreferredSize(new Dimension(250, 20));
        this.rounds.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof RoundModel) {
                    RoundModel roundModel = (RoundModel)object;
                    object = roundModel.getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.rounds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoundModel roundModel = (RoundModel)RoomListFrame.this.rounds.getSelectedItem();
                if (roundModel != null) {
                    RoomListFrame.this.roomInfoPanel.setRound(roundModel);
                    RoomListFrame.this.selectedRoundID = roundModel.getRoundID();
                    RoomListFrame.this.setRoomPhase(roundModel);
                } else {
                    RoomListFrame.this.selectedRoundID = null;
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Common.WPB_COLOR);
        this.roundsLabel.setForeground(Common.STATUS_COLOR);
        this.rounds.setBackground(Common.WPB_COLOR);
        this.rounds.setForeground(Common.STATUS_COLOR);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        Common.insertInPanel(this.roundsLabel, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        Common.insertInPanel(this.rounds, jPanel, gridBagConstraints, 1, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        Common.insertInPanel(new ContestSponsorPanel(this.parentFrame, CommonData.getSponsorScoreBoardImageAddr(this.parentFrame.getSponsorName(), null)), this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(codingTimerPanel, this.getContentPane(), gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(roomInfoTablePanel, this.getContentPane(), gridBagConstraints, 0, 1, 2, 1, 0.1, 1.0);
        gridBagConstraints.insets = new Insets(5, 20, 15, 20);
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 2, 2, 1, 0.1, 1.0);
        Common.insertInPanel(jLabel, this.getContentPane(), gridBagConstraints, 0, 3, 2, 1, 0.1, 0.1);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                RoomListFrame.this.show();
            }
        });
        this.parentFrame.getModel().getRoundViewManager().addListener(this);
        this.bindToActiveRounds();
        this.roomInfoPanel = roomInfoTablePanel;
        this.timerPanel = codingTimerPanel;
        this.pack();
    }

    private void setRoomPhase(RoundModel roundModel) {
        this.setTimerPanelRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), roundModel);
    }

    public void reset() {
        this.roomInfoPanel.clear();
    }

    public void hide() {
        super.hide();
        this.reset();
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseLeaderBoard();
        }
    }

    public void show() {
        this.reloadRounds();
        super.show();
    }

    public void reloadRounds() {
        Long l = this.selectedRoundID == null ? null : new Long(this.selectedRoundID);
        this.reset();
        this.rounds.removeAllItems();
        if (this.roundsToShow.size() > 0) {
            RoundModel[] roundModelArray = this.roundsToShow.toArray(new RoundModel[this.roundsToShow.size()]);
            RoundModel roundModel = roundModelArray[0];
            this.rounds.addItem(roundModel);
            this.roomInfoPanel.setRound(roundModel);
            this.rounds.setSelectedIndex(0);
            this.setRoomPhase(roundModel);
            for (int i = 1; i < roundModelArray.length; ++i) {
                roundModel = roundModelArray[i];
                this.rounds.addItem(roundModel);
                if (!roundModel.getRoundID().equals(l)) continue;
                this.roomInfoPanel.setRound(roundModel);
                this.rounds.setSelectedIndex(i);
                this.setRoomPhase(roundModel);
            }
        }
    }

    private TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void setTimerPanelRoundModel(RoundModel roundModel) {
        this.getTimerPanel().setRoundModel(roundModel);
    }

    public synchronized void phaseEvent(int n, RoundModel roundModel) {
        if (roundModel != null && roundModel.canDisplaySummary() != this.roundsToShow.contains(roundModel)) {
            if (roundModel.canDisplaySummary()) {
                this.roundsToShow.add(roundModel);
            } else {
                this.roundsToShow.remove(roundModel);
            }
            this.reloadRounds();
        }
        if (roundModel == null || roundModel.getRoundID().equals(this.selectedRoundID)) {
            this.setTimerPhase(n, roundModel);
        }
    }

    private void setTimerPhase(int n, RoundModel roundModel) {
        int n2 = -1;
        String string = null;
        switch (n) {
            case 0: {
                string = "TOPCODER TIME";
                n2 = 1;
                break;
            }
            case 7: {
                string = "PENDING SYSTESTS";
                n2 = 1;
                break;
            }
            case 9: {
                string = "CONTEST COMPLETE";
                n2 = 1;
                break;
            }
            case 2: {
                string = "REGISTRATION";
                n2 = 2;
                break;
            }
            case 3: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 1: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 4: {
                string = "CODING";
                n2 = 2;
                break;
            }
            case 5: {
                string = "INTERMISSION";
                n2 = 2;
                break;
            }
            case 6: {
                string = "CHALLENGE";
                n2 = 2;
                break;
            }
            case 10: {
                string = "VOTING";
                n2 = 2;
                break;
            }
            case 11: {
                string = "TIE BREAKING VOTE";
                n2 = 2;
                break;
            }
            case 8: {
                string = "SYSTEM TESTING";
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad phase type: " + n);
            }
        }
        this.getTimerPanel().setTitle(string);
        this.getTimerPanel().setMode(n2);
    }

    public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
        if (roundModel.getRoundID().equals(this.selectedRoundID)) {
            this.getTimerPanel().updateSystestProgress(n, n2);
        }
    }

    public void enableRound(RoundModel roundModel) {
    }

    public void clearRoundList() {
    }

    public void updateActiveRoundList(Contestant contestant) {
        RoundModel[] roundModelArray = contestant.getActiveRounds();
        if (roundModelArray.length == 0) {
            this.phaseEvent(0, null);
        } else {
            this.bindToActiveRounds();
            this.reloadRounds();
        }
    }

    private void bindToActiveRounds() {
        RoundModel[] roundModelArray = this.parentFrame.getModel().getActiveRounds();
        if (roundModelArray != null && roundModelArray.length > 0) {
            LinkedHashSet<RoundModel> linkedHashSet = new LinkedHashSet<RoundModel>(10);
            RoundModel roundModel = null;
            for (int i = 0; i < roundModelArray.length; ++i) {
                RoundModel roundModel2 = roundModelArray[i];
                RoundProperties roundProperties = roundModel2.getRoundProperties();
                if (!roundProperties.usesScore() || !roundProperties.getShowScoresOfOtherCoders().booleanValue()) continue;
                if (!roundModel2.containsPhaseListener(this)) {
                    roundModel2.addPhaseListener(this);
                }
                if (!roundModel2.canDisplaySummary()) continue;
                linkedHashSet.add(roundModel2);
                if (!roundModel2.getRoundID().equals(this.selectedRoundID)) continue;
                roundModel = roundModel2;
            }
            this.roundsToShow = Collections.synchronizedSet(linkedHashSet);
            if (this.roundsToShow.size() > 0) {
                if (roundModel == null) {
                    roundModel = (RoundModel)this.roundsToShow.iterator().next();
                }
                this.internalSetSelectedRound(roundModel);
            }
        }
    }

    private void internalSetSelectedRound(RoundModel roundModel) {
        this.getTimerPanel().setRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), roundModel);
    }
}

