/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.ChatPanel;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.panels.table.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.ChallengeTablePanel;
import com.topcoder.client.contestApplet.panels.table.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.UserTablePanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestApplet.widgets.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.RoomView;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;

public final class RoomInfoFrame
extends JFrame
implements RoomView {
    private RoomModel model;
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private UserTablePanel userPanel = null;
    private ChatPanel chatPanel = null;
    private boolean once = true;
    private JRadioButton jrb2 = null;
    private boolean enabled = true;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.userPanel.setPanelEnabled(bl);
        this.chatPanel.setPanelEnabled(bl);
        this.challengePanel.setPanelEnabled(bl);
    }

    public RoomInfoFrame(ContestApplet contestApplet, RoomModel roomModel) {
        super("TopCoder Competition Scoreboard");
        this.parentFrame = contestApplet;
        this.model = roomModel;
    }

    public RoomModel getModel() {
        return this.model;
    }

    public boolean hasRoomModel() {
        return this.model != null;
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), this);
            this.once = false;
        }
        this.show();
        MoveFocus.moveFocus(this.challengePanel.getTable());
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        AbstractSummaryTablePanel abstractSummaryTablePanel = this.isLongRound() ? new LongSummaryTablePanel(this.parentFrame, this.model, this, true) : new ChallengeTablePanel(this.parentFrame, this.model, this, true);
        UserTablePanel userTablePanel = new UserTablePanel(this.parentFrame);
        JPanel jPanel = this.createPrettyTogglePanel();
        ContestSponsorPanel contestSponsorPanel = new ContestSponsorPanel(this.parentFrame, CommonData.getSponsorWatchRoomImageAddr(this.parentFrame.getSponsorName(), this.getModel()));
        ChatPanel chatPanel = new ChatPanel(this.parentFrame);
        userTablePanel.setMinimumSize(new Dimension(150, 0));
        userTablePanel.setPreferredSize(new Dimension(150, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        Common.insertInPanel(userTablePanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.1);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        Common.insertInPanel(chatPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, 1.0, 0.1);
        JSplitPane jSplitPane = new JSplitPane(0, true, abstractSummaryTablePanel, jPanel2);
        this.userPanel = userTablePanel;
        jSplitPane.setDividerLocation(225);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        abstractSummaryTablePanel.setPreferredSize(new Dimension(675, 150));
        jPanel2.setPreferredSize(new Dimension(675, 275));
        chatPanel.readonly(true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 15, 0, 15);
        Common.insertInPanel(contestSponsorPanel, this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.1, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 15, 0, 15);
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        Common.insertInPanel(jSplitPane, this.getContentPane(), gridBagConstraints, 0, 1, 2, 1, 0.1, 0.1);
        this.challengePanel = abstractSummaryTablePanel;
        this.chatPanel = chatPanel;
        this.pack();
    }

    private boolean isLongRound() {
        return this.model.getRoundModel() != null && this.model.getRoundModel().getRoundType().isLongRound();
    }

    public boolean getPrettyToggle() {
        return this.jrb2.isSelected();
    }

    private JPanel createPrettyTogglePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        if (this.isLongRound()) {
            return jPanel;
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        JLabel jLabel = new JLabel("Pretty : ", 4);
        JRadioButton jRadioButton = new JRadioButton("Off", true);
        JRadioButton jRadioButton2 = new JRadioButton("On", false);
        jLabel.setToolTipText("Reformat source code for readability.");
        jLabel.setForeground(Color.white);
        jRadioButton.setBackground(Common.WPB_COLOR);
        jRadioButton2.setBackground(Common.WPB_COLOR);
        jRadioButton.setForeground(Color.white);
        jRadioButton2.setForeground(Color.white);
        jRadioButton.setOpaque(false);
        jRadioButton2.setOpaque(false);
        jRadioButton.setActionCommand("Standard");
        jRadioButton2.setActionCommand("VI");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        this.jrb2 = jRadioButton2;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setOpaque(false);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.3, 0.1);
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 0, 2, 1, 0.1, 0.1);
        JLabel jLabel2 = new JLabel("View : ", 4);
        jLabel2.setToolTipText("View challenge/test status or point values.");
        jLabel2.setForeground(Color.white);
        this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.model.getRoundModel(), new ResultDisplayTypeSelectionPanel.Listener(){

            public void typeChanged(ResultDisplayType resultDisplayType) {
                RoomInfoFrame.this.challengePanel.updateView(resultDisplayType);
            }
        });
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, 1, 1, 1, 0.3, 0.1);
        Common.insertInPanel(this.resultDisplayTypeSelectionPanel, jPanel, gridBagConstraints, 1, 1, 2, 1, 0.1, 0.1);
        return jPanel;
    }

    public void setModel(RoomModel roomModel) {
        this.model = roomModel;
        this.create();
        roomModel.addChatView(this.chatPanel);
        roomModel.addUserListView(this.userPanel);
        roomModel.addUserListView(this.chatPanel);
        roomModel.addChallengeView(this.challengePanel);
        this.userPanel.updateUserList(roomModel.getUsers());
    }

    public void unsetModel() {
        this.model.removeChallengeView(this.challengePanel);
        this.model.removeUserListView(this.chatPanel);
        this.model.removeUserListView(this.userPanel);
        this.model.removeChatView(this.chatPanel);
        this.model.unsetWatchView();
        this.hide();
    }

    public void setName(String string) {
        super.setName("TopCoder Competition Scoreboard - " + string);
        this.repaint();
    }

    public void setStatus(String string) {
    }

    public String toString() {
        return "Room Info Frame - " + this.model;
    }
}

