/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.table.PracticeSystestResultsSummaryPanel;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResponse;
import com.topcoder.netCommon.contestantMessages.response.PracticeSystemTestResultResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class PracticeSystestResultsFrame
extends JFrame {
    private ContestApplet parentFrame = null;
    private PracticeSystestResultsSummaryPanel summaryPanel = null;
    private JProgressBar progress = null;
    private Map testCounts = null;
    private Map testsCompleted = null;
    private Map statusMap = null;
    private JPanel status = null;
    private Map labelMap = null;
    private static ProblemComponentModel[] components = null;
    private boolean enabled = true;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.summaryPanel.setPanelEnabled(bl);
    }

    public void update(PracticeSystemTestResultResponse practiceSystemTestResultResponse) {
        this.summaryPanel.update(practiceSystemTestResultResponse);
        if (practiceSystemTestResultResponse.getResultData().isSucceeded()) {
            this.testsCompleted.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Integer((Integer)this.testsCompleted.get(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId())) + 1));
        } else {
            this.statusMap.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Boolean(false));
            this.testsCompleted.put(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()), new Integer((Integer)this.testCounts.get(new Integer(practiceSystemTestResultResponse.getResultData().getComponentId()))));
        }
        this.checkLabel(practiceSystemTestResultResponse.getResultData().getComponentId());
        this.updateProgressStatus();
    }

    public static int getCompVal(int n) {
        for (int i = 0; i < components.length; ++i) {
            if (n != components[i].getID().intValue()) continue;
            return components[i].getPoints().intValue();
        }
        return 0;
    }

    private void checkLabel(int n) {
        int n2 = (Integer)this.testsCompleted.get(new Integer(n));
        int n3 = (Integer)this.testCounts.get(new Integer(n));
        boolean bl = (Boolean)this.statusMap.get(new Integer(n));
        JLabel jLabel = (JLabel)this.labelMap.get(new Integer(n));
        if (!bl) {
            jLabel.setForeground(Color.RED);
        } else if (n2 == n3) {
            jLabel.setForeground(Color.GREEN);
        }
    }

    private void updateProgressStatus() {
        int n = 0;
        Iterator iterator = this.testsCompleted.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            n += ((Integer)this.testsCompleted.get(k)).intValue();
        }
        this.progress.setValue(n);
        this.progress.setString(n + "/" + this.getTotalTestCount());
    }

    public void reset(PracticeSystemTestResponse practiceSystemTestResponse) {
        this.summaryPanel.getTableModel().clear();
        this.summaryPanel.reset();
        this.status.removeAll();
        RoomModel roomModel = this.parentFrame.getModel().getCurrentRoom();
        RoundModel roundModel = roomModel.getRoundModel();
        components = roundModel.getAssignedComponents(roomModel.getDivisionID());
        this.testCounts = practiceSystemTestResponse.getTestCaseCountByComponentId();
        this.testsCompleted = new HashMap();
        this.statusMap = new HashMap();
        this.labelMap = new HashMap();
        int n = 0;
        ArrayList arrayList = new ArrayList();
        Iterator<Object> iterator = this.testCounts.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList, new PointValueComparator());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            int n2 = (Integer)object;
            this.testsCompleted.put(object, new Integer(0));
            this.statusMap.put(object, new Boolean(true));
            JLabel jLabel = new JLabel("" + PracticeSystestResultsFrame.getCompVal(n2));
            jLabel.setForeground(Color.WHITE);
            jLabel.setBackground(Color.BLACK);
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            Common.insertInPanel(jLabel, this.status, gridBagConstraints, n, 0, 1, 1, 1.0, 1.0);
            this.labelMap.put(object, jLabel);
            ++n;
        }
        this.progress.setMaximum(this.getTotalTestCount());
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
    }

    private int getTotalTestCount() {
        int n = 0;
        Iterator iterator = this.testCounts.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            n += ((Integer)this.testCounts.get(k)).intValue();
        }
        return n;
    }

    public PracticeSystestResultsFrame(ContestApplet contestApplet) {
        super("Practice System Test Results");
        this.parentFrame = contestApplet;
        this.create();
    }

    public void showFrame() {
        Common.setLocationRelativeTo((Component)this.parentFrame.getCurrentFrame(), this);
        this.show();
        MoveFocus.moveFocus(this.summaryPanel.getTable());
    }

    public void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        UIManager.put("ProgressBar.selectionBackground", Common.PT_COLOR);
        UIManager.put("ProgressBar.selectionForeground", Color.WHITE);
        this.progress = new JProgressBar();
        this.progress.setBorder(null);
        this.progress.setBackground(Common.WPB_COLOR);
        this.progress.setForeground(Color.BLACK);
        this.progress.setBorderPainted(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(Common.getTitledBorder("Progress"));
        jPanel.setBackground(Common.WPB_COLOR);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = Common.getDefaultConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 1;
        Common.insertInPanel(this.progress, jPanel, gridBagConstraints2, 0, 0, 1, 1, 1.0, 1.0);
        this.status = new JPanel();
        this.status.setBorder(Common.getTitledBorder("Status"));
        this.status.setBackground(Common.WPB_COLOR);
        this.status.setLayout(new GridBagLayout());
        gridBagConstraints2 = Common.getDefaultConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 1;
        this.summaryPanel = new PracticeSystestResultsSummaryPanel(this.parentFrame);
        this.summaryPanel.setPreferredSize(new Dimension(575, 250));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        gridBagConstraints.fill = 2;
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.status, this.getContentPane(), gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(this.summaryPanel, this.getContentPane(), gridBagConstraints, 0, 3, 1, 1, 0.5, 1.0);
        this.pack();
    }

    private class PointValueComparator
    implements Comparator {
        private PointValueComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            int n3 = PracticeSystestResultsFrame.getCompVal(n);
            int n4 = PracticeSystestResultsFrame.getCompVal(n2);
            int n5 = n3 - n4;
            return n5;
        }
    }
}

