/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.netClient.ResponseWaiter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;

public final class MessageFrame
extends JFrame {
    private final ContestApplet ca;
    private final Component baseComp;
    private JLabel msg;
    private ResponseWaiter rw;

    public MessageFrame(String string, Component component, ContestApplet contestApplet) {
        super(string);
        this.ca = contestApplet;
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.getRootPane().setPreferredSize(new Dimension(200, 50));
        this.getRootPane().setMinimumSize(new Dimension(200, 50));
        this.getContentPane().setLayout(new BorderLayout());
        this.create();
        this.baseComp = component;
        this.pack();
    }

    public void showMessage(String string, int n) {
        this.showMessage(string, this.baseComp, n);
    }

    public void showMessage(String string, Component component, final int n) {
        this.terminate();
        this.msg.setText(string);
        Common.setLocationRelativeTo(component, this);
        this.rw = new ResponseWaiter();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (MessageFrame.this.rw.block()) {
                    MessageFrame.this.ca.getRoomManager().getCurrentRoom().timeOutEvent(n);
                    MessageFrame.this.timeOut();
                }
            }
        });
        thread.start();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.show();
    }

    public void hideMessage() {
        this.hide();
        this.terminate();
    }

    private void terminate() {
        if (this.rw != null) {
            this.rw.unBlock();
        }
    }

    private void timeOut() {
        this.msg.setText("Your request timed out.");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hide();
    }

    private void create() {
        JLabel jLabel = new JLabel("", 0);
        jLabel.setForeground(Color.white);
        jLabel.setFont(new Font(null, 0, 12));
        this.getContentPane().add((Component)jLabel, "Center");
        this.msg = jLabel;
    }
}

