/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.frames.CodingFrame;
import com.topcoder.client.contestApplet.panels.coding.MultiMethodProblemInfoPanel;
import com.topcoder.client.contestApplet.panels.coding.ProblemInfoComponent;
import com.topcoder.client.contestant.Contestant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class LongCodingFrame
extends CodingFrame {
    private JButton resultsButton;
    private JButton subHistoryButton;
    private JButton exHistoryButton;
    private JButton queueButton;

    public LongCodingFrame(ContestApplet contestApplet) {
        super(contestApplet);
    }

    protected CodingFrame.ButtonDef[] createButtonDefs() {
        CodingFrame.ButtonDef[] buttonDefArray = super.createButtonDefs();
        CodingFrame.ButtonDef[] buttonDefArray2 = new CodingFrame.ButtonDef[4];
        buttonDefArray2[0] = buttonDefArray[0];
        buttonDefArray2[1] = buttonDefArray[1];
        buttonDefArray2[3] = buttonDefArray[4];
        buttonDefArray2[2] = new CodingFrame.ButtonDef("g_example_but.gif", " no_g_example_but.gif", "Test Examples", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.exampleLongButtonEvent();
            }
        });
        buttonDefArray2[3].toolTipText = "Full submit";
        buttonDefArray2[3].actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.submitLongButtonEvent();
            }
        };
        return buttonDefArray2;
    }

    private void viewLastExampleButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            Contestant contestant = contestApplet.getModel();
            contestApplet.setCurrentFrame(this);
            contestApplet.getInterFrame().showMessage("Fetching results...", this, 120);
            contestApplet.getRequester().requestLongTestResults(this.getComponentId(), this.getRoomModel().getRoomID(), contestant.getCurrentUser(), 0);
        }
    }

    private void submitLongButtonEvent() {
        if (this.isPanelEnabled()) {
            this.setButtons(false, false, false, false, false, false, false, false);
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame(this);
            contestApplet.getInterFrame().showMessage("Submitting...", this, 14);
            contestApplet.getRequester().requestSubmitLong(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId(), false);
        }
    }

    private void exampleLongButtonEvent() {
        if (this.isPanelEnabled()) {
            this.setButtons(false, false, false, false, false, false, false, false);
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame(this);
            contestApplet.getInterFrame().showMessage("Example submission...", this, 15);
            contestApplet.getRequester().requestSubmitLong(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId(), true);
        }
    }

    protected void viewSubmissionHistoryButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame(this);
            Contestant contestant = contestApplet.getModel();
            this.getParentFrame().requestSubmissionHistory(contestant.getCurrentUser(), this.getRoomModel().getRoomID(), 1, false);
        }
    }

    protected void viewExampleHistoryButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame(this);
            Contestant contestant = contestApplet.getModel();
            this.getParentFrame().requestSubmissionHistory(contestant.getCurrentUser(), this.getRoomModel().getRoomID(), 1, true);
        }
    }

    protected void viewQueueButtonEvent() {
        if (this.isPanelEnabled()) {
            ContestApplet contestApplet = this.getParentFrame();
            contestApplet.setCurrentFrame(this);
            contestApplet.getInterFrame().showMessage("Fetching queue status...", this, 122);
            this.getParentFrame().getRequester().requestViewQueueStatus();
        }
    }

    protected ProblemInfoComponent newProblemInfoPanel() {
        return new MultiMethodProblemInfoPanel(this.getParentFrame(), 1);
    }

    protected JPanel newUnderProblemInfoPanel() {
        JPanel jPanel = super.newUnderProblemInfoPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        jPanel2.setOpaque(false);
        this.resultsButton = this.createButton(new CodingFrame.ButtonDef("g_vexample_but.gif", " no_g_vexample_but.gif", "View last example submission results", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewLastExampleButtonEvent();
            }
        }));
        this.subHistoryButton = this.createButton(new CodingFrame.ButtonDef("g_subhistory_but.gif", " no_g_subhistory_but.gif", "View submission history", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewSubmissionHistoryButtonEvent();
            }
        }));
        this.exHistoryButton = this.createButton(new CodingFrame.ButtonDef("g_exhistory_but.gif", " no_g_exhistory_but.gif", "View example history", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewExampleHistoryButtonEvent();
            }
        }));
        this.queueButton = this.createButton(new CodingFrame.ButtonDef("g_queue_but.gif", " no_g_queue_but.gif", "View queue status", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCodingFrame.this.viewQueueButtonEvent();
            }
        }));
        jPanel2.add(this.resultsButton);
        jPanel2.add(this.subHistoryButton);
        jPanel2.add(this.exHistoryButton);
        jPanel2.add(this.queueButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jPanel, "Center");
        return jPanel3;
    }

    protected void updateButtons(boolean bl) {
        this.resultsButton.setEnabled(bl);
        this.subHistoryButton.setEnabled(bl);
        this.exHistoryButton.setEnabled(bl);
        this.queueButton.setEnabled(bl);
    }

    protected String getDefaultEditor() {
        return "Standard";
    }

    protected boolean isEditorAllowed() {
        return false;
    }
}

