/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.widgets.NonEditableDocument;
import com.topcoder.netCommon.contest.Matrix2D;
import com.topcoder.shared.problem.DataType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class ConfirmInputDialog
extends JDialog {
    private boolean status = false;

    public ConfirmInputDialog(JFrame jFrame, DataType[] dataTypeArray, ArrayList arrayList) {
        super(jFrame, "Confirm Parameters", true);
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Common.WPB_COLOR);
        Font font = new Font("Courier", 0, 10);
        if (dataTypeArray.length != arrayList.size()) {
            throw new IllegalArgumentException("The number of arguments does not match the number of parameters");
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 2;
        for (int i = 0; i < dataTypeArray.length; ++i) {
            object2 = dataTypeArray[i].getDescription();
            object = arrayList.get(i);
            gridBagConstraints.insets = i == 0 ? new Insets(15, 15, 0, 15) : new Insets(5, 15, 0, 15);
            JTextField jTextField = new JTextField();
            NonEditableDocument nonEditableDocument = new NonEditableDocument();
            nonEditableDocument.setText(this.formatText(object));
            jTextField.setForeground(Common.FG_COLOR);
            jTextField.setBackground(Common.BG_COLOR);
            jTextField.setDocument(nonEditableDocument);
            jTextField.setPreferredSize(new Dimension(340, 22));
            jTextField.setCaretPosition(0);
            jTextField.setCaretColor(Common.FG_COLOR);
            JLabel jLabel = new JLabel("(" + (i + 1) + ") " + (String)object2);
            jLabel.setForeground(Color.white);
            jLabel.setBackground(Common.WPB_COLOR);
            jLabel.setFont(font);
            Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, i, 1, 1, 0.0, 0.0);
            Common.insertInPanel(jTextField, jPanel, gridBagConstraints, 1, i, 1, 1, 0.1, 0.1);
        }
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setBackground(Common.WPB_COLOR);
        object2 = new JButton("OK");
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmInputDialog.this.okButtonEvent();
            }
        });
        jPanel2.add((Component)object2);
        ((JButton)object2).setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)object2);
        object = new JButton("Cancel");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmInputDialog.this.cancelButtonEvent();
            }
        });
        jPanel2.add((Component)object);
        this.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        gridBagConstraints.fill = 2;
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        Common.insertInPanel(jPanel2, this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 0.1, 0.1);
        this.pack();
        Common.setLocationRelativeTo((Component)jFrame, this);
    }

    private String formatText(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ArrayList) {
            this.formatTextArray(stringBuffer, (ArrayList)object);
        } else if (object instanceof Matrix2D) {
            this.formatTextMatrix(stringBuffer, (Matrix2D)object);
        } else {
            this.formatTextString(stringBuffer, object.toString());
        }
        return stringBuffer.toString();
    }

    private void formatTextMatrix(StringBuffer stringBuffer, Matrix2D matrix2D) {
        stringBuffer.append("{");
        for (int i = 0; i < matrix2D.numRows(); ++i) {
            this.formatTextArray(stringBuffer, matrix2D.getRow(i));
            if (i >= matrix2D.numRows() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
    }

    private void formatTextArray(StringBuffer stringBuffer, ArrayList arrayList) {
        stringBuffer.append("{");
        for (int i = 0; i < arrayList.size(); ++i) {
            this.formatTextString(stringBuffer, arrayList.get(i).toString());
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
    }

    private void formatTextString(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
    }

    public boolean showDialog() {
        this.show();
        return this.status;
    }

    private void okButtonEvent() {
        this.status = true;
        this.dispose();
    }

    private void cancelButtonEvent() {
        this.status = false;
        this.dispose();
    }
}

