/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.HyperLinkLoader;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.PluginManager;
import com.topcoder.client.contestApplet.frames.MessageDialog;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.panels.coding.CodingTimerPanel;
import com.topcoder.client.contestApplet.panels.coding.ProblemInfoComponent;
import com.topcoder.client.contestApplet.panels.coding.ProblemInfoPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestApplet.rooms.CoderRoom;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.rooms.TeamCoderRoom;
import com.topcoder.client.contestApplet.unusedCodeProcessor.UCRProcessor;
import com.topcoder.client.contestApplet.unusedCodeProcessor.UCRProcessorFactory;
import com.topcoder.client.contestApplet.widgets.BroadcastButton;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.render.ProblemComponentRenderer;
import com.topcoder.netCommon.contest.round.RoundProperties;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.CPPLanguage;
import com.topcoder.shared.language.CSharpLanguage;
import com.topcoder.shared.language.JavaLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.language.PythonLanguage;
import com.topcoder.shared.language.VBLanguage;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;

public class CodingFrame
extends JFrame {
    private static final boolean DEBUG = Boolean.getBoolean("com.topcoder.client.contestApplet.frames.CodingFrame");
    private ContestApplet parentFrame = null;
    private CodingTimerPanel timerPanel = null;
    private ProblemInfoComponent problemPanel = null;
    private JEditorPane problemPane;
    public JScrollPane problemScroll = null;
    private JPanel editorPanel = null;
    private JSplitPane jsp;
    private JLabel connStatus;
    private ButtonDef[] buttonDefs;
    private JButton[] buttons;
    private BroadcastButton broadcastButton;
    private JRadioButton javaRadioButton;
    private JRadioButton cplusplusRadioButton;
    private JRadioButton csharpRadioButton;
    private JRadioButton vbRadioButton;
    private JRadioButton pythonRadioButton;
    private JComboBox editorList;
    private boolean isSaved = true;
    private Language currentLanguage = JavaLanguage.JAVA_LANGUAGE;
    private boolean enabled = true;
    private RoomModel roomModel;
    private LocalPreferences pref = LocalPreferences.getInstance();
    private static final String FRAMELOCATION = "com.topcoder.jmaContestApplet.frames.codingframe.location";
    private static final String FRAMESIZE = "com.topcoder.jmaContestApplet.frames.codingframe.size";
    private static final String DIVIDERLOC = "com.topcoder.jmaContestApplet.frames.codingframe.dividerloc";
    private static final String NOCOPYPASTE = "com.topcoder.client.contestApplet.frames.codingframe.nocopypaste";
    private DynamicEditor dynamicEditor;
    private HashMap editorDefs = new HashMap();
    private boolean ignoreToggleEvent = false;
    private String compiledSource = "";
    private ProblemComponentModel component;
    private CoderRoomInterface cr;
    public int testComponentID;
    HashMap keyPrefs = new HashMap();
    HashMap keyButtons = new HashMap();
    private KeyListener kl = new KeyListener(){
        long lastTime = 0L;
        int lastKey = 0;

        public void keyPressed(KeyEvent keyEvent) {
            if (this.lastKey == keyEvent.getKeyCode() && System.currentTimeMillis() - this.lastTime < 500L) {
                return;
            }
            this.lastTime = System.currentTimeMillis();
            this.lastKey = keyEvent.getKeyCode();
            Iterator iterator = CodingFrame.this.keyPrefs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!CodingFrame.this.checkValue(keyEvent, (String)CodingFrame.this.keyPrefs.get(string))) continue;
                keyEvent.consume();
                JButton jButton = (JButton)CodingFrame.this.keyButtons.get(string);
                jButton.doClick();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    };

    public void setCR(CoderRoomInterface coderRoomInterface) {
        this.cr = coderRoomInterface;
    }

    public CodingFrame(ContestApplet contestApplet) {
        super("TopCoder Competition Arena - Coding Phase");
        this.problemPane = System.getProperty(NOCOPYPASTE) != null ? new NoClipboardEditorPane("text/html", "") : new JEditorPane("text/html", "");
        this.parentFrame = contestApplet;
        if (DEBUG) {
            System.out.println("Creating");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CodingFrame.this.unsetupKeyListener(CodingFrame.this.kl, CodingFrame.this.getContentPane());
                CodingFrame.this.closeCodingWindow();
            }
        });
        this.problemPane.addHyperlinkListener(new HyperLinkLoader(contestApplet.getAppletContext()));
    }

    private void unsetupKeyListener(KeyListener keyListener, Container container) {
        container.removeKeyListener(keyListener);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container instanceof Container) {
                this.unsetupKeyListener(keyListener, (Container)container.getComponent(i));
                continue;
            }
            this.unsetupKeyListener(keyListener, container.getComponent(i));
        }
    }

    private void unsetupKeyListener(KeyListener keyListener, Component component) {
        component.removeKeyListener(keyListener);
    }

    public void doTest(ArrayList arrayList) {
        ArrayList arrayList2 = null;
        try {
            arrayList2 = (ArrayList)arrayList.get(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.cr instanceof CoderRoom) {
            ((CoderRoom)this.cr).setArgs(arrayList2);
            this.cr = null;
        } else if (this.cr instanceof TeamCoderRoom) {
            ((TeamCoderRoom)this.cr).setArgs(arrayList2);
            this.cr = null;
        }
        if (((Boolean)arrayList.get(0)).booleanValue()) {
            this.test(arrayList, this.testComponentID);
        } else {
            this.setButtons(true, true, true, false, false, true, true, true);
        }
    }

    private void test(ArrayList arrayList, int n) {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Testing...", this, 15);
            this.parentFrame.getRequester().requestTest((ArrayList)arrayList.get(1), n);
        }
    }

    public void dispose() {
        if (DEBUG) {
            System.out.println("dispose: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        super.dispose();
    }

    public void hide() {
        if (DEBUG) {
            System.out.println("hide: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        super.hide();
    }

    public void setVisible(boolean bl) {
        if (DEBUG) {
            System.out.println("setVisible: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
            this.dynamicEditor = null;
        }
        super.setVisible(bl);
    }

    public void clear() {
        this.problemPane.setText("");
        this.problemScroll.getVerticalScrollBar().setValue(0);
        if (this.dynamicEditor != null) {
            this.dynamicEditor.clear();
        }
    }

    public void resetFocus() {
        MoveFocus.moveFocus(this.editorList);
        MoveFocus.moveFocus(this.editorPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodingFrame.this.editorPanel.requestFocus();
            }
        });
    }

    public void showFrame(boolean bl) {
        if (DEBUG) {
            System.out.println("showFrame: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), null);
        }
        this.updateLanguageButtonStatus();
        this.enableText(bl);
        this.show();
        this.resetFocus();
    }

    public String getCode() {
        if (this.dynamicEditor == null) {
            return "";
        }
        String string = this.getSourceCode();
        return string == null ? "" : string;
    }

    public TimerPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void updateComponentInfo(ProblemComponentModel problemComponentModel) {
        this.component = problemComponentModel;
        this.setLanguage(this.getDefaultLanguage());
        if (DEBUG) {
            System.out.println("updateComponentInfo: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), this.component.getDefaultSolution());
        } else {
            this.setEditor((String)this.editorList.getSelectedItem(), this.component.getDefaultSolution());
        }
    }

    public void create() {
        Serializable serializable;
        JSplitPane jSplitPane;
        ProblemInfoComponent problemInfoComponent;
        CodingTimerPanel codingTimerPanel;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.timerPanel = codingTimerPanel = new CodingTimerPanel(this.parentFrame);
        this.problemPanel = problemInfoComponent = this.newProblemInfoPanel();
        JPanel jPanel = Common.createMessagePanel("Problem Statement", this.problemPane, 0, 0, Common.BG_COLOR);
        JPanel jPanel2 = this.createEditorTogglePanel();
        JPanel jPanel3 = this.createSourceCodePanel("Coding Area", 0, 0);
        JPanel jPanel4 = this.createButtonPanel();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "South");
        this.jsp = jSplitPane = new JSplitPane(0, true, jPanel, jPanel5);
        this.problemPane.setFont(new Font(this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfont"), 0, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize")));
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("body {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize") + "pt;}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-family: " + this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfont") + ";}");
        ((HTMLDocument)this.problemPane.getDocument()).getStyleSheet().addRule("pre {font-size: " + this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfontsize") + "pt;}");
        this.problemPane.setForeground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        this.problemPane.setBackground(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        this.problemScroll = (JScrollPane)jPanel.getComponent(0);
        this.setButtons(false, false, false, false, false, false, false, false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        Common.insertInPanel((JComponent)((Object)problemInfoComponent), this.getContentPane(), gridBagConstraints, 0, 1, 2, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.connStatus = new JLabel(Common.getImage("grey_connected.gif", this.parentFrame));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jSplitPane.setBackground(Common.BG_COLOR);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        JLabel jLabel = new JLabel("Connection Status: ");
        jLabel.setForeground(Common.TIMER_COLOR);
        jLabel.setFont(new Font("SansSerif", 0, 10));
        Common.insertInPanel(jLabel, jPanel6, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(this.connStatus, jPanel6, gridBagConstraints, 1, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 25);
        Common.insertInPanel(jPanel6, this.getContentPane(), gridBagConstraints, 2, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 5, 5, 15);
        Common.insertInPanel(codingTimerPanel, this.getContentPane(), gridBagConstraints, 2, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        Common.insertInPanel(this.newUnderProblemInfoPanel(), this.getContentPane(), gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        Common.insertInPanel(jPanel2, this.getContentPane(), gridBagConstraints, 1, 2, 2, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        Common.insertInPanel(jSplitPane, this.getContentPane(), gridBagConstraints, 0, 3, 3, 1, 0.1, 0.1);
        this.pack();
        this.setupKeyListener(this.kl, this.getContentPane());
        Point point = this.pref.getLocation(FRAMELOCATION);
        if (point == null) {
            serializable = this.parentFrame.getCurrentFrame();
            point = serializable == null ? new Point(0, 0) : serializable.getLocation();
        }
        point = Common.adjustWindowLocation(point);
        this.setLocation(point);
        serializable = this.pref.getSize(FRAMESIZE);
        if (serializable == null) {
            serializable = new Dimension(760, 360);
        }
        this.setSize(Common.adjustWindowSize(point, (Dimension)serializable));
        String string = this.pref.getProperty(DIVIDERLOC);
        if (string == null) {
            string = "80";
        }
        jSplitPane.setDividerLocation(Integer.parseInt(string));
        for (int i = 0; i < this.buttonDefs.length; ++i) {
            ButtonDef buttonDef = this.buttonDefs[i];
            if (buttonDef.hotKeyPrefKey == null) continue;
            this.keyPrefs.put(buttonDef.hotKeyPrefKey, this.pref.getHotKey(buttonDef.hotKeyPrefKey));
            this.keyButtons.put(buttonDef.hotKeyPrefKey, this.buttons[i]);
        }
    }

    protected JPanel newUnderProblemInfoPanel() {
        return new ContestSponsorPanel(this.parentFrame, CommonData.getSponsorCodingFrameImageAddr(this.parentFrame.getSponsorName(), this.getRoomModel()));
    }

    protected ProblemInfoComponent newProblemInfoPanel() {
        return new ProblemInfoPanel(this.parentFrame);
    }

    private boolean checkValue(KeyEvent keyEvent, String string) {
        String[] stringArray = string.split("\\+");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((keyEvent.getModifiers() & 2) != 0) {
            bl2 = true;
        }
        if ((keyEvent.getModifiers() & 8) != 0) {
            bl = true;
        }
        if ((keyEvent.getModifiers() & 1) != 0) {
            bl3 = true;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("Ctrl")) {
                bl2 = false;
                if ((keyEvent.getModifiers() & 2) != 0) continue;
                return false;
            }
            if (stringArray[i].equals("Alt")) {
                bl = false;
                if ((keyEvent.getModifiers() & 8) != 0) continue;
                return false;
            }
            if (!stringArray[i].equals("Shift")) continue;
            bl3 = false;
            if ((keyEvent.getModifiers() & 1) != 0) continue;
            return false;
        }
        if (bl2 || bl || bl3) {
            return false;
        }
        return stringArray[stringArray.length - 1].equals(KeyEvent.getKeyText(keyEvent.getKeyCode()));
    }

    private void setupKeyListener(KeyListener keyListener, Container container) {
        container.removeKeyListener(keyListener);
        container.addKeyListener(keyListener);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container instanceof Container) {
                this.setupKeyListener(keyListener, (Container)container.getComponent(i));
                continue;
            }
            this.setupKeyListener(keyListener, container.getComponent(i));
        }
    }

    private void setupKeyListener(KeyListener keyListener, Component component) {
        component.removeKeyListener(keyListener);
        component.addKeyListener(keyListener);
    }

    private JPanel createEditorTogglePanel() {
        Object object;
        int n;
        List<EditorPlugin> list = Arrays.asList(PluginManager.getInstance().getEditorPlugins());
        String[] stringArray = new String[list.size()];
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            this.editorDefs.put(((EditorPlugin)object).getName(), object);
            stringArray[n] = ((EditorPlugin)object).getName();
        }
        Arrays.sort(stringArray, Collator.getInstance());
        this.editorList = Common.createComboBox();
        this.editorList.setPreferredSize(new Dimension(175, 21));
        this.editorList.setMaximumSize(new Dimension(175, 21));
        for (n = 0; n < stringArray.length; ++n) {
            this.editorList.addItem(stringArray[n]);
        }
        this.editorList.setSelectedItem(this.getDefaultEditor());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        object = new JLabel("Choose your editor: ", 2);
        ((JComponent)object).setForeground(Common.FG_COLOR);
        JLabel jLabel = new JLabel("Choose your language: ", 2);
        jLabel.setForeground(Common.FG_COLOR);
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.languageToggleEvent(actionEvent);
            }
        };
        JRadioButton jRadioButton = new JRadioButton("Java", true);
        jRadioButton.setBackground(Common.WPB_COLOR);
        jRadioButton.setForeground(Common.FG_COLOR);
        jRadioButton.setOpaque(false);
        jRadioButton.setActionCommand("Java");
        jPanel2.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        jRadioButton.addActionListener(actionListener);
        this.javaRadioButton = jRadioButton;
        JRadioButton jRadioButton2 = new JRadioButton("C++", false);
        jRadioButton2.setBackground(Common.WPB_COLOR);
        jRadioButton2.setForeground(Common.FG_COLOR);
        jRadioButton2.setOpaque(false);
        jRadioButton2.setActionCommand("C++");
        jPanel2.add(jRadioButton2);
        buttonGroup.add(jRadioButton2);
        jRadioButton2.addActionListener(actionListener);
        this.cplusplusRadioButton = jRadioButton2;
        JRadioButton jRadioButton3 = new JRadioButton("C#", false);
        jRadioButton3.setBackground(Common.WPB_COLOR);
        jRadioButton3.setForeground(Common.FG_COLOR);
        jRadioButton3.setOpaque(false);
        jRadioButton3.setActionCommand("C#");
        jPanel2.add(jRadioButton3);
        buttonGroup.add(jRadioButton3);
        jRadioButton3.addActionListener(actionListener);
        this.csharpRadioButton = jRadioButton3;
        JRadioButton jRadioButton4 = new JRadioButton("VB", false);
        jRadioButton4.setBackground(Common.WPB_COLOR);
        jRadioButton4.setForeground(Common.FG_COLOR);
        jRadioButton4.setOpaque(false);
        jRadioButton4.setActionCommand("VB");
        jPanel2.add(jRadioButton4);
        buttonGroup.add(jRadioButton4);
        jRadioButton4.addActionListener(actionListener);
        this.vbRadioButton = jRadioButton4;
        JRadioButton jRadioButton5 = new JRadioButton("Python", false);
        jRadioButton5.setBackground(Common.WPB_COLOR);
        jRadioButton5.setForeground(Common.FG_COLOR);
        jRadioButton5.setOpaque(false);
        jRadioButton5.setActionCommand("Python");
        jPanel2.add(jRadioButton5);
        buttonGroup.add(jRadioButton5);
        jRadioButton5.addActionListener(actionListener);
        this.pythonRadioButton = jRadioButton5;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        Common.insertInPanel((JComponent)object, jPanel, gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(this.editorList, jPanel, gridBagConstraints, 1, 0, 2, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 1, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 1, 1, 1, 0.0, 0.0);
        this.editorList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CodingFrame.this.ignoreToggleEvent) {
                    CodingFrame.this.editorToggleEvent();
                }
            }
        });
        return jPanel;
    }

    private JPanel createSourceCodePanel(String string, int n, int n2) {
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 1));
        this.editorPanel.setBorder(Common.getTitledBorder(string));
        this.editorPanel.setPreferredSize(new Dimension(n, n2));
        this.editorPanel.setBackground(Common.WPB_COLOR);
        this.editorPanel.setRequestFocusEnabled(true);
        return this.editorPanel;
    }

    protected boolean isPanelEnabled() {
        return this.enabled;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (bl) {
            this.connStatus.setIcon(Common.getImage("grey_connected.gif", this.parentFrame));
        } else {
            this.connStatus.setIcon(Common.getImage("grey_disconnected.gif", this.parentFrame));
        }
        this.broadcastButton.setButtonEnabled(bl);
        this.updateButtons(bl);
    }

    protected void updateButtons(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.buttonDefs.length; ++i) {
                this.buttons[i].setIcon(Common.getImage(this.buttonDefs[i].image, this.parentFrame));
            }
        } else {
            for (int i = 0; i < this.buttonDefs.length; ++i) {
                this.buttons[i].setIcon(Common.getImage(this.buttonDefs[i].disabledImage, this.parentFrame));
            }
        }
    }

    private JPanel createButtonPanel() {
        this.buttonDefs = this.createButtonDefs();
        this.buttons = new JButton[this.buttonDefs.length];
        for (int i = 0; i < this.buttonDefs.length; ++i) {
            this.buttons[i] = this.createButton(this.buttonDefs[i]);
        }
        this.broadcastButton = new BroadcastButton(this.parentFrame);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.broadcastButton, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.5, 0.0);
        gridBagConstraints.insets = new Insets(0, 1, 5, 1);
        gridBagConstraints.anchor = 13;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i == this.buttons.length - 1) {
                gridBagConstraints.insets = new Insets(0, 1, 5, 5);
            }
            Common.insertInPanel(this.buttons[i], jPanel, gridBagConstraints, i + 1, 0, 1, 1, 0.0, 0.0);
        }
        return jPanel;
    }

    protected JButton createButton(ButtonDef buttonDef) {
        JButton jButton = Common.getImageButton(buttonDef.image, this.parentFrame);
        jButton.setToolTipText(buttonDef.toolTipText);
        jButton.addActionListener(buttonDef.actionListener);
        return jButton;
    }

    protected ButtonDef[] createButtonDefs() {
        ButtonDef[] buttonDefArray = new ButtonDef[]{new ButtonDef("g_save_but.gif", "no_g_save_but.gif", "Save your source code", "com.topcoder.client.contestApplet.common.LocalPreferences.keysave", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.saveButtonEvent();
            }
        }), new ButtonDef("g_clear_but.gif", "no_g_clear_but.gif", "Clears your source code", null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.clearButtonEvent();
            }
        }), new ButtonDef("g_compile_but.gif", "no_g_compile_but.gif", "Compile source code", "com.topcoder.client.contestApplet.common.LocalPreferences.keycompile", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.compileButtonEvent();
            }
        }), new ButtonDef("g_test_but.gif", "no_g_test_but.gif", "Test your source code", "com.topcoder.client.contestApplet.common.LocalPreferences.keytest", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.testButtonEvent();
            }
        }), new ButtonDef("g_submit_but.gif", "no_g_submit_but.gif", "Final submission of source code", "com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodingFrame.this.submitButtonEvent();
            }
        })};
        return buttonDefArray;
    }

    public void enableText(boolean bl) {
        if (this.dynamicEditor == null) {
            return;
        }
        this.dynamicEditor.setTextEnabled(new Boolean(bl));
        this.editorList.setEnabled(bl && this.isEditorAllowed());
    }

    protected boolean isEditorAllowed() {
        return true;
    }

    public void updateCompile(boolean bl, String string) {
        if (this.dynamicEditor == null) {
            return;
        }
        if (!this.dynamicEditor.setCompileResults(bl, string)) {
            if (bl) {
                Common.showMessage("Compile Results", string, this);
                this.setButtons(true, true, true, false, false, true, true, true);
            } else {
                MessageDialog messageDialog = new MessageDialog(this, "Compiler Results", string);
                messageDialog.show();
                this.setButtons(true, true, true, false, false, false, true, false);
            }
        }
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.isSaved = !bl4;
    }

    private Language getDefaultLanguage() {
        Integer n = new Integer(0);
        HashMap hashMap = this.parentFrame.getModel().getUserInfo().getPreferences();
        if (hashMap.containsKey(n)) {
            if ((Integer)hashMap.get(n) == 0) {
                return JavaLanguage.JAVA_LANGUAGE;
            }
            return BaseLanguage.getLanguage((int)((Integer)hashMap.get(n)));
        }
        return JavaLanguage.JAVA_LANGUAGE;
    }

    protected String getDefaultEditor() {
        String string = PluginManager.getInstance().getDefaultEditorName();
        if (!string.equals("")) {
            return string;
        }
        return "Standard";
    }

    private void setLanguage(Language language) {
        if (language.getId() == 0) {
            language = this.getDefaultLanguage();
        }
        if (language.getId() == 1 && this.javaRadioButton.isVisible()) {
            this.javaRadioButton.setSelected(true);
        } else if (language.getId() == 3 && this.cplusplusRadioButton.isVisible()) {
            this.cplusplusRadioButton.setSelected(true);
        } else if (language.getId() == 4 && this.csharpRadioButton.isVisible()) {
            this.csharpRadioButton.setSelected(true);
        } else if (language.getId() == 5 && this.vbRadioButton.isVisible()) {
            this.vbRadioButton.setSelected(true);
        } else if (language.getId() == 6 && this.pythonRadioButton.isVisible()) {
            this.pythonRadioButton.setSelected(true);
        } else if (this.javaRadioButton.isVisible()) {
            language = JavaLanguage.JAVA_LANGUAGE;
            this.javaRadioButton.setSelected(true);
        } else if (this.cplusplusRadioButton.isVisible()) {
            language = CPPLanguage.CPP_LANGUAGE;
            this.cplusplusRadioButton.setSelected(true);
        } else if (this.csharpRadioButton.isVisible()) {
            language = CSharpLanguage.CSHARP_LANGUAGE;
            this.csharpRadioButton.setSelected(true);
        } else {
            language = JavaLanguage.JAVA_LANGUAGE;
        }
        this.currentLanguage = language;
    }

    public int getLanguage() {
        int n = 1;
        if (this.javaRadioButton.isSelected()) {
            n = 1;
        } else if (this.cplusplusRadioButton.isSelected()) {
            n = 3;
        } else if (this.csharpRadioButton.isSelected()) {
            n = 4;
        } else if (this.vbRadioButton.isSelected()) {
            n = 5;
        } else if (this.pythonRadioButton.isSelected()) {
            n = 6;
        }
        return n;
    }

    public void updateLanguageButtonStatus() {
        RoundProperties roundProperties = this.getRoomModel().getRoundModel().getRoundProperties();
        this.javaRadioButton.setEnabled(roundProperties.allowsLanguage((Language)JavaLanguage.JAVA_LANGUAGE));
        this.cplusplusRadioButton.setEnabled(roundProperties.allowsLanguage((Language)CPPLanguage.CPP_LANGUAGE));
        this.csharpRadioButton.setEnabled(roundProperties.allowsLanguage((Language)CSharpLanguage.CSHARP_LANGUAGE));
        this.vbRadioButton.setEnabled(roundProperties.allowsLanguage((Language)VBLanguage.VB_LANGUAGE));
        this.pythonRadioButton.setEnabled(roundProperties.allowsLanguage((Language)PythonLanguage.PYTHON_LANGUAGE));
    }

    public void setEditor(String string, String string2) {
        EditorPlugin editorPlugin;
        if (string2 == null) {
            String string3 = string2 = this.dynamicEditor == null ? "" : this.getSourceCode();
        }
        if (this.dynamicEditor != null) {
            PluginManager.getInstance().disposeEditor(this.dynamicEditor);
        }
        if (this.dynamicEditor != null) {
            this.unsetupKeyListener(this.kl, this.dynamicEditor.getEditorPanel());
        }
        if ((editorPlugin = (EditorPlugin)this.editorDefs.get(string)) == null) {
            Common.showMessage("Unknown Editor", "Your default editor points to a non existing editor.  Switching to 'Standard' editor instead", this);
            string = "Standard";
        }
        if (DEBUG) {
            System.out.println("SetEditor: " + string);
        }
        this.createDynamicEditor(string);
        this.editorPanel.removeAll();
        JPanel jPanel = this.dynamicEditor.getEditorPanel();
        if (jPanel != null) {
            jPanel.setRequestFocusEnabled(true);
        }
        if (jPanel != null) {
            this.editorPanel.add(jPanel);
        }
        this.setupKeyListener(this.kl, jPanel);
        this.editorPanel.invalidate();
        this.editorPanel.repaint();
        ProblemComponentRenderer problemComponentRenderer = new ProblemComponentRenderer(this.component.getComponent());
        problemComponentRenderer.setForegroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore"));
        problemComponentRenderer.setBackgroundColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.problemback"));
        String string4 = null;
        String string5 = null;
        try {
            string4 = problemComponentRenderer.toHTML(this.currentLanguage);
            string5 = problemComponentRenderer.toPlainText(this.currentLanguage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string6 = this.component.getClassName();
        String string7 = this.component.getMethodName();
        DataType[] dataTypeArray = this.component.getParamTypes();
        DataType dataType = this.component.getReturnType();
        this.problemPane.setText(string4);
        this.problemPane.setCaretPosition(0);
        this.problemPanel.updateComponentInfo(this.component, this.getCurrentLanguageId());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dataTypeArray.length; ++i) {
            arrayList.add(dataTypeArray[i].getDescriptor(this.getCurrentLanguageId()));
        }
        this.dynamicEditor.setLanguage(new Integer(this.getCurrentLanguageId()));
        this.dynamicEditor.setProblem(string5);
        this.dynamicEditor.setSignature(string6, string7, arrayList, dataType.getDescriptor(this.currentLanguage));
        this.dynamicEditor.setProblemComponent(this.component, this.currentLanguage, (Renderer)problemComponentRenderer);
        this.dynamicEditor.setSource(string2);
    }

    private void createDynamicEditor(final String string) {
        if (DEBUG) {
            System.out.println("CreateDynamicEditor: " + string);
        }
        if (!this.editorList.getSelectedItem().equals(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodingFrame.this.ignoreToggleEvent = true;
                    CodingFrame.this.editorList.setSelectedItem(string);
                    CodingFrame.this.ignoreToggleEvent = false;
                }
            });
        }
        try {
            this.dynamicEditor = PluginManager.getInstance().getEditor(string);
        }
        catch (InstantiationError instantiationError) {
            if (string.equals("Standard")) {
                Common.showMessage("Major Error", "Could not instantiate the STANDARD editor - Something is definately whacko", this);
            } else {
                Common.showMessage("Instantiation Error", "Could not instantiate the editor " + string + " (see the java console for details).  Switching to 'Standard' editor instead", this);
                this.createDynamicEditor("Standard");
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (string.equals("Standard")) {
                Common.showMessage("Major Error", "Could not instantiate the STANDARD editor - Something is definately whacko", this);
            }
            Common.showMessage("Editor Plugin Error", "The editor " + string + " does not implement the required methods for an editor plugin.  Switching to 'Standard' editor instead", this);
            this.createDynamicEditor("Standard");
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    private void editorToggleEvent() {
        if (DEBUG) {
            System.out.println("editorToggleEvent: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        this.setEditor((String)this.editorList.getSelectedItem(), null);
    }

    private void languageToggleEvent(ActionEvent actionEvent) {
        if (DEBUG) {
            System.out.println("languageToggleEvent: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        String string = actionEvent.getActionCommand();
        int n = this.getCurrentLanguageId();
        JavaLanguage javaLanguage = null;
        if (string.equals("Java")) {
            javaLanguage = JavaLanguage.JAVA_LANGUAGE;
        } else if (string.equals("C++")) {
            javaLanguage = CPPLanguage.CPP_LANGUAGE;
        } else if (string.equals("C#")) {
            javaLanguage = CSharpLanguage.CSHARP_LANGUAGE;
        } else if (string.equals("VB")) {
            javaLanguage = VBLanguage.VB_LANGUAGE;
        } else if (string.equals("Python")) {
            javaLanguage = PythonLanguage.PYTHON_LANGUAGE;
        } else {
            throw new RuntimeException("unknown language: " + string);
        }
        if (javaLanguage.getId() == n) {
            return;
        }
        this.setLanguage((Language)javaLanguage);
        this.setEditor((String)this.editorList.getSelectedItem(), null);
    }

    private void saveButtonEvent() {
        this.isSaved = true;
        this.parentFrame.setCurrentFrame(this);
        this.save();
    }

    private void save() {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Saving code...", this, 34);
            this.parentFrame.getRequester().requestSave(this.getComponentId(), this.getSourceCode(), this.getCurrentLanguageId());
        }
    }

    protected long getComponentId() {
        return this.component.getID();
    }

    protected int getCurrentLanguageId() {
        return this.currentLanguage.getId();
    }

    private void clearButtonEvent() {
        if (this.enabled && Common.confirm("Warning", "Are you sure you want to delete your source code?", this)) {
            this.dynamicEditor.clear();
            this.setButtons(false, false, false, false, false, false, false, false);
        }
    }

    private void compileButtonEvent() {
        if (this.enabled) {
            this.setButtons(false, false, false, false, false, false, false, false);
            this.parentFrame.setCurrentFrame(this);
            this.compiledSource = this.getSourceCode();
            this.parentFrame.getInterFrame().showMessage("Compiling...", this, 4);
            this.parentFrame.getRequester().requestCompile(this.compiledSource, this.getLanguage(), this.getComponentId());
        }
    }

    protected String getSourceCode() {
        return this.dynamicEditor.getSource();
    }

    private void testButtonEvent() {
        if (this.enabled) {
            this.setButtons(false, false, false, false, false, false, false, false);
            this.parentFrame.setCurrentFrame(this);
            this.parentFrame.getRequester().requestTestInfo(this.getComponentId());
        }
    }

    private void submitButtonEvent() {
        if (!this.enabled) {
            return;
        }
        String string = this.getSourceCode();
        if (!string.equals(this.compiledSource) && !Common.confirm("Warning", "You have made a change to your code since the last time you compiled.  Do you want to continue with the submit?", this)) {
            return;
        }
        if (Common.confirm("Warning", "Would you like to submit your code ?", this)) {
            if (this.pref.isTrue("com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled") && !this.parentFrame.getPoweredByView()) {
                try {
                    UCRProcessor uCRProcessor = UCRProcessorFactory.getProcessor((int)this.getCurrentLanguageId());
                    uCRProcessor.initialize(this.component.getClassName(), this.component.getMethodName(), string);
                    String string2 = uCRProcessor.checkCode();
                    if (!string2.equals("") && !Common.confirm("Warning", string2, this)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.parentFrame.setCurrentFrame(this);
            this.submit();
        }
    }

    private void submit() {
        if (this.enabled) {
            this.parentFrame.getInterFrame().showMessage("Submitting...", this, 14);
            this.parentFrame.getRequester().requestSubmitCode(this.getComponentId());
        }
    }

    private void closeCodingWindow() {
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseComponent(this.getComponentId(), this.parentFrame.getModel().getCurrentUser());
        }
        this.pref.setLocation(FRAMELOCATION, this.getLocation());
        this.pref.setSize(FRAMESIZE, this.getSize());
        this.pref.setProperty(DIVIDERLOC, String.valueOf(this.jsp.getDividerLocation()));
        try {
            this.pref.savePreferences();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateComponentSource(String string, Language language) {
        if (DEBUG) {
            System.out.println("updateComponentSource: " + (this.dynamicEditor == null ? "null" : this.dynamicEditor.getPlugin().getName()));
        }
        this.setLanguage(language);
        if (this.dynamicEditor == null) {
            this.setEditor(this.getDefaultEditor(), string);
        } else {
            this.setEditor((String)this.editorList.getSelectedItem(), string);
        }
    }

    public ProblemComponentModel getComponentModel() {
        return this.component;
    }

    protected ContestApplet getParentFrame() {
        return this.parentFrame;
    }

    public void setRoomModel(RoomModel roomModel) {
        this.roomModel = roomModel;
    }

    public RoomModel getRoomModel() {
        return this.roomModel;
    }

    class NoClipboardEditorPane
    extends JEditorPane {
        public NoClipboardEditorPane(String string, String string2) {
            super(string, string2);
            this.setHighlighter(null);
        }

        public void copy() {
        }

        public void cut() {
        }

        public void paste() {
        }

        public void replaceSelection(String string) {
        }

        public String getSelectedText() {
            return "";
        }

        public void setSelectionStart(int n) {
        }

        public void setSelectionEnd(int n) {
        }

        public void select(int n, int n2) {
        }

        public void selectAll() {
        }
    }

    protected static class ButtonDef {
        String image;
        String disabledImage;
        String toolTipText;
        String hotKeyPrefKey;
        ActionListener actionListener;

        public ButtonDef(String string, String string2, String string3, String string4, ActionListener actionListener) {
            this.image = string;
            this.disabledImage = string2;
            this.toolTipText = string3;
            this.hotKeyPrefKey = string4;
            this.actionListener = actionListener;
        }
    }
}

