/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.table.BroadcastSummaryPanel;
import com.topcoder.client.contestApplet.widgets.FillingOvalIcon;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BroadcastSummaryFrame
extends JFrame {
    private static BroadcastSummaryFrame singleton;
    private ContestApplet parentFrame = null;
    private BroadcastSummaryPanel summaryPanel = null;
    private boolean enabled = true;

    public static BroadcastSummaryFrame getInstance(ContestApplet contestApplet) {
        if (singleton == null) {
            singleton = new BroadcastSummaryFrame(contestApplet);
        }
        return singleton;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.summaryPanel.setPanelEnabled(bl);
    }

    private BroadcastSummaryFrame(ContestApplet contestApplet) {
        super("TopCoder Competition Arena - Broadcast Summary");
        this.parentFrame = contestApplet;
        this.create();
    }

    public void showFrame() {
        Common.setLocationRelativeTo((Component)this.parentFrame.getCurrentFrame(), this);
        this.show();
        MoveFocus.moveFocus(this.summaryPanel.getTable());
    }

    public void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.summaryPanel = new BroadcastSummaryPanel(this.parentFrame);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.summaryPanel.setPreferredSize(new Dimension(575, 250));
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        gridBagConstraints.fill = 2;
        Common.insertInPanel(this.createColorPanel(), this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.5, 0.0);
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(this.summaryPanel, this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 0.5, 1.0);
        this.pack();
    }

    public JPanel createColorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        FillingOvalIcon fillingOvalIcon = new FillingOvalIcon();
        fillingOvalIcon.setForeground(Common.CODER_BLUE);
        fillingOvalIcon.setPercentage(1.0);
        JLabel jLabel = new JLabel("General", fillingOvalIcon, 0);
        jLabel.setFont(new Font("", 1, 13));
        jLabel.setForeground(Common.CODER_BLUE);
        jLabel.setVerticalTextPosition(0);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setPreferredSize(new Dimension(60, 12));
        Common.insertInPanel(jLabel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        fillingOvalIcon = new FillingOvalIcon();
        fillingOvalIcon.setForeground(Common.CODER_RED);
        fillingOvalIcon.setPercentage(1.0);
        jLabel = new JLabel("Problem", fillingOvalIcon, 0);
        jLabel.setFont(new Font("", 1, 13));
        jLabel.setForeground(Common.CODER_RED);
        jLabel.setVerticalTextPosition(0);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setPreferredSize(new Dimension(60, 12));
        Common.insertInPanel(jLabel, jPanel2, gridBagConstraints, 1, 0, 1, 1, 0.1, 0.1);
        fillingOvalIcon = new FillingOvalIcon();
        fillingOvalIcon.setForeground(Common.CODER_GREEN);
        fillingOvalIcon.setPercentage(1.0);
        jLabel = new JLabel("Round", fillingOvalIcon, 0);
        jLabel.setForeground(Common.CODER_GREEN);
        jLabel.setFont(new Font("", 1, 13));
        jLabel.setVerticalTextPosition(0);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setPreferredSize(new Dimension(60, 12));
        Common.insertInPanel(jLabel, jPanel2, gridBagConstraints, 2, 0, 1, 1, 0.1, 0.1);
        jPanel2.setBackground(Color.black);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel2.setPreferredSize(new Dimension(0, 20));
        gridBagConstraints.insets = new Insets(-1, -1, -1, -1);
        jPanel.setBorder(Common.getTitledBorder("Legend"));
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        return jPanel;
    }
}

