/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.HyperLinkLoader;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import com.topcoder.netCommon.contestantMessages.ComponentBroadcast;
import com.topcoder.netCommon.contestantMessages.RoundBroadcast;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class BroadcastDialog
extends JFrame {
    private static final String[] genericBroadcastHeaders = new String[]{"Time"};
    private static final String[] roundBroadcastHeaders = new String[]{"Time", "Round"};
    private static final String[] problemBroadcastHeaders = new String[]{"Time", "Round", "Division", "Point Value", "Class", "Method", "Returns"};
    private AppletContext arenaContext;

    public BroadcastDialog(ContestApplet contestApplet, AdminBroadcast adminBroadcast) {
        this(contestApplet, adminBroadcast, true);
    }

    public BroadcastDialog(ContestApplet contestApplet, AdminBroadcast adminBroadcast, boolean bl) {
        String string;
        String[] stringArray;
        String[] stringArray2;
        String string2;
        Object object;
        super.setDefaultCloseOperation(2);
        contestApplet.getModel().getBroadcastManager().markBroadcastRead(adminBroadcast);
        this.arenaContext = contestApplet.getAppletContext();
        if (adminBroadcast instanceof ComponentBroadcast) {
            object = (ComponentBroadcast)adminBroadcast;
            string2 = "Problem Broadcast";
            stringArray2 = problemBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(object.getTime()), object.getRoundName(), "" + object.getDivision(), "" + object.getPointValue(), object.getClassName(), object.getMethodSignature(), object.getReturnType()};
            string = object.getMessage();
        } else if (adminBroadcast instanceof RoundBroadcast) {
            object = (RoundBroadcast)adminBroadcast;
            string2 = "Round Broadcast";
            stringArray2 = roundBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(object.getTime()), object.getRoundName()};
            string = object.getMessage();
        } else {
            string2 = "Admin Broadcast";
            stringArray2 = genericBroadcastHeaders;
            stringArray = new String[]{Common.formatTime(adminBroadcast.getTime())};
            string = adminBroadcast.getMessage();
        }
        super.setTitle(string2);
        object = Common.getDefaultConstraints();
        JPanel jPanel = this.createHeaderPanel(stringArray2, stringArray);
        JPanel jPanel2 = this.createMessagePane(string);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        object.insets = new Insets(5, 15, 5, 15);
        object.fill = 1;
        Common.insertInPanel(jPanel, this.getContentPane(), (GridBagConstraints)object, 0, 0, 1, 1, 1.0, 0.1);
        object.insets = new Insets(5, 15, 15, 15);
        Common.insertInPanel(jPanel2, this.getContentPane(), (GridBagConstraints)object, 0, 1, 1, 1, 0.1, 0.1);
        if (bl) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        BroadcastDialog.this.pack();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            this.pack();
        }
        Common.setLocationRelativeTo((Component)contestApplet.getCurrentFrame(), this);
        MoveFocus.moveFocus(this);
    }

    JPanel createHeaderPanel(String[] stringArray, String[] stringArray2) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(200 * stringArray2.length);
        int n = stringArray.length / 2;
        if (stringArray.length == 0) {
            n = -1;
        }
        for (int i = 0; i <= n; ++i) {
            String string2 = stringArray[i] + ":  " + stringArray2[i];
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        string = stringBuffer.toString();
        JTextArea[] jTextAreaArray = new JTextArea[2];
        jTextAreaArray[0] = new JTextArea(string);
        jTextAreaArray[0].setEditable(false);
        stringBuffer.setLength(0);
        for (int i = n + 1; i < stringArray.length; ++i) {
            String string3 = stringArray[i] + ":  " + stringArray2[i];
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        }
        string = stringBuffer.toString();
        jTextAreaArray[1] = new JTextArea(string);
        jTextAreaArray[1].setEditable(false);
        return Common.createColumnarMessagePanel("Broadcast Information", jTextAreaArray, 260, 11 * (stringArray.length + 2));
    }

    JPanel createMessagePane(String string) {
        JEditorPane jEditorPane = new JEditorPane("text/html", Common.htmlEncode(string));
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperLinkLoader(this.arenaContext));
        return Common.createMessagePanel("Broadcast Message", jEditorPane, 300, 200, Common.BG_COLOR);
    }
}

