/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.DummySortedTableModel;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.table.ArrayListInputPanel;
import com.topcoder.client.contestApplet.widgets.ContestListCellRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public final class ArrayListInputDialog
extends JDialog {
    private ArrayListInputPanel alip = null;
    private ArrayList info = null;
    private JList list = null;
    private DefaultListModel model = null;
    private JTextField jtf = null;
    private JButton addButton = null;
    private boolean status = false;
    private final int START = 0;
    private final int IN_QUOTE = 1;
    private final int ESCAPE = 2;

    public ArrayListInputDialog(JDialog jDialog, ArrayList arrayList, String string) {
        super(jDialog, string + " Problem Argument", true);
        ArrayListInputPanel arrayListInputPanel;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.alip = arrayListInputPanel = new ArrayListInputPanel(string, new EditableModel());
        JTable jTable = arrayListInputPanel.getTable();
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            ((ContestTableCellRenderer)jTable.getColumnModel().getColumn(i).getCellRenderer()).setEnableBlankDisplay(true);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.info = arrayList;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.setBorder(Common.getTitledBorder(string));
        this.list.setCellRenderer(new ContestListCellRenderer());
        for (int i = 0; i < this.info.size(); ++i) {
            arrayListInputPanel.addElement((String)this.info.get(i));
            this.model.addElement(this.info.get(i));
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(jScrollPane, jPanel, gridBagConstraints, 0, 0, 1, 1, 1.0, 0.1);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.jtf = new JTextField();
        this.addButton = new JButton("+");
        JButton jButton = new JButton("++");
        JButton jButton2 = new JButton("{}");
        JButton jButton3 = new JButton("-");
        JButton jButton4 = new JButton("^");
        JButton jButton5 = new JButton("v");
        JButton jButton6 = new JButton("C");
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        Common.insertInPanel(this.jtf, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1.0, 0.1);
        Common.insertInPanel(jButton4, jPanel3, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jButton5, jPanel3, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.addButton, jPanel3, gridBagConstraints, 2, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jButton, jPanel3, gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jButton2, jPanel3, gridBagConstraints, 4, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jButton3, jPanel3, gridBagConstraints, 5, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jButton6, jPanel3, gridBagConstraints, 6, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jPanel3, jPanel2, gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        jPanel2.setPreferredSize(new Dimension(0, 40));
        jPanel2.setMinimumSize(new Dimension(0, 40));
        jPanel2.setOpaque(false);
        jPanel3.setPreferredSize(new Dimension(0, 25));
        jPanel3.setMinimumSize(new Dimension(0, 25));
        jPanel3.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel3.setOpaque(false);
        JButton jButton7 = new JButton("OK");
        JButton jButton8 = new JButton("Cancel");
        jButton7.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton7);
        this.jtf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.inputEvent();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.upButtonEvent();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.downButtonEvent();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.addButtonEvent();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.superAddButtonEvent();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.bracketAddButtonEvent();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.removeButtonEvent();
            }
        });
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.clearButtonEvent();
            }
        });
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.okButtonEvent();
            }
        });
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayListInputDialog.this.cancelButtonEvent();
            }
        });
        jButton4.setToolTipText("Shift the selected element up one position.");
        jButton5.setToolTipText("Shift the selected element down one position.");
        this.addButton.setToolTipText("Add a new element to the array.");
        jButton.setToolTipText("Add a comma delimited set of elements to the array.");
        jButton3.setToolTipText("Remove the selected element from the array.");
        jButton6.setToolTipText("Remove all the elements from the array.");
        jPanel4.add(jButton7);
        jPanel4.add(jButton8);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        Common.insertInPanel(arrayListInputPanel, this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.1, 1.0);
        Common.insertInPanel(jPanel2, this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 0.1, 0.1);
        Common.insertInPanel(jPanel4, this.getContentPane(), gridBagConstraints, 0, 2, 1, 1, 0.1, 0.1);
        this.getRootPane().setPreferredSize(new Dimension(340, 250));
        this.getRootPane().setMinimumSize(new Dimension(340, 250));
        this.pack();
        this.setResizable(true);
        Common.setLocationRelativeTo((Component)jDialog, this);
    }

    public ArrayList showDialog() {
        this.jtf.requestFocus();
        this.show();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(2);
        arrayList.add(new Boolean(this.status));
        arrayList.add(this.info);
        return arrayList;
    }

    private void inputEvent() {
        this.endEditing();
        this.addButton.doClick();
    }

    private void upButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", this);
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", this);
        } else {
            if (n == 0) {
                return;
            }
            this.alip.getTableModel().swapRows(n - 1, n);
            this.alip.getTable().setRowSelectionInterval(n - 1, n - 1);
            this.alip.getTable().getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }
    }

    private void downButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", this);
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", this);
        } else {
            if (n >= n2 - 1) {
                return;
            }
            this.alip.getTableModel().swapRows(n + 1, n);
            this.alip.getTable().setRowSelectionInterval(n + 1, n + 1);
            this.alip.getTable().getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }
    }

    private void addButtonEvent() {
        this.endEditing();
        if (this.model.size() >= 50) {
            Common.showMessage("Error", "You have exceeded the max array size of 50 elements.", this);
        } else if (this.jtf.getText().length() > 50) {
            Common.showMessage("Error", "You have exceeded the max argument size of 50 characters.", this);
        } else {
            this.alip.addElement(this.jtf.getText());
            this.model.addElement(this.jtf.getText());
            this.jtf.setText("");
        }
        MoveFocus.moveFocus(this.jtf);
    }

    private void superAddButtonEvent() {
        this.endEditing();
        StringTokenizer stringTokenizer = new StringTokenizer(this.jtf.getText(), ",", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ",";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string.equals(",") && string2.equals(",")) {
                arrayList.add("");
            }
            if (string2.equals(",") && !stringTokenizer.hasMoreTokens()) {
                arrayList.add("");
            }
            if (!string2.equals(",")) {
                arrayList.add(string2);
            }
            string = string2;
        }
        if (this.model.size() + arrayList.size() > 50) {
            Common.showMessage("Error", "You have exceeded the max array size of 50 elements. Please eliminate some of your elements", this);
            return;
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.length() > 50) {
                bl = true;
                continue;
            }
            this.alip.addElement(string3);
            this.model.addElement(string3);
        }
        if (bl) {
            Common.showMessage("Warning", "One or more entries were ignored because they were either empty (blank) or had a size greater than 50..", this);
        }
        this.jtf.setText("");
        MoveFocus.moveFocus(this.jtf);
    }

    private void removeButtonEvent() {
        this.endEditing();
        int n = this.alip.getTable().getSelectedRow();
        int[] nArray = this.alip.getTable().getSelectedRows();
        int n2 = this.alip.getTable().getRowCount();
        if (n == -1 && n2 == 0) {
            Common.showMessage("", "The list is empty", this);
        } else if (n == -1) {
            Common.showMessage("", "Please select an element from the list", this);
        } else {
            int n3;
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                this.alip.removeElement(nArray[n3]);
                this.model.removeElementAt(nArray[n3]);
            }
            n3 = this.alip.getTable().getRowCount();
            if (n < n3 - 1) {
                this.alip.getTable().setRowSelectionInterval(n, n);
                this.alip.getTable().getSelectionModel().setSelectionInterval(n, n);
            } else if (n3 > 0) {
                this.alip.getTable().setRowSelectionInterval(n3 - 1, n3 - 1);
                this.alip.getTable().getSelectionModel().setSelectionInterval(n3 - 1, n3 - 1);
            }
        }
    }

    private void clearButtonEvent() {
        this.alip.clear();
        this.model.removeAllElements();
    }

    private void okButtonEvent() {
        this.endEditing();
        if (!this.jtf.getText().equals("")) {
            if (JOptionPane.showConfirmDialog(this, "You have un-saved information entered.  Do you wish to add it and continue?", "Warning", 0, 2) == 0) {
                this.addButton.doClick();
            } else {
                return;
            }
        }
        this.info.clear();
        SortedTableModel sortedTableModel = this.alip.getTableModel();
        for (int i = 0; i < sortedTableModel.getRowCount(); ++i) {
            this.info.add(sortedTableModel.getValueAt(i, 0));
        }
        this.status = true;
        this.dispose();
    }

    private void cancelButtonEvent() {
        this.status = false;
        this.dispose();
    }

    private void endEditing() {
        TableCellEditor tableCellEditor;
        if (this.alip.getTable().isEditing() && (tableCellEditor = this.alip.getTable().getCellEditor(this.alip.getTable().getEditingRow(), this.alip.getTable().getEditingColumn())) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void bracketAddButtonEvent() {
        this.endEditing();
        String string = this.jtf.getText();
        string = string.trim();
        if (string.length() > 0 && string.charAt(0) == '{') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '}') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() != 0) {
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(50);
            block17: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (n) {
                    case 2: {
                        switch (c) {
                            case '\\': {
                                stringBuffer.append('\\');
                                break;
                            }
                            case '\"': {
                                stringBuffer.append('\"');
                                break;
                            }
                            default: {
                                stringBuffer.append('\\');
                                stringBuffer.append(c);
                            }
                        }
                        n = 1;
                        continue block17;
                    }
                    case 1: {
                        String string2;
                        switch (c) {
                            case '\\': {
                                n = 2;
                                continue block17;
                            }
                            case '\"': {
                                string2 = stringBuffer.toString();
                                stringBuffer.delete(0, stringBuffer.length());
                                n = 0;
                                if (string2.length() > 50) {
                                    bl = true;
                                    continue block17;
                                }
                                this.alip.addElement(string2);
                                this.model.addElement(string2);
                                continue block17;
                            }
                        }
                        stringBuffer.append(c);
                        continue block17;
                    }
                    case 0: {
                        String string2;
                        if (Character.isWhitespace(c)) {
                            if (stringBuffer.length() <= 0) continue block17;
                            string2 = stringBuffer.toString().trim();
                            stringBuffer.delete(0, stringBuffer.length());
                            if (string2.length() > 50) {
                                bl = true;
                                continue block17;
                            }
                            this.alip.addElement(string2);
                            this.model.addElement(string2);
                            continue block17;
                        }
                        switch (c) {
                            case '\"': {
                                if (stringBuffer.length() > 0) {
                                    stringBuffer.append('\"');
                                    continue block17;
                                }
                                n = 1;
                                continue block17;
                            }
                            case ',': {
                                if (stringBuffer.length() <= 0 && i != 0 && (i <= 0 || string.charAt(i - 1) != ',')) continue block17;
                                string2 = stringBuffer.toString().trim();
                                stringBuffer.delete(0, stringBuffer.length());
                                if (string2.length() > 50) {
                                    bl = true;
                                    continue block17;
                                }
                                this.alip.addElement(string2);
                                this.model.addElement(string2);
                                continue block17;
                            }
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            if (stringBuffer.length() > 0 || string.charAt(string.length() - 1) == ',') {
                String string3 = stringBuffer.toString().trim();
                stringBuffer.delete(0, stringBuffer.length());
                if (string3.length() > 50) {
                    bl = true;
                } else {
                    this.alip.addElement(string3);
                    this.model.addElement(string3);
                }
            }
            if (bl) {
                Common.showMessage("Warning", "One or more entries were ignored because they were either empty (blank) or had a size greater than 50..", this);
            }
        }
        this.jtf.setText("");
        MoveFocus.moveFocus(this.jtf);
    }

    private class EditableModel
    extends DummySortedTableModel {
        ArrayList l = new ArrayList();

        public EditableModel() {
            this.setZeroAllowed(true);
        }

        public int getRowCount() {
            return this.l.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.l.set(n, object);
            this.fireTableRowsUpdated(n, n);
        }

        public Object getValueAt(int n, int n2) {
            return this.l.get(n);
        }

        public void add(Object object) {
            this.l.add(object);
            this.fireTableRowsInserted(this.l.size() - 1, this.l.size() - 1);
        }

        public Object remove(int n) {
            Object e = this.l.remove(n);
            this.fireTableRowsDeleted(n, n);
            return e;
        }

        public void swapRows(int n, int n2) {
            Object e = this.l.get(n);
            this.l.set(n, this.l.get(n2));
            this.l.set(n2, e);
            this.fireTableRowsUpdated(Math.min(n, n2), Math.max(n, n2));
        }

        public void clear() {
            this.l.clear();
            this.fireTableDataChanged();
        }
    }
}

