/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.CodingFrame;
import com.topcoder.client.contestApplet.frames.ConfirmInputDialog;
import com.topcoder.client.contestApplet.frames.SourceViewer;
import com.topcoder.client.contestApplet.widgets.MouseLessTextArea;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.netCommon.contest.Matrix2D;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.TestCase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class ArgInputDialog
extends JDialog {
    private ArrayList originalArgs = null;
    private ArrayList fields = null;
    private ArrayList info = null;
    private DataType[] params = null;
    private Hashtable buttons = null;
    private boolean status = false;
    private boolean confirm = false;
    private JFrame frame;
    private ProblemComponentModel probComponent = null;
    private JButton[] buttonsByIndex = null;
    private final int START = 0;
    private final int IN_QUOTE = 1;
    private final int ESCAPE = 2;

    public ArgInputDialog(JFrame jFrame, DataType[] dataTypeArray, boolean bl) {
        this(jFrame, dataTypeArray, null, bl);
    }

    public ArgInputDialog(JFrame jFrame, String string, DataType[] dataTypeArray, boolean bl) {
        this(jFrame, dataTypeArray, string, null, bl, null);
    }

    public ArgInputDialog(JFrame jFrame, String string, DataType[] dataTypeArray, boolean bl, String[] stringArray) {
        this(jFrame, dataTypeArray, string, null, bl, null);
    }

    public ArgInputDialog(JFrame jFrame, DataType[] dataTypeArray, ArrayList arrayList, boolean bl) {
        this(jFrame, dataTypeArray, null, arrayList, bl, null);
    }

    public ArgInputDialog(JFrame jFrame, DataType[] dataTypeArray, String string, ArrayList arrayList, boolean bl, ProblemComponentModel problemComponentModel) {
        this(jFrame, dataTypeArray, string, arrayList, bl, problemComponentModel, 1);
    }

    public ArgInputDialog(JFrame jFrame, DataType[] dataTypeArray, String string, ArrayList arrayList, boolean bl, ProblemComponentModel problemComponentModel, int n) {
        super(jFrame, "Problem Arguments", false);
        String[] stringArray;
        JComponent jComponent;
        JComponent jComponent2;
        this.confirm = bl;
        this.frame = jFrame;
        this.params = dataTypeArray;
        this.fields = new ArrayList(dataTypeArray.length);
        this.info = new ArrayList(2);
        this.buttons = new Hashtable();
        this.originalArgs = arrayList;
        this.probComponent = problemComponentModel;
        String[] stringArray2 = problemComponentModel.getParamNames();
        MouseLessTextArea mouseLessTextArea = null;
        JPanel jPanel = null;
        int n2 = 0;
        if (string != null) {
            n2 = 100;
            mouseLessTextArea = new MouseLessTextArea(string);
            jPanel = Common.createMessagePanel("Instructions", mouseLessTextArea, 0, n2, Common.BG_COLOR);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Common.WPB_COLOR);
        jPanel2.setLayout(new GridLayout(dataTypeArray.length, 2));
        Font font = new Font("Courier", 0, 10);
        if (arrayList != null && arrayList.size() != dataTypeArray.length) {
            arrayList = null;
        }
        this.buttonsByIndex = new JButton[dataTypeArray.length];
        for (int i = 0; i < dataTypeArray.length; ++i) {
            jComponent2 = new JLabel("(" + (i + 1) + ") " + dataTypeArray[i].getDescriptor(n) + " " + stringArray2[i]);
            jComponent2.setForeground(Color.white);
            jComponent2.setBackground(Common.WPB_COLOR);
            jComponent2.setFont(font);
            jPanel2.add(jComponent2);
            if (dataTypeArray[i].getDescription().equals("ArrayList") || dataTypeArray[i].getDescription().startsWith("vector") || dataTypeArray[i].getDescription().endsWith("[]")) {
                jComponent = new JButton(arrayList == null ? "create" : "modify");
                jComponent.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ArgInputDialog.this.alButtonEvent(actionEvent);
                    }
                });
                jComponent.setActionCommand(dataTypeArray[i].getDescriptor(n));
                this.buttons.put(jComponent, new Integer(i));
                this.buttonsByIndex[i] = jComponent;
                this.fields.add(arrayList == null ? new ArrayList() : (ArrayList)arrayList.get(i));
                jPanel2.add(jComponent);
                continue;
            }
            jComponent = new JTextField(arrayList == null ? "" : (String)arrayList.get(i));
            this.fields.add(jComponent);
            jPanel2.add(jComponent);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBackground(Common.WPB_COLOR);
        jComponent2 = new JButton("OK");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArgInputDialog.this.okButtonEvent();
            }
        });
        jPanel3.add(jComponent2);
        ((JButton)jComponent2).setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)jComponent2);
        jComponent = new JButton("Cancel");
        jComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArgInputDialog.this.cancelButtonEvent();
            }
        });
        jPanel3.add(jComponent);
        JComboBox<String> jComboBox = null;
        if (problemComponentModel != null && problemComponentModel.hasTestCases()) {
            int n3;
            TestCase[] testCaseArray = problemComponentModel.getTestCases();
            stringArray = new String[testCaseArray.length + 1];
            stringArray[0] = "Select Example...";
            for (n3 = 1; n3 < stringArray.length; ++n3) {
                stringArray[n3] = "Example " + (n3 - 1);
            }
            jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setBackground(Common.WPB_COLOR);
            jComboBox.setForeground(Color.white);
            if (arrayList != null) {
                block2: for (n3 = 0; n3 < testCaseArray.length; ++n3) {
                    String[] stringArray3 = testCaseArray[n3].getInput();
                    for (int i = 0; i < dataTypeArray.length; ++i) {
                        Object object;
                        if (dataTypeArray[i].getDescription().equals("ArrayList") || dataTypeArray[i].getDescription().startsWith("vector") || dataTypeArray[i].getDescription().endsWith("[]")) {
                            object = (ArrayList)arrayList.get(i);
                            if (((ArrayList)object).equals(this.bracketParse(stringArray3[i]))) continue;
                            continue block2;
                        }
                        object = (String)arrayList.get(i);
                        String string2 = null;
                        string2 = dataTypeArray[i].getDescription().equalsIgnoreCase("string") || dataTypeArray[i].getDescription().equals("char") ? stringArray3[i].substring(1, stringArray3[i].length() - 1) : stringArray3[i];
                        if (!((String)object).equals(string2)) continue block2;
                    }
                    jComboBox.setSelectedIndex(n3 + 1);
                    break;
                }
            }
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    ArgInputDialog.this.loadExample(jComboBox.getSelectedIndex() - 1);
                }
            });
        }
        int n4 = 0;
        stringArray = Common.getDefaultConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        if (string != null) {
            stringArray.insets = new Insets(5, 15, 0, 15);
            stringArray.fill = 1;
            Common.insertInPanel(jPanel, this.getContentPane(), (GridBagConstraints)stringArray, 0, n4++, 1, 1, 0.1, 1.0);
        }
        stringArray.insets = new Insets(15, 15, 15, 15);
        stringArray.fill = 2;
        Common.insertInPanel(jPanel2, this.getContentPane(), (GridBagConstraints)stringArray, 0, n4++, 1, 1, 0.1, 0.1);
        stringArray.fill = 0;
        if (jComboBox != null) {
            Common.insertInPanel(jComboBox, this.getContentPane(), (GridBagConstraints)stringArray, 0, n4++, 1, 1, 0.1, 0.1);
        }
        Common.insertInPanel(jPanel3, this.getContentPane(), (GridBagConstraints)stringArray, 0, n4++, 1, 1, 0.1, 0.1);
        this.getRootPane().setPreferredSize(new Dimension(340, n2 + 60 + 65 + 33 * dataTypeArray.length + (problemComponentModel != null ? 60 : 0) - 50));
        this.getRootPane().setMinimumSize(new Dimension(340, n2 + 60 + 65 + 33 * dataTypeArray.length + (problemComponentModel != null ? 60 : 0) - 50));
        this.pack();
        this.setResizable(false);
        Common.setLocationRelativeTo((Component)jFrame, this);
    }

    public void showDialog() {
        this.show();
    }

    private void alButtonEvent(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        ArrayList arrayList = null;
        if (!jButton.getText().equals("create")) {
            ArrayList arrayList2 = (ArrayList)this.fields.get((Integer)this.buttons.get(jButton));
        }
        if (((Boolean)arrayList.get(0)).booleanValue()) {
            jButton.setText("modify");
            this.fields.set((Integer)this.buttons.get(jButton), arrayList.get(1));
        }
    }

    private void okButtonEvent() {
        ConfirmInputDialog confirmInputDialog;
        ArrayList<String> arrayList = new ArrayList<String>(this.params.length);
        for (int i = 0; i < this.fields.size(); ++i) {
            Object e = this.fields.get(i);
            if (e instanceof JTextField) {
                arrayList.add(i, ((JTextField)e).getText());
                continue;
            }
            if (e instanceof ArrayList) {
                arrayList.add(i, (String)e);
                continue;
            }
            if (!(e instanceof Matrix2D)) continue;
            arrayList.add(i, (String)e);
        }
        if (this.confirm && !(confirmInputDialog = new ConfirmInputDialog(this.frame, this.params, arrayList)).showDialog()) {
            return;
        }
        this.info = arrayList;
        this.status = true;
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>(2);
        arrayList2.add(new Boolean(this.status));
        arrayList2.add(this.info);
        if (this.frame instanceof SourceViewer) {
            ((SourceViewer)this.frame).doChallengeRequest(arrayList2);
        } else if (this.frame instanceof CodingFrame) {
            ((CodingFrame)this.frame).doTest(arrayList2);
        }
        this.dispose();
    }

    private void cancelButtonEvent() {
        this.status = false;
        ArrayList<String> arrayList = new ArrayList<String>(this.params.length);
        for (int i = 0; i < this.fields.size(); ++i) {
            Object e = this.fields.get(i);
            if (e instanceof JTextField) {
                if (((JTextField)e).getText().length() > 50) {
                    Common.showMessage("Error", "You have entered " + ((JTextField)e).getText().length() + " characters. Please limit your argument size to 50 characters.", this);
                    MoveFocus.moveFocus((JTextField)e);
                    return;
                }
                arrayList.add(i, ((JTextField)e).getText());
                continue;
            }
            if (e instanceof ArrayList) {
                arrayList.add(i, (String)e);
                continue;
            }
            if (!(e instanceof Matrix2D)) continue;
            arrayList.add(i, (String)e);
        }
        this.info = arrayList;
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>(2);
        arrayList2.add(new Boolean(this.status));
        arrayList2.add(this.info);
        if (this.frame instanceof SourceViewer) {
            ((SourceViewer)this.frame).doChallengeRequest(arrayList2);
        } else if (this.frame instanceof CodingFrame) {
            ((CodingFrame)this.frame).doTest(arrayList2);
        }
        this.dispose();
    }

    private void loadExample(int n) {
        if (this.probComponent == null || n < 0 || n >= this.probComponent.getTestCases().length) {
            return;
        }
        String[] stringArray = this.probComponent.getTestCases()[n].getInput();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.params[i].getDescription().equals("ArrayList") || this.params[i].getDescription().startsWith("vector") || this.params[i].getDescription().endsWith("[]")) {
                this.buttonsByIndex[i].setText("modify");
                this.fields.set(i, this.bracketParse(stringArray[i]));
                continue;
            }
            JTextField jTextField = (JTextField)this.fields.get(i);
            if (this.params[i].getDescription().equalsIgnoreCase("string")) {
                ArrayList arrayList = this.bracketParse(stringArray[i]);
                jTextField.setText((String)arrayList.get(0));
                continue;
            }
            if (this.params[i].getDescription().equals("char")) {
                jTextField.setText(stringArray[i].substring(1, stringArray[i].length() - 1));
                continue;
            }
            jTextField.setText(stringArray[i]);
        }
    }

    private ArrayList bracketParse(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((string = string.trim()).length() > 0 && string.charAt(0) == '{') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '}') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            return arrayList;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(50);
        block17: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 2: {
                    switch (c) {
                        case '\\': {
                            stringBuffer.append('\\');
                            break;
                        }
                        case '\"': {
                            stringBuffer.append('\"');
                            break;
                        }
                        default: {
                            stringBuffer.append('\\');
                            stringBuffer.append(c);
                        }
                    }
                    n = 1;
                    continue block17;
                }
                case 1: {
                    String string2;
                    switch (c) {
                        case '\\': {
                            n = 2;
                            break;
                        }
                        case '\"': {
                            string2 = stringBuffer.toString();
                            stringBuffer.delete(0, stringBuffer.length());
                            n = 0;
                            if (string2.length() > 50) break;
                            arrayList.add(string2);
                            break;
                        }
                        default: {
                            stringBuffer.append(c);
                            break;
                        }
                    }
                    continue block17;
                }
                case 0: {
                    String string2;
                    if (Character.isWhitespace(c)) {
                        if (stringBuffer.length() <= 0) continue block17;
                        string2 = stringBuffer.toString().trim();
                        stringBuffer.delete(0, stringBuffer.length());
                        if (string2.length() > 50) continue block17;
                        arrayList.add(string2);
                        continue block17;
                    }
                    switch (c) {
                        case '\"': {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append('\"');
                                continue block17;
                            }
                            n = 1;
                            continue block17;
                        }
                        case ',': {
                            if (stringBuffer.length() <= 0 && i != 0 && (i <= 0 || string.charAt(i - 1) != ',')) continue block17;
                            string2 = stringBuffer.toString().trim();
                            stringBuffer.delete(0, stringBuffer.length());
                            if (string2.length() > 50) continue block17;
                            arrayList.add(string2);
                            continue block17;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
            }
        }
        if (stringBuffer.length() > 0 || string.charAt(string.length() - 1) == ',') {
            String string3 = stringBuffer.toString().trim();
            stringBuffer.delete(0, stringBuffer.length());
            if (string3.length() <= 50) {
                arrayList.add(string3);
            }
        }
        return arrayList;
    }
}

