/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.events;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.setup.EditorPreferences;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.uilogic.frames.AppletPreferencesDialog;
import com.topcoder.client.contestApplet.uilogic.frames.ClearProblemsDialog;
import com.topcoder.client.contestApplet.uilogic.frames.MessageDialog;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.RoomView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public final class MainMenuEvents {
    private ContestApplet ca = null;

    public MainMenuEvents(ContestApplet contestApplet) {
        this.ca = contestApplet;
    }

    public void searchButtonEvent() {
        String string = Common.input("Search", "Enter a username :", this.ca.getMainFrame());
        if (string != null) {
            this.ca.getRequester().requestSearch(string);
        }
    }

    public void aboutEvent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("              TopCoder\n");
        stringBuffer.append("        Competition Arena\n");
        stringBuffer.append("            Version ");
        stringBuffer.append(CommonData.CURRENT_VERSION);
        stringBuffer.append("\n\n");
        stringBuffer.append("      Updated: ");
        stringBuffer.append(CommonData.UPDATE_DATE);
        stringBuffer.append("\n\n");
        stringBuffer.append("     Java Version: ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append("\n\n");
        Common.showMessage("About", stringBuffer.toString(), this.ca.getMainFrame());
    }

    public void changeLogEvent() {
        Object object;
        String string = "";
        try {
            object = new BufferedReader(new InputStreamReader(this.ca.getClass().getResource("CHANGELOG.log").openStream()));
            String string2 = "";
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                string = string + string2 + "\n";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new MessageDialog(this.ca, this.ca.getCurrentFrame(), "ChangeLog", string, true, true);
        ((MessageDialog)object).showDialog();
    }

    public void contestManualEvent() {
        try {
            Common.showURL(this.ca.getAppletContext(), new URL("http://www.topcoder.com/tc?module=Static&d1=help&d2=competitionFaq"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void contestFAQEvent() {
        try {
            Common.showURL(this.ca.getAppletContext(), new URL("http://www.topcoder.com/tc?module=Static&d1=help&d2=competitionFaq"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void contestPluginsEvent() {
        try {
            Common.showURL(this.ca.getAppletContext(), new URL("http://www.topcoder.com/tc?module=Static&d1=applet&d2=plugins"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void activeUsersButtonEvent() {
        this.ca.getRequester().requestActiveUsers();
    }

    public void importantMessagesButtonEvent() {
        this.ca.getRequester().requestImportantMessages();
    }

    public void visitedPracticeEvent() {
        this.ca.getRequester().requestVisitedPractice();
    }

    public void registerButtonEvent() {
        try {
            Common.showURL(this.ca.getAppletContext(), new URL("http://www.topcoder.com/reg/"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void logoffButtonEvent() {
        if (Common.confirm("Warning", "Are you sure you want to logoff?", this.ca.getMainFrame()) && this.ca.getRoomManager().getCurrentRoom().leave()) {
            this.ca.getModel().logoff();
        }
    }

    public void chatToggleEvent() {
        this.ca.getRequester().requestToggleChat();
    }

    public void chatScrollingEvent(ActionEvent actionEvent) {
        LocalPreferences.getInstance().toggleDisableChatScrolling();
        this.ca.setDisableScrollingChat(!this.ca.isScrollingChatDisabled());
    }

    public void leaderTickerEvent(ActionEvent actionEvent) {
        LocalPreferences.getInstance().toggleLeaderTicker();
    }

    public void clearProblemsEvent() {
        RoomModel roomModel = this.ca.getModel().getCurrentRoom();
        if (this.isCodingWindowOpened(roomModel)) {
            Common.showMessage("Error", "You must close the coding window in order to clear the problems.", this.ca.getCurrentFrame());
            return;
        }
        if (Common.confirm("Clear Problems", "Are you sure you wish to clear the problems?", null)) {
            Long l = roomModel.getRoomID();
            this.ca.getRequester().requestClearPractice(l);
        }
    }

    private boolean isCodingWindowOpened(RoomModel roomModel) {
        RoomView roomView = roomModel.getCurrentRoomView();
        return roomView != null && roomView instanceof CoderRoomInterface && ((CoderRoomInterface)((Object)roomView)).isCodingWindowOpened();
    }

    public void clearSelectedProblemEvent() {
        RoomModel roomModel = this.ca.getModel().getCurrentRoom();
        if (this.isCodingWindowOpened(roomModel)) {
            Common.showMessage("Error", "You must close the coding window in order to clear a problem.", this.ca.getCurrentFrame());
            return;
        }
        ClearProblemsDialog clearProblemsDialog = new ClearProblemsDialog(this.ca.getMainFrame(), this.ca);
        Common.setLocationRelativeTo((Component)this.ca.getMainFrame(), (Component)clearProblemsDialog.getFrame().getEventSource());
        clearProblemsDialog.show();
    }

    public void systemTestEvent() {
        String string;
        RoomModel roomModel = this.ca.getModel().getCurrentRoom();
        Coder coder = roomModel.getCoder(string = this.ca.getModel().getUserInfo().getHandle());
        CoderComponent[] coderComponentArray = coder.getComponents();
        if (coderComponentArray != null && coderComponentArray.length > 0) {
            int[] nArray = new int[coderComponentArray.length];
            for (int i = 0; i < coderComponentArray.length; ++i) {
                CoderComponent coderComponent = coderComponentArray[i];
                nArray[i] = coderComponent.getComponent().getID().intValue();
            }
            this.ca.getRequester().requestPracticeSystemTest(roomModel.getRoomID(), nArray);
        } else {
            System.out.println("Unexpected state, CoderComponent[] is null or empty");
        }
    }

    public void statusWindowEvent(ActionEvent actionEvent) {
        ((CoderRoomInterface)((Object)this.ca.getRoomManager().getCurrentRoom())).challengeButtonEvent(actionEvent);
    }

    public void editorOptionsEvent() {
        EditorPreferences editorPreferences = new EditorPreferences(this.ca.getMainFrame());
        Common.setLocationRelativeTo((Component)this.ca.getMainFrame(), editorPreferences);
        editorPreferences.show();
    }

    public void setupUserPreferences() {
        AppletPreferencesDialog appletPreferencesDialog = new AppletPreferencesDialog(this.ca.getMainFrame());
        Common.setLocationRelativeTo((Component)this.ca.getMainFrame(), (Component)appletPreferencesDialog.getFrame().getEventSource());
        appletPreferencesDialog.show();
    }

    public void disableEnterExitMsgsEvent() {
        this.ca.setDisableEnterExitMsgs(!this.ca.isEnterExitMsgsDisabled());
    }

    public void disableAutoEnhancedChat() {
        this.ca.setdisableAutoEnhancedChat(!this.ca.isAutoEnhancedChatDisabled());
    }

    public void disableChatHistory() {
        this.ca.setDisableChatHistory(!this.ca.isChatHistoryDisabled());
    }

    public void disableChatFindTabs() {
        this.ca.setDisableChatFindTabs(!this.ca.isChatFindTabsDisabled());
    }

    public void disableBroadcastPopup() {
        LocalPreferences.getInstance().toggleBroadcastPopup();
    }

    public void disableBroadcastBeep() {
        LocalPreferences.getInstance().toggleBroadcastBeep();
    }

    public void enableTimestamps() {
        LocalPreferences.getInstance().toggleEnableTimestamps();
    }

    public void enabledUnusedCodeCheck() {
        LocalPreferences.getInstance().toggleEnableUnusedCodeCheck();
    }

    public void teamMemberButtonEvent() {
        this.ca.showTeamManagerMember();
    }

    public void teamCaptainButtonEvent() {
        this.ca.showTeamManagerCaptain();
    }
}

