/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors.setup;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.setup.EditorPreferencesTable;
import com.topcoder.client.contestApplet.editors.setup.EditorPreferencesTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class EditorPreferences
extends JDialog
implements ActionListener,
WindowListener {
    JButton addButton = new JButton("Add");
    JButton deleteButton = new JButton("Delete");
    JButton configButton = new JButton("Configure");
    JButton saveButton = new JButton("Save");
    JButton closeButton = new JButton("Close");
    JButton browseButton = new JButton("Browse");
    JTextField commonPath = new JTextField();
    EditorPreferencesTableModel model;
    EditorPreferencesTable table;
    LocalPreferences pref = LocalPreferences.getInstance();
    String origCommonPath;

    public EditorPreferences(JFrame jFrame) {
        super(jFrame, "Editor Preferences", true);
        Common.setLocationRelativeTo((Component)jFrame, this);
        this.model = new EditorPreferencesTableModel(jFrame);
        this.table = new EditorPreferencesTable(this.model);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Container container = this.getContentPane();
        container.setBackground(Common.WPB_COLOR);
        container.setLayout(new GridBagLayout());
        this.origCommonPath = this.pref.getPluginCommonPath();
        if (this.origCommonPath == null) {
            this.origCommonPath = "";
        }
        this.commonPath.setText(this.origCommonPath);
        Dimension dimension = new Dimension(89, 27);
        this.addButton.setMaximumSize(dimension);
        this.deleteButton.setMaximumSize(dimension);
        this.configButton.setMaximumSize(dimension);
        this.closeButton.setMaximumSize(dimension);
        this.browseButton.setMaximumSize(dimension);
        JLabel jLabel = new JLabel("Common ClassPath: ");
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        container.add((Component)this.commonPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 5, 0), 0, 0));
        container.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 10), 0, 0));
        container.add((Component)this.table, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.configButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.saveButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.configButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.endEditing();
        Object object = actionEvent.getSource();
        JTable jTable = this.table.getTable();
        if (object == this.addButton) {
            int n = this.model.addRow();
            if (n >= 0) {
                jTable.setRowSelectionInterval(n, n);
                jTable.scrollRectToVisible(jTable.getCellRect(n, 0, true));
            }
        } else if (object == this.deleteButton) {
            this.model.deleteRow(jTable.getSelectedRow());
        } else if (object == this.configButton) {
            this.pref.setPluginCommonPath(this.commonPath.getText());
            this.model.configure(jTable.getSelectedRow());
        } else if (object == this.saveButton) {
            int n = this.model.save();
            if (n != EditorPreferencesTableModel.SAVESUCCESS && n != EditorPreferencesTableModel.SAVEEXCEPTION) {
                jTable.setRowSelectionInterval(n, n);
            }
        } else if (object == this.closeButton) {
            this.windowClosing(new WindowEvent(this, 201));
        } else if (object == this.browseButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setPreferredSize(new Dimension(500, 300));
            jFileChooser.setMinimumSize(new Dimension(500, 300));
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                if (this.commonPath.getText().equals("")) {
                    this.commonPath.setText(EditorPreferences.getFileNames(jFileChooser.getSelectedFiles()));
                } else {
                    StringBuffer stringBuffer = new StringBuffer(this.commonPath.getText());
                    stringBuffer.append(File.pathSeparator);
                    stringBuffer.append(EditorPreferences.getFileNames(jFileChooser.getSelectedFiles()));
                    this.commonPath.setText(stringBuffer.toString());
                }
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.endEditing();
        if ((this.model.savePending() || !this.commonPath.getText().trim().equals(this.origCommonPath)) && Common.confirm("Save Pending", "Changes are pending.  Do you want to save before closing?", this)) {
            this.pref.setPluginCommonPath(this.commonPath.getText());
            int n = this.model.save();
            if (n == EditorPreferencesTableModel.SAVEEXCEPTION) {
                return;
            }
            if (n != EditorPreferencesTableModel.SAVESUCCESS) {
                this.table.getTable().setRowSelectionInterval(n, n);
                return;
            }
            Common.showMessage("Warning", "You MAY need to close all browsers and restart for any changes to implemented", this);
        }
        try {
            this.pref.reload();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void endEditing() {
        TableCellEditor tableCellEditor;
        this.pref.setPluginCommonPath(this.commonPath.getText());
        JTable jTable = this.table.getTable();
        if (jTable.isEditing() && (tableCellEditor = jTable.getCellEditor(jTable.getEditingRow(), jTable.getEditingColumn())) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private static String getFileNames(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = fileArray.length - 1; i >= 0; --i) {
            String string;
            try {
                string = fileArray[i].getCanonicalPath();
            }
            catch (IOException iOException) {
                string = fileArray[i].getAbsolutePath();
            }
            if (fileArray[i].isDirectory()) {
                string = string + File.separator;
            }
            stringBuffer.append(string);
            if (i <= 0) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }
}

