/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Renderer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class DynamicEditor {
    private static boolean debug = LocalPreferences.getInstance().isEditorDebug();
    private EditorPlugin plugin;
    private Object editor = null;
    private HashMap methodCache;
    private static final String CONFIGURE = "configure";
    private static final String CLEAR = "clear";
    private static final String GETEDITORPANEL = "getEditorPanel";
    private static final String GETSOURCE = "getSource";
    private static final String SETCOMPILERESULTS = "setCompileResults";
    private static final String SETTEXTENABLED = "setTextEnabled";
    private static final String SETLANGUAGE = "setLanguage";
    private static final String SETSOURCE = "setSource";
    private static final String SETPROBLEM = "setProblem";
    private static final String SETSIGNATURE = "setSignature";
    private static final String SETPROBLEMCOMPONENT = "setProblemComponent";
    private static final String SETNAME = "setName";
    private static final String ISCACHEABLE = "isCacheable";
    private static final String STARTUSING = "startUsing";
    private static final String STOPUSING = "stopUsing";
    private static final String DISPOSE = "dispose";
    private static final String INSTALL = "install";
    private static final String UNINSTALL = "uninstall";

    public DynamicEditor(EditorPlugin editorPlugin) throws InstantiationError, NoSuchMethodError {
        Class clazz;
        if (editorPlugin == null) {
            throw this.instantiationError("Null Plugin", "Null Plugin");
        }
        this.plugin = editorPlugin;
        if (debug) {
            System.out.println("Trying to instantiate " + editorPlugin.getName());
        }
        ArrayList arrayList = new ArrayList();
        String string = LocalPreferences.getInstance().getPluginCommonPath();
        if (string == null) {
            string = "";
        }
        this.addURLs(arrayList, string);
        this.addURLs(arrayList, editorPlugin.getClassPath());
        URL[] uRLArray = arrayList.toArray(new URL[0]);
        try {
            CustomLoader customLoader = new CustomLoader(uRLArray);
            try {
                clazz = customLoader.loadClass(editorPlugin.getEntryPoint());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.instantiationError(editorPlugin.getName(), classNotFoundException.toString());
            }
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName(editorPlugin.getEntryPoint());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.instantiationError(editorPlugin.getName(), classNotFoundException.toString());
            }
        }
        this.methodCache = new HashMap();
        this.methodCache.put(CONFIGURE, this.getMethod(clazz, CONFIGURE, null));
        this.methodCache.put(CLEAR, this.getMethod(clazz, CLEAR, null));
        this.methodCache.put(GETEDITORPANEL, this.getMethod(clazz, GETEDITORPANEL, null));
        this.methodCache.put(GETSOURCE, this.getMethod(clazz, GETSOURCE, null));
        this.methodCache.put(SETCOMPILERESULTS, this.getMethod(clazz, SETCOMPILERESULTS, new Class[]{Boolean.class, String.class}));
        this.methodCache.put(SETTEXTENABLED, this.getMethod(clazz, SETTEXTENABLED, new Class[]{Boolean.class}));
        this.methodCache.put(SETLANGUAGE, this.getMethod(clazz, SETLANGUAGE, new Class[]{Integer.class}));
        this.methodCache.put(SETSOURCE, this.getMethod(clazz, SETSOURCE, new Class[]{String.class}));
        this.methodCache.put(SETPROBLEM, this.getMethod(clazz, SETPROBLEM, new Class[]{String.class}));
        this.methodCache.put(SETPROBLEMCOMPONENT, this.getMethod(clazz, SETPROBLEMCOMPONENT, new Class[]{ProblemComponentModel.class, Language.class, Renderer.class}));
        this.methodCache.put(SETSIGNATURE, this.getMethod(clazz, SETSIGNATURE, new Class[]{String.class, String.class, List.class, String.class}));
        this.methodCache.put(SETNAME, this.getMethod(clazz, SETNAME, new Class[]{String.class}));
        this.methodCache.put(ISCACHEABLE, this.getMethod(clazz, ISCACHEABLE, null));
        this.methodCache.put(STARTUSING, this.getMethod(clazz, STARTUSING, null));
        this.methodCache.put(STOPUSING, this.getMethod(clazz, STOPUSING, null));
        this.methodCache.put(DISPOSE, this.getMethod(clazz, DISPOSE, null));
        this.methodCache.put(INSTALL, this.getMethod(clazz, INSTALL, null));
        this.methodCache.put(UNINSTALL, this.getMethod(clazz, UNINSTALL, null));
        if (this.methodCache.get(SETSOURCE) == null) {
            throw this.noSuchMethod(SETSOURCE);
        }
        if (this.methodCache.get(GETSOURCE) == null) {
            throw this.noSuchMethod(GETSOURCE);
        }
        if (this.methodCache.get(GETEDITORPANEL) == null) {
            throw this.noSuchMethod(GETEDITORPANEL);
        }
        try {
            this.editor = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.instantiationError(editorPlugin.getEntryPoint(), illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw this.instantiationError(editorPlugin.getEntryPoint(), instantiationException.toString());
        }
    }

    private void addURLs(ArrayList arrayList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            URL uRL;
            block4: {
                String string2 = stringTokenizer.nextToken();
                try {
                    uRL = new File(string2).toURL();
                    if (!debug) break block4;
                    System.out.println("Adding classpath: " + uRL);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    this.printBadClassPath(this.plugin.getName(), string2);
                    continue;
                }
            }
            arrayList.add(uRL);
        }
    }

    public EditorPlugin getPlugin() {
        return this.plugin;
    }

    public void setTextEnabled(Boolean bl) {
        this.invokeMethod(SETTEXTENABLED, new Object[]{bl});
    }

    public void setSource(String string) {
        this.invokeMethod(SETSOURCE, new Object[]{string});
    }

    public void setLanguage(Integer n) {
        this.invokeMethod(SETLANGUAGE, new Object[]{n});
    }

    public void setProblem(String string) {
        this.invokeMethod(SETPROBLEM, new Object[]{string});
    }

    public void setProblemComponent(ProblemComponentModel problemComponentModel, Language language, Renderer renderer) {
        this.invokeMethod(SETPROBLEMCOMPONENT, new Object[]{problemComponentModel, language, renderer});
    }

    public void setSignature(String string, String string2, List list, String string3) {
        this.invokeMethod(SETSIGNATURE, new Object[]{string, string2, list, string3});
    }

    public void setName(String string) {
        this.invokeMethod(SETNAME, new Object[]{string});
    }

    public JPanel getEditorPanel() {
        try {
            return (JPanel)this.invokeMethod(GETEDITORPANEL, null);
        }
        catch (ClassCastException classCastException) {
            this.printBadRC(GETEDITORPANEL, JPanel.class.toString());
            return null;
        }
    }

    public String getSource() {
        try {
            return (String)this.invokeMethod(GETSOURCE, null);
        }
        catch (ClassCastException classCastException) {
            this.printBadRC(GETSOURCE, String.class.toString());
            return null;
        }
    }

    public void clear() {
        this.invokeMethod(CLEAR, null);
    }

    public void startUsing() {
        this.invokeMethod(STARTUSING, null);
    }

    public void stopUsing() {
        this.invokeMethod(STOPUSING, null);
    }

    public void dispose() {
        this.invokeMethod(DISPOSE, null);
    }

    public void install() {
        this.invokeMethod(INSTALL, null);
    }

    public void uninstall() {
        this.invokeMethod(UNINSTALL, null);
    }

    public boolean isCacheable() {
        if (this.methodCache.get(ISCACHEABLE) == null) {
            return true;
        }
        try {
            return (Boolean)this.invokeMethod(ISCACHEABLE, null);
        }
        catch (ClassCastException classCastException) {
            this.printBadRC(ISCACHEABLE, Boolean.class.toString());
            return true;
        }
    }

    public boolean configure() {
        if (this.methodCache.get(CONFIGURE) == null) {
            return false;
        }
        this.invokeMethod(CONFIGURE, null);
        return true;
    }

    public boolean setCompileResults(boolean bl, String string) {
        if (this.methodCache.get(SETCOMPILERESULTS) == null) {
            return false;
        }
        try {
            return (Boolean)this.invokeMethod(SETCOMPILERESULTS, new Object[]{new Boolean(bl), string});
        }
        catch (ClassCastException classCastException) {
            this.printBadRC(SETCOMPILERESULTS, Boolean.class.toString());
            return false;
        }
    }

    private final Object invokeMethod(String string, Object[] objectArray) {
        if (this.methodCache == null) {
            return null;
        }
        try {
            Method method = (Method)this.methodCache.get(string);
            return method == null ? null : method.invoke(this.editor, objectArray);
        }
        catch (Exception exception) {
            if (objectArray == null) {
                System.err.println("Error invoking method " + string + "()");
            } else {
                System.err.println("Error invoking method " + string + "(" + Arrays.asList(objectArray).toString() + ")");
            }
            exception.fillInStackTrace().printStackTrace();
            return null;
        }
    }

    private final Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            if (debug) {
                System.out.println("Method " + string + " was found");
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug) {
                System.out.println("Method " + string + " was not defined in the plugin editor and will be ignored");
            }
            return null;
        }
    }

    private final void printBadClassPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("The classpath ");
        stringBuffer.append(string2);
        stringBuffer.append(" for the plugin ");
        stringBuffer.append(string);
        stringBuffer.append(" threw a MalFormedURLException and will be ignored.");
        System.err.println(stringBuffer.toString());
    }

    private final void printBadRC(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("Method ");
        stringBuffer.append(string);
        stringBuffer.append(" did not return an object of type ");
        stringBuffer.append(string2);
        stringBuffer.append(".  Returned object ignored.");
        System.err.println(stringBuffer.toString());
    }

    private final NoSuchMethodError noSuchMethod(String string) {
        StringBuffer stringBuffer = new StringBuffer("Required Method: ");
        stringBuffer.append(string);
        stringBuffer.append(" is not defined by the editor plugin.");
        NoSuchMethodError noSuchMethodError = new NoSuchMethodError(stringBuffer.toString());
        noSuchMethodError.fillInStackTrace().printStackTrace();
        return noSuchMethodError;
    }

    private final InstantiationError instantiationError(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("Cannot instantiate ");
        stringBuffer.append(string);
        stringBuffer.append(". ");
        stringBuffer.append(string2);
        InstantiationError instantiationError = new InstantiationError(stringBuffer.toString());
        instantiationError.fillInStackTrace().printStackTrace();
        return instantiationError;
    }

    private final class CustomLoader
    extends URLClassLoader {
        public CustomLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public final Class loadClass(String string) throws ClassNotFoundException {
            try {
                Class<?> clazz = super.findClass(string);
                if (debug) {
                    System.out.println("Loaded from this classloader: " + string);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (debug) {
                    System.out.println("Loaded from parent classloader: " + string);
                }
                return Class.forName(string);
            }
        }
    }
}

