/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.common;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.URLLoader;
import com.topcoder.client.contestApplet.uilogic.frames.ArgInputDialog;
import com.topcoder.client.contestApplet.uilogic.frames.ArrayListInputDialog;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.widgets.ContestListCellRenderer;
import com.topcoder.client.contestApplet.widgets.FillingOvalIcon;
import com.topcoder.client.contestApplet.widgets.MyTitledBorder;
import com.topcoder.client.contestApplet.widgets.NoIcon;
import com.topcoder.client.contestApplet.widgets.OvalIcon;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import com.topcoder.client.contestApplet.widgets.TCIcon;
import com.topcoder.client.contestApplet.widgets.TargetIcon;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.shared.problem.DataType;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Common {
    public static final String COMP_TOPCODER_HS = "TopCoderHS";
    public static final String COMP_TOPCODER = "TopCoder";
    public static final String COMP_GOOGLE = "Google";
    public static final String COMP_VERIZON = "Verizon";
    public static final String COMP_NVIDIA = "Nvidia";
    public static final String COMP_DBLCLK = "DblClk";
    public static final int WIDTH = 795;
    public static final int HEIGHT = 570;
    public static final int SINGLE = 0;
    public static final int TEAM = 1;
    public static final int SINGLE_USER = 0;
    public static final int TEAM_MEMBER = 1;
    public static final int TEAM_CAPTAIN = 2;
    private static final String SERVER_NAME = "www.topcoder.com";
    private static final String HIGHSCHOOL_SERVER_NAME = "highschool.topcoder.com";
    public static final String URL_API = "";
    public static final String URL_MAN = "http://www.topcoder.com/tc?module=Static&d1=help&d2=competitionFaq";
    public static final String URL_PLUGINS = "http://www.topcoder.com/tc?module=Static&d1=applet&d2=plugins";
    public static final String URL_REG = "http://www.topcoder.com/reg/";
    public static final String URL_REG_HS = "http://highschool.topcoder.com?module=Static&d1=registration&d2=registration";
    public static final String URL_SOFTWARE = "http://apps.topcoder.com/wiki/display/tc/The+TopCoder+Platform+-+Software+Application+Development+Methodology";
    public static final String URL_SOFTWARE_DESIGN = "http://apps.topcoder.com/wiki/display/tc/The+TopCoder+Platform+-+Software+Application+Development+Methodology";
    public static final String URL_SOFTWARE_DEVELOPMENT = "http://apps.topcoder.com/wiki/display/tc/The+TopCoder+Platform+-+Software+Application+Development+Methodology";
    public static final String URL_EMPLOYMENT = "http://www.topcoder.com/?&t=tces&c=index";
    public static final String URL_TOPCODER = "http://www.topcoder.com";
    public static final String URL_CMP_FAQ = "http://www.topcoder.com/tc?module=Static&d1=help&d2=competitionFaq";
    private static final Color BLACK = Color.black;
    private static final Color WHITE = Color.white;
    private static final Color GREEN = Color.decode("0xCCFF99");
    private static final Color DARK_GREEN = Color.decode("0x003300");
    public static final Color LIGHT_GREEN = Color.decode("0x006600");
    public static final Color RED = Color.decode("0x990000");
    private static final Color GREY = Color.decode("0x333333");
    public static final Color LIGHT_GREY = Color.decode("0x999999");
    private static final Color MAROON = Color.decode("0x330000");
    public static final Color MENU_COLOR = RED;
    public static final Color STATUS_COLOR = GREEN;
    public static final Color TIMER_COLOR = GREEN;
    public static final Color TOP_BACK = MAROON;
    public static final Color COMPS_RN = GREEN;
    public static final Color COMPS_CN = WHITE;
    public static final Color FG_COLOR = WHITE;
    public static final Color BG_COLOR = BLACK;
    public static final Color MF_COLOR = WHITE;
    public static final Color MB_COLOR = BLACK;
    public static final Color TF_COLOR = WHITE;
    public static final Color TB_COLOR = BLACK;
    public static final Color THF_COLOR = GREEN;
    public static final Color THB_COLOR = GREY;
    public static final Color WPB_COLOR = GREY;
    public static final Color PT_COLOR = GREEN;
    public static final Color PB_COLOR = BLACK;
    public static final Color ID_COLOR = WHITE;
    public static final Color HF_COLOR = WHITE;
    public static final Color HB_COLOR = DARK_GREEN;
    private static final Color NE_COLOR = GREEN;
    public static final String DEFFONT = "Monospaced";
    public static final String[] legendLabels = new String[]{"2200+", "1500-2199", "1200-1499", "0900-1199", "0001-0899", "NON-RATED", "ADMIN"};
    public static final int[] legendRanks = new int[]{2200, 1500, 1200, 900, 1, 0, -1};
    private static final int[] rankBreaks = new int[]{3000, 2200, 1500, 1200, 900, 1, 0, Integer.MIN_VALUE};
    public static final Color CODER_RED = Color.decode("0xee0000");
    public static final Color CODER_YELLOW = Color.decode("0xddcc00");
    public static final Color CODER_BLUE = Color.decode("0x6666ff");
    public static final Color CODER_GREEN = Color.decode("0x00a900");
    public static final Color CODER_GREY = Color.decode("0x999999");
    public static final Color CODER_WHITE = Color.white;
    public static final Color CODER_ADMIN = Color.decode("0xff9900");
    private static final Color[] rankColors = new Color[]{CODER_RED, CODER_RED, CODER_YELLOW, CODER_BLUE, CODER_GREEN, CODER_GREY, CODER_WHITE, CODER_ADMIN};
    private static final Class[] rankIcons = new Class[]{TargetIcon.class, FillingOvalIcon.class, FillingOvalIcon.class, FillingOvalIcon.class, FillingOvalIcon.class, FillingOvalIcon.class, NoIcon.class, NoIcon.class};
    public static final int MAX_CHAT = 200;
    public static final int MAX_NOSCROLL_CHAT = 2000;
    private static final String prepend = "<HTML><BODY BGCOLOR=\"#000000\" TEXT=\"#FFFFFF\" LINK=\"#D00000\" ALINK=\"#FF0000\" VLINK=\"#900000\">";
    private static final String append = "</BODY></HTML>";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yy hh:mmaaa z");
    private static NumberFormat scoreFormat = new DecimalFormat("####0.00");
    private static NumberFormat noFractionsFormat = new DecimalFormat("####0");

    public static String replaceAll(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        String string4 = string3;
        while (n != -1) {
            n = string4.indexOf(string, n2);
            if (n == -1) continue;
            if (n + string.length() == string4.length() || !Character.isLetter(string4.charAt(n + string.length()))) {
                string4 = string4.substring(0, n) + string2 + string4.substring(n + string.length());
                n2 = n + string2.length();
                continue;
            }
            n2 = n + string.length();
        }
        return string4;
    }

    public static JLabel getCoderLabel(String string, int n) {
        Color color = Common.getRankColor(n);
        JLabel jLabel = new JLabel(string, Common.getRankIcon(n), 2);
        jLabel.setForeground(color);
        if (n == -1) {
            jLabel.setFont(new Font(URL_API, 3, 13));
        }
        return jLabel;
    }

    public static Color getRankColor(int n) {
        for (int i = 0; i < rankBreaks.length; ++i) {
            if (n < rankBreaks[i]) continue;
            return rankColors[i];
        }
        return Color.white;
    }

    public static Icon getRankIcon(int n) {
        for (int i = 0; i < rankBreaks.length; ++i) {
            if (n < rankBreaks[i]) continue;
            try {
                Icon icon = (Icon)rankIcons[i].newInstance();
                if (icon instanceof TCIcon) {
                    ((TCIcon)icon).setForeground(Common.getRankColor(n));
                }
                if (icon instanceof FillingOvalIcon) {
                    double d = (double)(n - rankBreaks[i]) / (double)((i == 0 ? rankBreaks[i] * 2 : rankBreaks[i - 1]) - rankBreaks[i]);
                    ((FillingOvalIcon)icon).setPercentage(d);
                }
                return icon;
            }
            catch (Exception exception) {
                return new OvalIcon(Color.white);
            }
        }
        return new OvalIcon(Color.white);
    }

    public static ImageIcon getImage(String string, Object object) {
        return Common.getImage(string, object.getClass());
    }

    public static ImageIcon getImage(String string, Class clazz) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(clazz.getResource("images/" + string)));
        }
        catch (Exception exception) {
            imageIcon = new ImageIcon();
        }
        return imageIcon;
    }

    public static JButton getTextButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setForeground(NE_COLOR);
        jButton.setBackground(Color.black);
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    public static JButton getButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setForeground(Color.white);
        jButton.setBackground(Color.black);
        return jButton;
    }

    public static JButton getImageButton(String string, Object object) {
        JButton jButton = new JButton(Common.getImage(string, object));
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        return jButton;
    }

    public static String htmlEncode(String string) {
        StringBuffer stringBuffer = Common.htmlEncodeNoHeaders(string);
        return prepend + stringBuffer.toString() + append;
    }

    public static StringBuffer htmlEncodeNoHeaders(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            c = c2;
            if (c2 == '\\' && !bl) {
                bl = true;
                c = string.charAt(++i);
            }
            if (!bl) {
                stringBuffer.append(c);
            } else if (c == '\\') {
                stringBuffer.append('\\');
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\t') {
                stringBuffer.append("  ");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '\n' || c == '\r') {
                stringBuffer.append(c);
            } else if (c < ' ') {
                stringBuffer.append("[\\u" + c + "]");
            } else if (c > '~' && c < '\u00a0') {
                stringBuffer.append("[\\u" + c + "]");
            } else if (c >= '\u00a0' && c <= '\u00ff') {
                stringBuffer.append("&#" + c + ";");
            } else if (c > '\u00ff') {
                stringBuffer.append("[\\u" + c + "]");
            } else {
                stringBuffer.append(c);
            }
            bl = false;
        }
        return stringBuffer;
    }

    public static void showURL(AppletContext appletContext, URL uRL) {
        boolean bl = false;
        try {
            bl = URLLoader.showURL(uRL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!bl) {
                appletContext.showDocument(uRL, "_blank");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static JCheckBox getCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setBackground(Color.black);
        jCheckBox.setForeground(Color.white);
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    public static TitledBorder getTitledBorder(String string) {
        RoundBorder roundBorder = new RoundBorder(PB_COLOR, 5, true);
        MyTitledBorder myTitledBorder = new MyTitledBorder(roundBorder, string, 1, 1);
        myTitledBorder.setTitleColor(PT_COLOR);
        return myTitledBorder;
    }

    public static void insertInPanel(JComponent jComponent, Container container, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static void insertInPanel(JComponent jComponent, Container container, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        Common.insertInPanel(jComponent, container, gridBagConstraints, n, n2, n3, n4);
    }

    public static GridBagConstraints getDefaultConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        return gridBagConstraints;
    }

    public static void setLocationRelativeTo(Component component, Component component2) {
        component2.setLocation(component.getX() + (component.getWidth() / 2 - component2.getWidth() / 2), component.getY() + (component.getHeight() / 2 - component2.getHeight() / 2));
    }

    public static void setLocationRelativeTo(UIComponent uIComponent, UIComponent uIComponent2) {
        uIComponent2.setProperty("Location", new Point((Integer)uIComponent.getProperty("X") + ((Integer)uIComponent.getProperty("Width") / 2 - (Integer)uIComponent2.getProperty("Width") / 2), (Integer)uIComponent.getProperty("Y") + ((Integer)uIComponent.getProperty("Height") / 2 - (Integer)uIComponent2.getProperty("Height") / 2)));
    }

    public static void setLocationRelativeTo(Component component, UIComponent uIComponent) {
        uIComponent.setProperty("Location", new Point(component.getX() + component.getWidth() / 2 - (Integer)uIComponent.getProperty("Width") / 2, component.getY() + component.getHeight() / 2 - (Integer)uIComponent.getProperty("Height") / 2));
    }

    public static void showMessage(String string, String string2, Component component) {
        JOptionPane.showMessageDialog(component, string2, string, 1);
    }

    public static boolean confirm(String string, String string2, Component component) {
        int n = JOptionPane.showConfirmDialog(component, string2, string, 0, 2);
        return n == 0;
    }

    public static String formatTime(long l) {
        return dateFormatter.format(new Date(l));
    }

    public static ArrayList showArrayListInput(ContestApplet contestApplet, UIComponent uIComponent, String string) {
        return Common.showArrayListInput(contestApplet, uIComponent, new ArrayList(), string);
    }

    public static ArrayList showArrayListInput(ContestApplet contestApplet, UIComponent uIComponent, ArrayList arrayList, String string) {
        ArrayListInputDialog arrayListInputDialog = new ArrayListInputDialog(contestApplet, uIComponent, arrayList, string);
        ArrayList arrayList2 = arrayListInputDialog.showDialog();
        return arrayList2;
    }

    public static void showArgInput(ContestApplet contestApplet, DataType[] dataTypeArray, ArrayList arrayList, FrameLogic frameLogic, boolean bl) {
        ArgInputDialog argInputDialog = new ArgInputDialog(contestApplet, frameLogic, dataTypeArray, arrayList, bl);
        argInputDialog.showDialog();
    }

    public static void showArgInput(ContestApplet contestApplet, String string, DataType[] dataTypeArray, FrameLogic frameLogic, boolean bl) {
        ArgInputDialog argInputDialog = new ArgInputDialog(contestApplet, frameLogic, string, dataTypeArray, bl);
        argInputDialog.showDialog();
    }

    public static void showArgInput(ContestApplet contestApplet, String string, DataType[] dataTypeArray, FrameLogic frameLogic, boolean bl, String[] stringArray) {
        ArgInputDialog argInputDialog = new ArgInputDialog(contestApplet, frameLogic, string, dataTypeArray, bl, stringArray);
        argInputDialog.showDialog();
    }

    public static void showArgInput(ContestApplet contestApplet, DataType[] dataTypeArray, FrameLogic frameLogic, boolean bl) {
        ArgInputDialog argInputDialog = new ArgInputDialog(contestApplet, frameLogic, dataTypeArray, bl);
        argInputDialog.showDialog();
    }

    public static void showArgInput(ContestApplet contestApplet, String string, DataType[] dataTypeArray, ArrayList arrayList, FrameLogic frameLogic, boolean bl, ProblemComponentModel problemComponentModel, int n) {
        ArgInputDialog argInputDialog = new ArgInputDialog(contestApplet, frameLogic, dataTypeArray, string, arrayList, bl, problemComponentModel, n);
        argInputDialog.showDialog();
    }

    public static void showArgInput(ContestApplet contestApplet, String string, DataType[] dataTypeArray, ArrayList arrayList, FrameLogic frameLogic, boolean bl, ProblemComponentModel problemComponentModel) {
        Common.showArgInput(contestApplet, string, dataTypeArray, arrayList, frameLogic, bl, problemComponentModel, 1);
    }

    public static String input(String string, String string2, Component component) {
        String string3 = JOptionPane.showInputDialog(component, string2, string, 3);
        return string3;
    }

    public static JPanel createMessagePanel(String string, JTextArea jTextArea, int n, int n2, Color color) {
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        jTextArea.setSelectedTextColor(HF_COLOR);
        jTextArea.setSelectionColor(HB_COLOR);
        jTextArea.setBackground(MB_COLOR);
        jTextArea.setForeground(MF_COLOR);
        jTextArea.setCaretPosition(0);
        jScrollPane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jPanel.setBorder(Common.getTitledBorder(string));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        Common.insertInPanel(jScrollPane, jPanel, gridBagConstraints, 0, 0, 1, 1);
        jPanel.setBackground(WPB_COLOR);
        jPanel.setOpaque(true);
        return jPanel;
    }

    public static JPanel createMessagePanel(String string, JEditorPane jEditorPane, int n, int n2, Color color) {
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jEditorPane.setEditable(false);
        jEditorPane.setMargin(new Insets(5, 5, 5, 5));
        jEditorPane.setSelectedTextColor(HF_COLOR);
        jEditorPane.setSelectionColor(HB_COLOR);
        jEditorPane.setBackground(MB_COLOR);
        jEditorPane.setForeground(MF_COLOR);
        jScrollPane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jPanel.setBorder(Common.getTitledBorder(string));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        Common.insertInPanel(jScrollPane, jPanel, gridBagConstraints, 0, 0, 1, 1);
        jPanel.setBackground(WPB_COLOR);
        jPanel.setOpaque(true);
        return jPanel;
    }

    public static JPanel createMessagePanel(String string, JScrollPane jScrollPane, int n, int n2, Color color) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jScrollPane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jPanel.setBorder(Common.getTitledBorder(string));
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setBackground(color);
        Common.insertInPanel(jScrollPane, jPanel, gridBagConstraints, 0, 0, 1, 1);
        jPanel.setBackground(WPB_COLOR);
        jPanel.setOpaque(true);
        return jPanel;
    }

    public static JPanel createColumnarMessagePanel(String string, JTextArea[] jTextAreaArray, int n, int n2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        for (int i = 0; i < jTextAreaArray.length; ++i) {
            jTextAreaArray[i].setEditable(false);
            jTextAreaArray[i].setLineWrap(true);
            jTextAreaArray[i].setWrapStyleWord(true);
            jTextAreaArray[i].setMargin(new Insets(5, 5, 5, 5));
            jTextAreaArray[i].setSelectedTextColor(HF_COLOR);
            jTextAreaArray[i].setSelectionColor(HB_COLOR);
            jTextAreaArray[i].setBackground(MB_COLOR);
            jTextAreaArray[i].setForeground(MF_COLOR);
            jTextAreaArray[i].setPreferredSize(new Dimension(n, n2));
            Common.insertInPanel(jTextAreaArray[i], jPanel2, gridBagConstraints, i, 0, 1, 1, 0.1, 0.1);
        }
        jPanel2.setPreferredSize(new Dimension(jTextAreaArray.length * n, n2));
        jPanel2.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jScrollPane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jPanel.setBorder(Common.getTitledBorder(string));
        Common.insertInPanel(jScrollPane, jPanel, gridBagConstraints, 0, 0, 1, 1);
        jPanel.setBackground(WPB_COLOR);
        return jPanel;
    }

    public static JComboBox createComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setBackground(WPB_COLOR);
        jComboBox.setForeground(Color.white);
        jComboBox.setBorder(new EmptyBorder(-1, -1, -1, -1));
        jComboBox.setRenderer(new ContestListCellRenderer());
        return jComboBox;
    }

    public static Point adjustWindowLocation(Point point) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            try {
                if (graphicsDevice.getType() != 0 || graphicsDevice.getDisplayMode() == null) continue;
                bl = true;
                rectangle.width = graphicsDevice.getDisplayMode().getWidth();
                rectangle.height = graphicsDevice.getDisplayMode().getHeight();
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (!bl) {
            return point;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.x > rectangle.width + rectangle.x - 125) {
            point.x = rectangle.width - 125;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        if (point.y > rectangle.height + rectangle.y - 125) {
            point.y = rectangle.height - 125;
        }
        return point;
    }

    public static Dimension adjustWindowSize(Point point, Dimension dimension) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            try {
                if (graphicsDevice.getType() != 0 || graphicsDevice.getDisplayMode() == null) continue;
                bl = true;
                rectangle.width = graphicsDevice.getDisplayMode().getWidth();
                rectangle.height = graphicsDevice.getDisplayMode().getHeight();
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (!bl) {
            return dimension;
        }
        if (dimension.width < 0) {
            dimension.width = 600;
        }
        if (dimension.width + point.x > rectangle.width + rectangle.x) {
            dimension.width = rectangle.width + rectangle.x - point.x;
        }
        if (dimension.height < 0) {
            dimension.height = 400;
        }
        if (dimension.height + point.y > rectangle.height + rectangle.y) {
            dimension.height = rectangle.height + rectangle.y - point.y;
        }
        return dimension;
    }

    public static Vector enumerateFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector;
    }

    public static boolean isAdmin(int n) {
        return n < 0;
    }

    public static NumberFormat newScoreFormat() {
        return new DecimalFormat("####0.00");
    }

    public static String formatScore(double d) {
        return scoreFormat.format(d);
    }

    public static String formatNoFractions(Double d) {
        return noFractionsFormat.format(d);
    }

    public static String formatNoFractions(double d) {
        return noFractionsFormat.format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLContent(URL uRL) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StringBuffer stringBuffer = new StringBuffer(1000);
        try {
            char[] cArray = new char[1000];
            int n = 0;
            while ((n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        finally {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }
}

